/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;

public class ObservableHelper
implements Observable,
InvalidationListener {
    private List<InvalidationListener> listeners = new CopyOnWriteArrayList<InvalidationListener>();
    private Observable source;

    public ObservableHelper() {
        this.source = this;
    }

    public ObservableHelper(Observable source) {
        this.source = source;
    }

    public void addListener(InvalidationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.listeners.remove(listener);
    }

    public void invalidate() {
        this.listeners.forEach(it -> it.invalidated(this.source));
    }

    public void invalidated(Observable observable) {
        this.invalidate();
    }

    public void receiveUpdatesFrom(Observable observable) {
        observable.removeListener((InvalidationListener)this);
        observable.addListener((InvalidationListener)this);
    }
}

