/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class StringUtils {
    public static int MAX_SHORT_STRING_LENGTH = 77;
    public static final Pattern CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    public static final CharsetEncoder US_ASCII_ENCODER = StandardCharsets.US_ASCII.newEncoder();

    private StringUtils() {
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(512);
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public static String getStackTrace(StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : elements) {
            builder.append("\tat ").append(element).append(OperatingSystem.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String substringBeforeLast(String str, char delimiter) {
        return StringUtils.substringBeforeLast(str, delimiter, str);
    }

    public static String substringBeforeLast(String str, char delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringBeforeLast(String str, String delimiter) {
        return StringUtils.substringBeforeLast(str, delimiter, str);
    }

    public static String substringBeforeLast(String str, String delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringBefore(String str, char delimiter) {
        return StringUtils.substringBefore(str, delimiter, str);
    }

    public static String substringBefore(String str, char delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringBefore(String str, String delimiter) {
        return StringUtils.substringBefore(str, delimiter, str);
    }

    public static String substringBefore(String str, String delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringAfterLast(String str, char delimiter) {
        return StringUtils.substringAfterLast(str, delimiter, "");
    }

    public static String substringAfterLast(String str, char delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + 1);
    }

    public static String substringAfterLast(String str, String delimiter) {
        return StringUtils.substringAfterLast(str, delimiter, "");
    }

    public static String substringAfterLast(String str, String delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + delimiter.length());
    }

    public static String substringAfter(String str, char delimiter) {
        return StringUtils.substringAfter(str, delimiter, "");
    }

    public static String substringAfter(String str, char delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + 1);
    }

    public static String substringAfter(String str, String delimiter) {
        return StringUtils.substringAfter(str, delimiter, "");
    }

    public static String substringAfter(String str, String delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + delimiter.length());
    }

    public static boolean isSurrounded(String str, String prefix, String suffix) {
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static String removeSurrounding(String str, String delimiter) {
        return StringUtils.removeSurrounding(str, delimiter, delimiter);
    }

    public static String removeSurrounding(String str, String prefix, String suffix) {
        if (str.length() >= prefix.length() + suffix.length() && str.startsWith(prefix) && str.endsWith(suffix)) {
            return str.substring(prefix.length(), str.length() - suffix.length());
        }
        return str;
    }

    public static String addPrefix(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str;
        }
        return prefix + str;
    }

    public static String addSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static String removePrefix(String str, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!str.startsWith(prefix)) continue;
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!str.endsWith(suffix)) continue;
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static boolean containsOne(Collection<String> patterns, String ... targets) {
        for (String pattern : patterns) {
            for (String target : targets) {
                if (!pattern.toLowerCase().contains(target.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOne(String pattern, String ... targets) {
        for (String target : targets) {
            if (!pattern.toLowerCase().contains(target.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOne(String pattern, char ... targets) {
        for (char target : targets) {
            if (pattern.toLowerCase().indexOf(Character.toLowerCase(target)) < 0) continue;
            return true;
        }
        return false;
    }

    public static List<String> tokenize(String str) {
        if (str == null) {
            return new ArrayList<String>();
        }
        return StringUtils.tokenize(str, " \t\n\r\f");
    }

    public static List<String> tokenize(String str, String delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            delim = tokenizer.nextToken();
            result.add(delim);
        }
        return result;
    }

    public static String parseColorEscapes(String original) {
        return original.replaceAll("\u00a7\\d", "");
    }

    public static String parseEscapeSequence(String str) {
        StringBuilder builder = new StringBuilder();
        boolean inEscape = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\u001b') {
                inEscape = true;
            }
            if (!inEscape) {
                builder.append(ch);
            }
            if (!inEscape || ch != 'm') continue;
            inEscape = false;
        }
        return builder.toString();
    }

    public static String repeats(char ch, int repeat) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < repeat; ++i) {
            result.append(ch);
        }
        return result.toString();
    }

    public static Optional<String> truncate(String str) {
        if (str.length() <= MAX_SHORT_STRING_LENGTH) {
            return Optional.empty();
        }
        int halfLength = (MAX_SHORT_STRING_LENGTH - 5) / 2;
        return Optional.of(str.substring(0, halfLength) + " ... " + str.substring(str.length() - halfLength));
    }

    public static boolean isASCII(CharSequence cs) {
        return US_ASCII_ENCODER.canEncode(cs);
    }

    public static class LongestCommonSubsequence {
        private final int[][] f;
        private final int maxLengthA;
        private final int maxLengthB;

        public LongestCommonSubsequence(int maxLengthA, int maxLengthB) {
            this.maxLengthA = maxLengthA;
            this.maxLengthB = maxLengthB;
            this.f = new int[maxLengthA + 1][];
            for (int i = 0; i <= maxLengthA; ++i) {
                this.f[i] = new int[maxLengthB + 1];
            }
        }

        public int calc(CharSequence a, CharSequence b) {
            if (a.length() > this.maxLengthA || b.length() > this.maxLengthB) {
                throw new IllegalArgumentException("Too large length");
            }
            for (int i = 1; i <= a.length(); ++i) {
                for (int j = 1; j <= b.length(); ++j) {
                    this.f[i][j] = a.charAt(i - 1) == b.charAt(j - 1) ? 1 + this.f[i - 1][j - 1] : Math.max(this.f[i - 1][j], this.f[i][j - 1]);
                }
            }
            return this.f[a.length()][b.length()];
        }
    }
}

