/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.jackhuang.hmcl.util.StringUtils;

public final class Logging {
    public static final Logger LOG = Logger.getLogger("HMCL");
    private static final ByteArrayOutputStream storedLogs = new ByteArrayOutputStream(8192);

    private Logging() {
    }

    public static void start(Path logFolder) {
        LOG.setLevel(Level.ALL);
        LOG.setUseParentHandlers(false);
        try {
            Files.createDirectories(logFolder, new FileAttribute[0]);
            FileHandler fileHandler = new FileHandler(logFolder.resolve("hmcl.log").toAbsolutePath().toString());
            fileHandler.setLevel(Level.FINEST);
            fileHandler.setFormatter(DefaultFormatter.INSTANCE);
            fileHandler.setEncoding("UTF-8");
            LOG.addHandler(fileHandler);
        }
        catch (IOException e) {
            System.err.println("Unable to create hmcl.log, " + e.getMessage());
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(DefaultFormatter.INSTANCE);
        consoleHandler.setLevel(Level.FINER);
        LOG.addHandler(consoleHandler);
        StreamHandler streamHandler = new StreamHandler(storedLogs, DefaultFormatter.INSTANCE){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        try {
            streamHandler.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        streamHandler.setLevel(Level.ALL);
        LOG.addHandler(streamHandler);
    }

    public static void initForTest() {
        LOG.setLevel(Level.ALL);
        LOG.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(DefaultFormatter.INSTANCE);
        consoleHandler.setLevel(Level.FINER);
        LOG.addHandler(consoleHandler);
    }

    public static byte[] getRawLogs() {
        return storedLogs.toByteArray();
    }

    public static String getLogs() {
        try {
            return storedLogs.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e);
        }
    }

    private static final class DefaultFormatter
    extends Formatter {
        static final DefaultFormatter INSTANCE = new DefaultFormatter();
        private static final MessageFormat format = new MessageFormat("[{0,date,HH:mm:ss}] [{1}.{2}/{3}] {4}\n");

        private DefaultFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String log = format.format(new Object[]{new Date(record.getMillis()), record.getSourceClassName(), record.getSourceMethodName(), record.getLevel().getName(), record.getMessage()}, new StringBuffer(128), (FieldPosition)null).toString();
            if (record.getThrown() != null) {
                log = log + StringUtils.getStackTrace(record.getThrown());
            }
            return log;
        }
    }
}

