/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXCheckBox;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.WorldListItem;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public class WorldListPage
extends ListPageBase<WorldListItem>
implements VersionPage.VersionLoadable {
    private final BooleanProperty showAll = new SimpleBooleanProperty((Object)this, "showAll", false);
    private Path savesDir;
    private List<World> worlds;
    private Profile profile;
    private String id;
    private String gameVersion;

    public WorldListPage() {
        FXUtils.applyDragListener((Node)this, it -> "zip".equals(FileUtils.getExtension(it)), modpacks -> this.installWorld((File)modpacks.get(0)));
        this.showAll.addListener(e -> {
            if (this.worlds != null) {
                this.itemsProperty().setAll((Collection)this.worlds.stream().filter(world -> this.isShowAll() || world.getGameVersion() == null || world.getGameVersion().equals(this.gameVersion)).map(WorldListItem::new).collect(Collectors.toList()));
            }
        });
    }

    protected ToolbarListPageSkin<WorldListPage> createDefaultSkin() {
        return new WorldListPageSkin();
    }

    @Override
    public void loadVersion(Profile profile, String id) {
        this.profile = profile;
        this.id = id;
        this.savesDir = profile.getRepository().getRunDirectory(id).toPath().resolve("saves");
        this.refresh();
    }

    public CompletableFuture<?> refresh() {
        if (this.profile == null || this.id == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.setLoading(true);
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            this.gameVersion = this.profile.getRepository().getGameVersion(this.id).orElse(null);
        }).thenApplyAsync(unused -> {
            try (Stream<World> stream = World.getWorlds(this.savesDir);){
                List list = ((Stream)stream.parallel()).collect(Collectors.toList());
                return list;
            }
        })).whenCompleteAsync((result, exception) -> {
            this.worlds = result;
            this.setLoading(false);
            if (exception == null) {
                this.itemsProperty().setAll((Collection)result.stream().filter(world -> this.isShowAll() || world.getGameVersion() == null || world.getGameVersion().equals(this.gameVersion)).map(WorldListItem::new).collect(Collectors.toList()));
            }
            System.gc();
        }, Platform::runLater);
    }

    public void add() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("world.import.choose"));
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18n.i18n("world.extension"), new String[]{"*.zip"})});
        List res = chooser.showOpenMultipleDialog((Window)Controllers.getStage());
        if (res == null || res.isEmpty()) {
            return;
        }
        this.installWorld((File)res.get(0));
    }

    public void download() {
        Controllers.getDownloadPage().showWorldDownloads();
        Controllers.navigate((Node)Controllers.getDownloadPage());
    }

    private void installWorld(File zipFile) {
        Task.supplyAsync(() -> new World(zipFile.toPath())).whenComplete(Schedulers.javafx(), world -> Controllers.prompt(I18n.i18n("world.name.enter"), (name, resolve, reject) -> Task.runAsync(() -> world.install(this.savesDir, (String)name)).whenComplete(Schedulers.javafx(), () -> {
            this.itemsProperty().add((Object)new WorldListItem(new World(this.savesDir.resolve((String)name))));
            resolve.run();
        }, e -> {
            if (e instanceof FileAlreadyExistsException) {
                reject.accept(I18n.i18n("world.import.failed", I18n.i18n("world.import.already_exists")));
            } else if (e instanceof IOException && e.getCause() instanceof InvalidPathException) {
                reject.accept(I18n.i18n("world.import.failed", I18n.i18n("install.new_game.malformed")));
            } else {
                reject.accept(I18n.i18n("world.import.failed", e.getClass().getName() + ": " + e.getLocalizedMessage()));
            }
        }).start(), world.getWorldName()), e -> {
            Logging.LOG.log(Level.WARNING, "Unable to parse world file " + zipFile, (Throwable)e);
            Controllers.dialog(I18n.i18n("world.import.invalid"));
        }).start();
    }

    public boolean isShowAll() {
        return this.showAll.get();
    }

    public BooleanProperty showAllProperty() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll.set(showAll);
    }

    private class WorldListPageSkin
    extends ToolbarListPageSkin<WorldListPage> {
        WorldListPageSkin() {
            super(WorldListPage.this);
        }

        @Override
        protected List<Node> initializeToolbar(WorldListPage skinnable) {
            JFXCheckBox chkShowAll = new JFXCheckBox();
            chkShowAll.setText(I18n.i18n("world.show_all"));
            chkShowAll.selectedProperty().bindBidirectional((Property)skinnable.showAllProperty());
            Node[] nodeArray = new Node[4];
            nodeArray[0] = chkShowAll;
            nodeArray[1] = WorldListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG::refresh, skinnable::refresh);
            nodeArray[2] = WorldListPageSkin.createToolbarButton2(I18n.i18n("world.add"), SVG::plus, skinnable::add);
            nodeArray[3] = WorldListPageSkin.createToolbarButton2(I18n.i18n("world.download"), SVG::plus, skinnable::download);
            return Arrays.asList(nodeArray);
        }
    }
}

