/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.IOUtils;

public final class ModTranslations {
    private static List<Mod> mods;
    private static Map<String, Mod> modIdMap;
    private static Map<String, Mod> curseForgeMap;
    private static List<Pair<String, Mod>> keywords;
    private static int maxKeywordLength;

    private ModTranslations() {
    }

    public static Mod getModByCurseForgeId(String id) {
        if (StringUtils.isBlank(id) || !ModTranslations.loadCurseForgeMap()) {
            return null;
        }
        return curseForgeMap.get(id);
    }

    public static Mod getModById(String id) {
        if (StringUtils.isBlank(id) || !ModTranslations.loadModIdMap()) {
            return null;
        }
        return modIdMap.get(id);
    }

    public static List<Mod> searchMod(String query) {
        if (!ModTranslations.loadKeywords()) {
            return Collections.emptyList();
        }
        StringBuilder newQuery = query.chars().filter(ch -> !Character.isSpaceChar(ch)).collect(StringBuilder::new, (sb, value) -> sb.append((char)value), StringBuilder::append);
        query = newQuery.toString();
        StringUtils.LongestCommonSubsequence lcs = new StringUtils.LongestCommonSubsequence(query.length(), maxKeywordLength);
        ArrayList<Pair<Integer, Mod>> modList = new ArrayList<Pair<Integer, Mod>>();
        for (Pair<String, Mod> keyword : keywords) {
            int value2 = lcs.calc(query, keyword.getKey());
            if (value2 < Math.max(1, query.length() - 3)) continue;
            modList.add(Pair.pair(value2, keyword.getValue()));
        }
        return modList.stream().sorted((a, b) -> -((Integer)a.getKey()).compareTo((Integer)b.getKey())).map(Pair::getValue).collect(Collectors.toList());
    }

    private static boolean loadFromResource() {
        if (mods != null) {
            return true;
        }
        try {
            String modData = IOUtils.readFullyAsString(ModTranslations.class.getResourceAsStream("/assets/mod_data.txt"), StandardCharsets.UTF_8);
            mods = Arrays.stream(modData.split("\n")).filter(line -> !line.startsWith("#")).map(Mod::new).collect(Collectors.toList());
            return true;
        }
        catch (Exception e) {
            Logging.LOG.log(Level.WARNING, "Failed to load /assets/mod_data.txt", e);
            return false;
        }
    }

    private static boolean loadCurseForgeMap() {
        if (curseForgeMap != null) {
            return true;
        }
        if (mods == null && !ModTranslations.loadFromResource()) {
            return false;
        }
        curseForgeMap = new HashMap<String, Mod>();
        for (Mod mod : mods) {
            if (!StringUtils.isNotBlank(mod.getCurseforge())) continue;
            curseForgeMap.put(mod.getCurseforge(), mod);
        }
        return true;
    }

    private static boolean loadModIdMap() {
        if (modIdMap != null) {
            return true;
        }
        if (mods == null && !ModTranslations.loadFromResource()) {
            return false;
        }
        modIdMap = new HashMap<String, Mod>();
        for (Mod mod : mods) {
            for (String id : mod.getModIds()) {
                if (!StringUtils.isNotBlank(id) || "examplemod".equals(id)) continue;
                modIdMap.put(id, mod);
            }
        }
        return true;
    }

    private static boolean loadKeywords() {
        if (keywords != null) {
            return true;
        }
        if (mods == null && !ModTranslations.loadFromResource()) {
            return false;
        }
        keywords = new ArrayList<Pair<String, Mod>>();
        maxKeywordLength = -1;
        for (Mod mod : mods) {
            if (StringUtils.isNotBlank(mod.getName())) {
                keywords.add(Pair.pair(mod.getName(), mod));
                maxKeywordLength = Math.max(maxKeywordLength, mod.getName().length());
            }
            if (StringUtils.isNotBlank(mod.getSubname())) {
                keywords.add(Pair.pair(mod.getSubname(), mod));
                maxKeywordLength = Math.max(maxKeywordLength, mod.getSubname().length());
            }
            if (!StringUtils.isNotBlank(mod.getAbbr())) continue;
            keywords.add(Pair.pair(mod.getAbbr(), mod));
            maxKeywordLength = Math.max(maxKeywordLength, mod.getAbbr().length());
        }
        return true;
    }

    static {
        maxKeywordLength = -1;
    }

    public static class Mod {
        private final String curseforge;
        private final String mcmod;
        private final String mcbbs;
        private final List<String> modIds;
        private final String name;
        private final String subname;
        private final String abbr;

        public Mod(String line) {
            String[] items = line.split(";", -1);
            if (items.length != 7) {
                throw new IllegalArgumentException("Illegal mod data line, 7 items expected " + line);
            }
            this.curseforge = items[0];
            this.mcmod = items[1];
            this.mcbbs = items[2];
            this.modIds = Collections.unmodifiableList(Arrays.asList(items[3].split(",")));
            this.name = items[4];
            this.subname = items[5];
            this.abbr = items[6];
        }

        public Mod(String curseforge, String mcmod, String mcbbs, List<String> modIds, String name, String subname, String abbr) {
            this.curseforge = curseforge;
            this.mcmod = mcmod;
            this.mcbbs = mcbbs;
            this.modIds = modIds;
            this.name = name;
            this.subname = subname;
            this.abbr = abbr;
        }

        public String getDisplayName() {
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank(this.abbr)) {
                builder.append("[").append(this.abbr.trim()).append("] ");
            }
            builder.append(this.name);
            if (StringUtils.isNotBlank(this.subname)) {
                builder.append(" (").append(this.subname).append(")");
            }
            return builder.toString();
        }

        public String getCurseforge() {
            return this.curseforge;
        }

        public String getMcmod() {
            return this.mcmod;
        }

        public String getMcbbs() {
            return this.mcbbs;
        }

        public List<String> getModIds() {
            return this.modIds;
        }

        public String getName() {
            return this.name;
        }

        public String getSubname() {
            return this.subname;
        }

        public String getAbbr() {
            return this.abbr;
        }
    }
}

