/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.task.Task;

public class ModCheckUpdatesTask
extends Task<List<LocalModFile.ModUpdate>> {
    private final String gameVersion;
    private final Collection<LocalModFile> mods;
    private final Collection<Task<LocalModFile.ModUpdate>> dependents;

    public ModCheckUpdatesTask(String gameVersion, Collection<LocalModFile> mods) {
        this.gameVersion = gameVersion;
        this.mods = mods;
        this.dependents = mods.stream().map(mod -> Task.supplyAsync(() -> mod.checkUpdates(gameVersion, CurseForgeRemoteModRepository.MODS)).setSignificance(Task.TaskSignificance.MAJOR).setName(mod.getFileName()).withCounter("mods.check_updates")).collect(Collectors.toList());
        this.setStage("mods.check_updates");
        this.getProperties().put("total", this.dependents.size());
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() {
        this.notifyPropertiesChanged();
    }

    @Override
    public Collection<? extends Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public boolean isRelyingOnDependents() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        this.setResult(this.dependents.stream().filter(task -> task.getResult() != null).map(Task::getResult).collect(Collectors.toList()));
    }
}

