/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTextField;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.game.GameVersion;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.FloatListCell;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.DownloadPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.AggregatedObservableList;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;

public class DownloadListPage
extends Control
implements DecoratorPage,
VersionPage.VersionLoadable {
    protected final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final BooleanProperty loading = new SimpleBooleanProperty(false);
    private final BooleanProperty failed = new SimpleBooleanProperty(false);
    private final boolean versionSelection;
    private final ObjectProperty<Profile.ProfileVersion> version = new SimpleObjectProperty();
    private final ListProperty<RemoteMod> items = new SimpleListProperty((Object)this, "items", FXCollections.observableArrayList());
    private final ObservableList<String> versions = FXCollections.observableArrayList();
    private final StringProperty selectedVersion = new SimpleStringProperty();
    private final DownloadPage.DownloadCallback callback;
    private boolean searchInitialized = false;
    protected final BooleanProperty supportChinese = new SimpleBooleanProperty();
    private final ObservableList<Node> actions = FXCollections.observableArrayList();
    protected final ListProperty<String> downloadSources = new SimpleListProperty((Object)this, "downloadSources", FXCollections.observableArrayList());
    protected final StringProperty downloadSource = new SimpleStringProperty();
    private final WeakListenerHolder listenerHolder = new WeakListenerHolder();
    private TaskExecutor executor;
    protected RemoteModRepository repository;
    private Runnable retrySearch;

    public DownloadListPage(RemoteModRepository repository) {
        this(repository, null);
    }

    public DownloadListPage(RemoteModRepository repository, DownloadPage.DownloadCallback callback) {
        this(repository, callback, false);
    }

    public DownloadListPage(RemoteModRepository repository, DownloadPage.DownloadCallback callback, boolean versionSelection) {
        this.repository = repository;
        this.callback = callback;
        this.versionSelection = versionSelection;
    }

    public ObservableList<Node> getActions() {
        return this.actions;
    }

    @Override
    public void loadVersion(Profile profile, String version) {
        this.version.set((Object)new Profile.ProfileVersion(profile, version));
        this.setLoading(false);
        this.setFailed(false);
        if (!this.searchInitialized) {
            this.searchInitialized = true;
            this.search("", null, 0, "", RemoteModRepository.SortType.DATE_CREATED);
        }
        if (this.versionSelection) {
            this.versions.setAll((Collection)profile.getRepository().getDisplayVersions().map(Version::getId).collect(Collectors.toList()));
            this.selectedVersion.set((Object)profile.getSelectedVersion());
        }
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public BooleanProperty failedProperty() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed.set(failed);
    }

    public boolean isLoading() {
        return this.loading.get();
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading.set(loading);
    }

    public void search(String userGameVersion, RemoteModRepository.Category category, int pageOffset, String searchFilter, RemoteModRepository.SortType sort) {
        File versionJar;
        this.retrySearch = null;
        this.setLoading(true);
        this.setFailed(false);
        File file = versionJar = StringUtils.isNotBlank(((Profile.ProfileVersion)this.version.get()).getVersion()) ? ((Profile.ProfileVersion)this.version.get()).getProfile().getRepository().getVersionJar(((Profile.ProfileVersion)this.version.get()).getVersion()) : null;
        if (this.executor != null && !this.executor.isCancelled()) {
            this.executor.cancel();
        }
        this.executor = Task.supplyAsync(() -> {
            String gameVersion = StringUtils.isBlank(((Profile.ProfileVersion)this.version.get()).getVersion()) ? userGameVersion : GameVersion.minecraftVersion(versionJar).orElse("");
            return gameVersion;
        }).thenApplyAsync(gameVersion -> this.repository.search((String)gameVersion, category, pageOffset, 50, searchFilter, sort)).whenComplete(Schedulers.javafx(), (result, exception) -> {
            this.setLoading(false);
            if (exception == null) {
                this.items.setAll((Collection)result.collect(Collectors.toList()));
                this.failed.set(false);
            } else {
                this.failed.set(true);
                this.retrySearch = () -> this.search(userGameVersion, category, pageOffset, searchFilter, sort);
            }
        }).executor(true);
    }

    protected String getLocalizedCategory(String category) {
        return I18n.i18n("curse.category." + category);
    }

    protected String getLocalizedCategoryIndent(ModDownloadListPageSkin.CategoryIndented category) {
        return StringUtils.repeats(' ', category.indent * 4) + this.getLocalizedCategory(category.getCategory() == null ? "0" : category.getCategory().getId());
    }

    protected String getLocalizedOfficialPage() {
        return I18n.i18n("mods.curseforge");
    }

    protected Profile.ProfileVersion getProfileVersion() {
        if (this.versionSelection) {
            return new Profile.ProfileVersion(((Profile.ProfileVersion)this.version.get()).getProfile(), (String)this.selectedVersion.get());
        }
        return (Profile.ProfileVersion)this.version.get();
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected Skin<?> createDefaultSkin() {
        return new ModDownloadListPageSkin(this);
    }

    private static class ModDownloadListPageSkin
    extends SkinBase<DownloadListPage> {
        private final AggregatedObservableList<Node> actions = new AggregatedObservableList();

        protected ModDownloadListPageSkin(DownloadListPage control) {
            super((Control)control);
            BorderPane pane = new BorderPane();
            GridPane searchPane = new GridPane();
            pane.setTop((Node)searchPane);
            searchPane.getStyleClass().addAll((Object[])new String[]{"card"});
            BorderPane.setMargin((Node)searchPane, (Insets)new Insets(10.0, 10.0, 0.0, 10.0));
            ColumnConstraints nameColumn = new ColumnConstraints();
            nameColumn.setMinWidth(Double.NEGATIVE_INFINITY);
            ColumnConstraints column1 = new ColumnConstraints();
            column1.setHgrow(Priority.ALWAYS);
            ColumnConstraints column2 = new ColumnConstraints();
            column2.setHgrow(Priority.ALWAYS);
            searchPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{nameColumn, column1, nameColumn, column2});
            searchPane.setHgap(16.0);
            searchPane.setVgap(10.0);
            int rowIndex = 0;
            if (control.versionSelection) {
                JFXComboBox versionsComboBox = new JFXComboBox();
                versionsComboBox.setMaxWidth(Double.MAX_VALUE);
                Bindings.bindContent((List)versionsComboBox.getItems(), (ObservableList)control.versions);
                ExtendedProperties.selectedItemPropertyFor(versionsComboBox).bindBidirectional((Property)control.selectedVersion);
                searchPane.addRow(rowIndex, new Node[]{new Label(I18n.i18n("version")), versionsComboBox});
                if (control.downloadSources.getSize() > 1) {
                    JFXComboBox downloadSourceComboBox = new JFXComboBox();
                    downloadSourceComboBox.setMaxWidth(Double.MAX_VALUE);
                    downloadSourceComboBox.getItems().setAll((Collection)control.downloadSources.get());
                    downloadSourceComboBox.setConverter(FXUtils.stringConverter(I18n::i18n));
                    ExtendedProperties.selectedItemPropertyFor(downloadSourceComboBox).bindBidirectional((Property)control.downloadSource);
                    searchPane.add((Node)new Label(I18n.i18n("settings.launcher.download_source")), 2, rowIndex);
                    searchPane.add(downloadSourceComboBox, 3, rowIndex);
                } else {
                    GridPane.setColumnSpan(versionsComboBox, (Integer)3);
                }
                ++rowIndex;
            }
            JFXTextField nameField = new JFXTextField();
            nameField.setPromptText(((DownloadListPage)this.getSkinnable()).supportChinese.get() ? I18n.i18n("search.hint.chinese") : I18n.i18n("search.hint.english"));
            JFXComboBox gameVersionField = new JFXComboBox();
            gameVersionField.setMaxWidth(Double.MAX_VALUE);
            gameVersionField.setEditable(true);
            gameVersionField.getItems().setAll((Object[])RemoteModRepository.DEFAULT_GAME_VERSIONS);
            Label lblGameVersion = new Label(I18n.i18n("world.game_version"));
            searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("mods.name")), nameField, lblGameVersion, gameVersionField});
            BindingMapping<?, Boolean> hasVersion = BindingMapping.of(((DownloadListPage)this.getSkinnable()).version).map(version -> version.getVersion() == null);
            lblGameVersion.managedProperty().bind(hasVersion);
            lblGameVersion.visibleProperty().bind(hasVersion);
            gameVersionField.managedProperty().bind(hasVersion);
            gameVersionField.visibleProperty().bind(hasVersion);
            FXUtils.onChangeAndOperate(((DownloadListPage)this.getSkinnable()).version, version -> {
                if (StringUtils.isNotBlank(version.getVersion())) {
                    GridPane.setColumnSpan((Node)nameField, (Integer)3);
                } else {
                    GridPane.setColumnSpan((Node)nameField, (Integer)1);
                }
            });
            StackPane categoryStackPane = new StackPane();
            JFXComboBox categoryComboBox = new JFXComboBox();
            categoryComboBox.getItems().setAll((Object[])new CategoryIndented[]{new CategoryIndented(0, null)});
            categoryStackPane.getChildren().setAll((Object[])new Node[]{categoryComboBox});
            categoryComboBox.prefWidthProperty().bind((ObservableValue)categoryStackPane.widthProperty());
            categoryComboBox.getStyleClass().add((Object)"fit-width");
            categoryComboBox.setPromptText(I18n.i18n("mods.category"));
            categoryComboBox.getSelectionModel().select(0);
            categoryComboBox.setConverter(FXUtils.stringConverter(((DownloadListPage)this.getSkinnable())::getLocalizedCategoryIndent));
            Task.supplyAsync(() -> ((DownloadListPage)this.getSkinnable()).repository.getCategories()).thenAcceptAsync(Schedulers.javafx(), categories -> {
                ArrayList<CategoryIndented> result = new ArrayList<CategoryIndented>();
                result.add(new CategoryIndented(0, null));
                for (RemoteModRepository.Category category : Lang.toIterable(categories)) {
                    ModDownloadListPageSkin.resolveCategory(category, 0, result);
                }
                categoryComboBox.getItems().setAll(result);
            }).start();
            StackPane sortStackPane = new StackPane();
            JFXComboBox sortComboBox = new JFXComboBox();
            sortStackPane.getChildren().setAll((Object[])new Node[]{sortComboBox});
            sortComboBox.prefWidthProperty().bind((ObservableValue)sortStackPane.widthProperty());
            sortComboBox.getStyleClass().add((Object)"fit-width");
            sortComboBox.setConverter(FXUtils.stringConverter(sortType -> I18n.i18n("curse.sort." + sortType.name().toLowerCase(Locale.ROOT))));
            sortComboBox.getItems().setAll((Object[])RemoteModRepository.SortType.values());
            sortComboBox.getSelectionModel().select(0);
            searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("mods.category")), categoryStackPane, new Label(I18n.i18n("search.sort")), sortStackPane});
            JFXButton searchButton = new JFXButton();
            searchButton.setText(I18n.i18n("search"));
            searchButton.getStyleClass().add((Object)"jfx-button-raised");
            searchButton.setButtonType(JFXButton.ButtonType.RAISED);
            ObservableList last = FXCollections.observableArrayList((Object[])new Node[]{searchButton});
            HBox searchBox = new HBox(8.0);
            this.actions.appendList((ObservableList<Node>)control.actions);
            this.actions.appendList((ObservableList<Node>)last);
            Bindings.bindContent((List)searchBox.getChildren(), this.actions.getAggregatedList());
            GridPane.setColumnSpan((Node)searchBox, (Integer)4);
            searchBox.setAlignment(Pos.CENTER_RIGHT);
            searchPane.addRow(rowIndex++, new Node[]{searchBox});
            EventHandler searchAction = e -> ((DownloadListPage)this.getSkinnable()).search((String)gameVersionField.getSelectionModel().getSelectedItem(), Optional.ofNullable(categoryComboBox.getSelectionModel().getSelectedItem()).map(CategoryIndented::getCategory).orElse(null), 0, nameField.getText(), (RemoteModRepository.SortType)((Object)((Object)sortComboBox.getSelectionModel().getSelectedItem())));
            searchButton.setOnAction(searchAction);
            nameField.setOnAction(searchAction);
            gameVersionField.setOnAction(searchAction);
            categoryComboBox.setOnAction(searchAction);
            sortComboBox.setOnAction(searchAction);
            SpinnerPane spinnerPane = new SpinnerPane();
            pane.setCenter((Node)spinnerPane);
            spinnerPane.loadingProperty().bind((ObservableValue)((DownloadListPage)this.getSkinnable()).loadingProperty());
            spinnerPane.failedReasonProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (((DownloadListPage)this.getSkinnable()).isFailed()) {
                    return I18n.i18n("download.failed.refresh");
                }
                return null;
            }, (Observable[])new Observable[]{((DownloadListPage)this.getSkinnable()).failedProperty()}));
            spinnerPane.setOnFailedAction((EventHandler<Event>)((EventHandler)e -> {
                if (((DownloadListPage)this.getSkinnable()).retrySearch != null) {
                    ((DownloadListPage)this.getSkinnable()).retrySearch.run();
                }
            }));
            JFXListView listView = new JFXListView();
            spinnerPane.setContent((Node)listView);
            Bindings.bindContent((List)listView.getItems(), (ObservableList)((DownloadListPage)this.getSkinnable()).items);
            listView.setOnMouseClicked(e -> {
                if (listView.getSelectionModel().getSelectedIndex() < 0) {
                    return;
                }
                RemoteMod selectedItem = (RemoteMod)listView.getSelectionModel().getSelectedItem();
                Controllers.navigate((Node)new DownloadPage((DownloadListPage)this.getSkinnable(), selectedItem, ((DownloadListPage)this.getSkinnable()).getProfileVersion(), ((DownloadListPage)this.getSkinnable()).callback));
            });
            listView.setCellFactory(x -> new FloatListCell<RemoteMod>(listView){
                TwoLineListItem content;
                ImageView imageView;
                {
                    super(listView);
                    this.content = new TwoLineListItem();
                    this.imageView = new ImageView();
                    HBox container = new HBox(8.0);
                    container.setAlignment(Pos.CENTER_LEFT);
                    this.pane.getChildren().add((Object)container);
                    container.getChildren().setAll((Object[])new Node[]{FXUtils.limitingSize((Node)this.imageView, 40.0, 40.0), this.content});
                }

                @Override
                protected void updateControl(RemoteMod dataItem, boolean empty) {
                    if (empty) {
                        return;
                    }
                    ModTranslations.Mod mod = ModTranslations.getModByCurseForgeId(dataItem.getSlug());
                    this.content.setTitle(mod != null ? mod.getDisplayName() : dataItem.getTitle());
                    this.content.setSubtitle(dataItem.getDescription());
                    this.content.getTags().setAll((Collection)dataItem.getCategories().stream().map(category -> ((DownloadListPage)this.getSkinnable()).getLocalizedCategory((String)category)).collect(Collectors.toList()));
                    if (StringUtils.isNotBlank(dataItem.getIconUrl())) {
                        this.imageView.setImage(new Image(dataItem.getIconUrl(), 40.0, 40.0, true, true, true));
                    }
                }
            });
            this.getChildren().setAll((Object[])new Node[]{pane});
        }

        private static void resolveCategory(RemoteModRepository.Category category, int indent, List<CategoryIndented> result) {
            result.add(new CategoryIndented(indent, category));
            for (RemoteModRepository.Category subcategory : category.getSubcategories()) {
                ModDownloadListPageSkin.resolveCategory(subcategory, indent + 1, result);
            }
        }

        private static class CategoryIndented {
            private final int indent;
            private final RemoteModRepository.Category category;

            public CategoryIndented(int indent, RemoteModRepository.Category category) {
                this.indent = indent;
                this.category = category;
            }

            public int getIndent() {
                return this.indent;
            }

            public RemoteModRepository.Category getCategory() {
                return this.category;
            }
        }
    }
}

