/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerChannel;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;

public class MultiplayerServer
extends Thread {
    private ServerSocket socket;
    private final String sessionName;
    private final int gamePort;
    private final boolean allowAllJoinRequests;
    private FutureCallback<MultiplayerChannel.CatoClient> onClientAdding;
    private final EventManager<MultiplayerChannel.CatoClient> onClientAdded = new EventManager();
    private final EventManager<MultiplayerChannel.CatoClient> onClientDisconnected = new EventManager();
    private final EventManager<Event> onKeepAlive = new EventManager();
    private final EventManager<Event> onHandshake = new EventManager();
    private final Map<String, Endpoint> clients = new ConcurrentHashMap<String, Endpoint>();
    private final Map<String, Endpoint> nameClientMap = new ConcurrentHashMap<String, Endpoint>();

    public MultiplayerServer(String sessionName, int gamePort, boolean allowAllJoinRequests) {
        this.sessionName = sessionName;
        this.gamePort = gamePort;
        this.allowAllJoinRequests = allowAllJoinRequests;
        this.setName("MultiplayerServer");
        this.setDaemon(true);
    }

    public void setOnClientAdding(FutureCallback<MultiplayerChannel.CatoClient> callback) {
        this.onClientAdding = callback;
    }

    public EventManager<MultiplayerChannel.CatoClient> onClientAdded() {
        return this.onClientAdded;
    }

    public EventManager<MultiplayerChannel.CatoClient> onClientDisconnected() {
        return this.onClientDisconnected;
    }

    public EventManager<Event> onKeepAlive() {
        return this.onKeepAlive;
    }

    public EventManager<Event> onHandshake() {
        return this.onHandshake;
    }

    public void startServer() throws IOException {
        this.startServer(0);
    }

    public void startServer(int port) throws IOException {
        if (this.socket != null) {
            throw new IllegalStateException("MultiplayerServer already started");
        }
        this.socket = new ServerSocket(port);
        this.start();
    }

    public int getPort() {
        if (this.socket == null) {
            throw new IllegalStateException("MultiplayerServer not started");
        }
        return this.socket.getLocalPort();
    }

    @Override
    public void run() {
        Logging.LOG.info("Multiplayer Server listening 127.0.0.1:" + this.socket.getLocalPort());
        try {
            while (!this.isInterrupted()) {
                Socket clientSocket = this.socket.accept();
                clientSocket.setSoTimeout(10000);
                Lang.thread(() -> this.handleClient(clientSocket), "MultiplayerServerClientThread", true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void kickPlayer(MultiplayerChannel.CatoClient player) {
        Endpoint client = this.nameClientMap.get(player.getUsername());
        if (client == null) {
            return;
        }
        try {
            if (client.socket.isConnected()) {
                client.write(new MultiplayerChannel.KickResponse("kicked"));
                client.socket.close();
            }
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to kick player " + player.getUsername() + ". Maybe already disconnected?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient(Socket targetSocket) {
        String address = targetSocket.getRemoteSocketAddress().toString();
        String clientName = null;
        Logging.LOG.info("Accepted client " + address);
        try (Socket clientSocket = targetSocket;
             BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream(), StandardCharsets.UTF_8));){
            String line;
            clientSocket.setKeepAlive(true);
            Endpoint endpoint = new Endpoint(clientSocket, writer);
            this.clients.put(address, endpoint);
            while ((line = reader.readLine()) != null) {
                if (this.isInterrupted()) {
                    return;
                }
                Logging.LOG.fine("Message from client " + targetSocket.getRemoteSocketAddress() + ":" + line);
                MultiplayerChannel.Request request = JsonUtils.fromNonNullJson(line, MultiplayerChannel.Request.class);
                if (request instanceof MultiplayerChannel.JoinRequest) {
                    MultiplayerChannel.JoinRequest joinRequest = (MultiplayerChannel.JoinRequest)request;
                    Logging.LOG.info("Received join request with clientVersion=" + joinRequest.getClientVersion() + ", id=" + joinRequest.getUsername());
                    clientName = joinRequest.getUsername();
                    if (!Objects.equals("1.2.1-1642413526", joinRequest.getClientVersion())) {
                        try {
                            endpoint.write(new MultiplayerChannel.KickResponse("version_not_matched"));
                            Logging.LOG.info("Rejected join request from id=" + joinRequest.getUsername());
                            this.socket.close();
                        }
                        catch (IOException e) {
                            Logging.LOG.log(Level.WARNING, "Failed to send kick response.", e);
                            if (writer != null) {
                                if (var9_15 != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable throwable) {
                                        var9_15.addSuppressed(throwable);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                            if (reader != null) {
                                if (var7_11 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable) {
                                        var7_11.addSuppressed(throwable);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            if (clientSocket != null) {
                                if (var5_7 != null) {
                                    try {
                                        clientSocket.close();
                                    }
                                    catch (Throwable throwable) {
                                        var5_7.addSuppressed(throwable);
                                    }
                                } else {
                                    clientSocket.close();
                                }
                            }
                            if (clientName != null) {
                                this.onClientDisconnected.fireEvent(new MultiplayerChannel.CatoClient(this, clientName));
                            }
                            this.clients.remove(address);
                            if (clientName != null) {
                                this.nameClientMap.remove(clientName);
                            }
                            return;
                        }
                    }
                    MultiplayerChannel.CatoClient catoClient = new MultiplayerChannel.CatoClient(this, clientName);
                    this.nameClientMap.put(clientName, endpoint);
                    this.onClientAdded.fireEvent(catoClient);
                    if (this.onClientAdding != null && !this.allowAllJoinRequests) {
                        this.onClientAdding.call(catoClient, () -> {
                            try {
                                endpoint.write(new MultiplayerChannel.JoinResponse(this.sessionName, this.gamePort));
                            }
                            catch (IOException e) {
                                Logging.LOG.log(Level.WARNING, "Failed to send join response.", e);
                                try {
                                    this.socket.close();
                                }
                                catch (IOException ioException) {
                                    Logging.LOG.log(Level.WARNING, "Failed to close socket caused by join response sending failure.", e);
                                    this.interrupt();
                                }
                            }
                        }, msg -> {
                            try {
                                endpoint.write(new MultiplayerChannel.KickResponse((String)msg));
                                Logging.LOG.info("Rejected join request from id=" + joinRequest.getUsername());
                                this.socket.close();
                            }
                            catch (IOException e) {
                                Logging.LOG.log(Level.WARNING, "Failed to send kick response.", e);
                            }
                        });
                        continue;
                    }
                    endpoint.write(new MultiplayerChannel.JoinResponse(this.sessionName, this.gamePort));
                    continue;
                }
                if (request instanceof MultiplayerChannel.KeepAliveRequest) {
                    endpoint.write(new MultiplayerChannel.KeepAliveResponse(System.currentTimeMillis()));
                    this.onKeepAlive.fireEvent(new Event(this));
                    continue;
                }
                if (request instanceof MultiplayerChannel.HandshakeRequest) {
                    endpoint.write(new MultiplayerChannel.HandshakeResponse());
                    this.onHandshake.fireEvent(new Event(this));
                    continue;
                }
                Logging.LOG.log(Level.WARNING, "Unrecognized packet from client " + targetSocket.getRemoteSocketAddress() + ":" + line);
            }
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to handle client socket.", e);
        }
        catch (JsonParseException e) {
            Logging.LOG.log(Level.SEVERE, "Failed to parse client request. This should not happen.", e);
        }
        finally {
            if (clientName != null) {
                this.onClientDisconnected.fireEvent(new MultiplayerChannel.CatoClient(this, clientName));
            }
            this.clients.remove(address);
            if (clientName != null) {
                this.nameClientMap.remove(clientName);
            }
        }
    }

    public static class Endpoint {
        public final Socket socket;
        public final BufferedWriter writer;

        public Endpoint(Socket socket, BufferedWriter writer) {
            this.socket = socket;
            this.writer = writer;
        }

        public synchronized void write(Object object) throws IOException {
            this.writer.write(MultiplayerChannel.verifyJson(JsonUtils.UGLY_GSON.toJson(object)));
            this.writer.newLine();
            this.writer.flush();
        }
    }
}

