/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.launch.StreamPump;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.multiplayer.LocalServerBroadcaster;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerClient;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerServer;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

public final class MultiplayerManager {
    static final String CATO_VERSION = "1.2.1-1642413526";
    private static final String CATO_DOWNLOAD_URL = "https://gitcode.net/to/cato/-/raw/master/client/";
    private static final String CATO_HASH_URL = "https://gitcode.net/to/cato/-/raw/master/client/cato-all-files.sha1";
    private static final String CATO_PATH = MultiplayerManager.getCatoPath();
    public static final int CATO_AGREEMENT_VERSION = 2;
    private static final String REMOTE_ADDRESS = "127.0.0.1";
    private static final String LOCAL_ADDRESS = "0.0.0.0";
    private static CompletableFuture<Map<String, String>> HASH;
    public static final Pattern INVITATION_CODE_PATTERN;

    private MultiplayerManager() {
    }

    private static CompletableFuture<Map<String, String>> getCatoHash() {
        FXUtils.checkFxUserThread();
        if (HASH == null) {
            HASH = CompletableFuture.supplyAsync(Lang.wrap(() -> {
                String hashList = HttpRequest.GET(CATO_HASH_URL).getString();
                HashMap<String, String> hashes = new HashMap<String, String>();
                for (String line : hashList.split("\n")) {
                    String[] items = line.trim().split("  ");
                    if (items.length == 2 && items[0].length() == 40) {
                        hashes.put(items[1], items[0]);
                        continue;
                    }
                    Logging.LOG.warning("Failed to parse cato hash file, hash line " + line);
                }
                return hashes;
            }));
        }
        return HASH;
    }

    public static Task<Void> downloadCato() {
        return Task.fromCompletableFuture(MultiplayerManager.getCatoHash()).thenComposeAsync(catoHashes -> new FileDownloadTask(NetworkUtils.toURL(CATO_DOWNLOAD_URL + MultiplayerManager.getCatoFileName()), MultiplayerManager.getCatoExecutable().toFile(), catoHashes.get(MultiplayerManager.getCatoFileName()) == null ? null : new FileDownloadTask.IntegrityCheck("SHA-1", (String)catoHashes.get(MultiplayerManager.getCatoFileName()))).thenRunAsync(() -> {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX || OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                Set<PosixFilePermission> perm = Files.getPosixFilePermissions(MultiplayerManager.getCatoExecutable(), new LinkOption[0]);
                perm.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(MultiplayerManager.getCatoExecutable(), perm);
            }
        }));
    }

    public static Path getCatoExecutable() {
        return Metadata.HMCL_DIRECTORY.resolve("libraries").resolve(CATO_PATH);
    }

    private static CompletableFuture<CatoSession> startCato(String token, State state) {
        return MultiplayerManager.getCatoHash().thenApplyAsync(Lang.wrap(catoHashes -> {
            String[] stringArray;
            Path exe = MultiplayerManager.getCatoExecutable();
            if (!Files.isRegularFile(exe, new LinkOption[0])) {
                throw new CatoNotExistsException(exe);
            }
            if (!MultiplayerManager.isPortAvailable(3478)) {
                throw new CatoAlreadyStartedException();
            }
            try {
                String hash = (String)catoHashes.get(MultiplayerManager.getCatoFileName());
                if (hash != null) {
                    ChecksumMismatchException.verifyChecksum(exe, "SHA-1", hash);
                }
            }
            catch (IOException e) {
                Files.deleteIfExists(exe);
                throw e;
            }
            if (StringUtils.isBlank(token)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = exe.toString();
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = exe.toString();
                stringArray3[1] = "-auth.token";
                stringArray = stringArray3;
                stringArray3[2] = token;
            }
            String[] commands = stringArray;
            Process process = new ProcessBuilder(new String[0]).command(commands).start();
            return new CatoSession(state, process, Arrays.asList(commands));
        }));
    }

    public static CompletableFuture<CatoSession> joinSession(String token, String peer, Mode mode, int remotePort, int localPort, JoinSessionHandler handler) throws IncompatibleCatoVersionException {
        Logging.LOG.info(String.format("Joining session (token=%s,peer=%s,mode=%s,remotePort=%d,localPort=%d)", new Object[]{token, peer, mode, remotePort, localPort}));
        return MultiplayerManager.startCato(token, State.SLAVE).thenComposeAsync(Lang.wrap(session -> {
            CompletableFuture future = new CompletableFuture();
            session.forwardPort(peer, LOCAL_ADDRESS, localPort, REMOTE_ADDRESS, remotePort, mode);
            Consumer<CatoExitEvent> onExit = event -> {
                boolean ready = session.isReady();
                switch (event.getExitCode()) {
                    case 1: {
                        if (ready) break;
                        future.completeExceptionally(new CatoExitTimeoutException());
                    }
                }
                future.completeExceptionally(new CatoExitException(event.getExitCode(), ready));
            };
            ((CatoSession)session).onExit.register(onExit);
            TimerTask peerConnectionTimeoutTask = Lang.setTimeout(() -> {
                future.completeExceptionally(new PeerConnectionTimeoutException());
                session.stop();
            }, 15000L);
            ((CatoSession)session).onPeerConnected.register(event -> {
                peerConnectionTimeoutTask.cancel();
                MultiplayerClient client = new MultiplayerClient(session.getId(), localPort);
                session.addRelatedThread(client);
                session.setClient(client);
                TimerTask task = Lang.setTimeout(() -> {
                    Platform.runLater(() -> future.completeExceptionally(new JoinRequestTimeoutException()));
                    session.stop();
                }, 30000L);
                client.onConnected().register(connectedEvent -> {
                    try {
                        int port = MultiplayerManager.findAvailablePort();
                        session.forwardPort(peer, LOCAL_ADDRESS, port, REMOTE_ADDRESS, connectedEvent.getPort(), mode);
                        session.addRelatedThread(Lang.thread(new LocalServerBroadcaster(port, (CatoSession)session), "LocalServerBroadcaster", true));
                        session.setName(connectedEvent.getSessionName());
                        client.setGamePort(port);
                        Platform.runLater(() -> {
                            ((CatoSession)session).onExit.unregister(onExit);
                            future.complete(session);
                        });
                    }
                    catch (IOException e) {
                        session.stop();
                        Platform.runLater(() -> future.completeExceptionally(e));
                    }
                    task.cancel();
                });
                client.onKicked().register(kickedEvent -> {
                    session.stop();
                    task.cancel();
                    Platform.runLater(() -> future.completeExceptionally(new KickedException(kickedEvent.getReason())));
                });
                client.onDisconnected().register(disconnectedEvent -> Platform.runLater(() -> {
                    if (!client.isConnected()) {
                        future.completeExceptionally(new ConnectionErrorException());
                    }
                }));
                client.onHandshake().register(handshakeEvent -> {
                    if (handler != null) {
                        handler.onWaitingForJoinResponse();
                    }
                });
                client.start();
            });
            return future;
        }));
    }

    public static CompletableFuture<CatoSession> createSession(String token, String sessionName, int gamePort, boolean allowAllJoinRequests) {
        Logging.LOG.info(String.format("Creating session (token=%s,sessionName=%s,gamePort=%d)", token, sessionName, gamePort));
        return MultiplayerManager.startCato(token, State.MASTER).thenComposeAsync(Lang.wrap(session -> {
            CompletableFuture future = new CompletableFuture();
            MultiplayerServer server = new MultiplayerServer(sessionName, gamePort, allowAllJoinRequests);
            server.startServer();
            session.setName(sessionName);
            session.allowForwardingAddress(REMOTE_ADDRESS, server.getPort());
            session.allowForwardingAddress(REMOTE_ADDRESS, gamePort);
            session.showAllowedAddress();
            Consumer<CatoExitEvent> onExit = event -> {
                boolean ready = session.isReady();
                switch (event.getExitCode()) {
                    case 1: {
                        if (ready) break;
                        future.completeExceptionally(new CatoExitTimeoutException());
                    }
                }
                future.completeExceptionally(new CatoExitException(event.getExitCode(), ready));
            };
            ((CatoSession)session).onExit.register(onExit);
            session.setServer(server);
            session.addRelatedThread(server);
            TimerTask peerConnectionTimeoutTask = Lang.setTimeout(() -> {
                future.completeExceptionally(new PeerConnectionTimeoutException());
                session.stop();
            }, 15000L);
            ((CatoSession)session).onPeerConnected.register(event -> {
                peerConnectionTimeoutTask.cancel();
                Platform.runLater(() -> {
                    ((CatoSession)session).onExit.unregister(onExit);
                    future.complete(session);
                });
            });
            return future;
        }));
    }

    public static Invitation parseInvitationCode(String invitationCode) throws JsonParseException {
        Matcher matcher = INVITATION_CODE_PATTERN.matcher(invitationCode);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid invitation code");
        }
        return new Invitation(matcher.group("id"), Integer.parseInt(matcher.group("port")));
    }

    public static int findAvailablePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        try (ServerSocket socket = new ServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String getCatoFileName() {
        switch (OperatingSystem.CURRENT_OS) {
            case WINDOWS: {
                if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                    return "cato-client-windows-amd64.exe";
                }
                if (Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                    return "cato-client-windows-arm64.exe";
                }
                if (Architecture.SYSTEM_ARCH == Architecture.X86) {
                    return "cato-client-windows-i386.exe";
                }
                return "";
            }
            case OSX: {
                if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                    return "cato-client-darwin-amd64";
                }
                if (Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                    return "cato-client-darwin-arm64";
                }
                return "";
            }
            case LINUX: {
                if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                    return "cato-client-linux-amd64";
                }
                if (Architecture.SYSTEM_ARCH == Architecture.ARM32) {
                    return "cato-client-linux-arm7";
                }
                if (Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                    return "cato-client-linux-arm64";
                }
                return "";
            }
        }
        return "";
    }

    public static String getCatoPath() {
        String name = MultiplayerManager.getCatoFileName();
        if (StringUtils.isBlank(name)) {
            return "";
        }
        return "cato/cato/1.2.1-1642413526/" + name;
    }

    static {
        INVITATION_CODE_PATTERN = Pattern.compile("^(?<id>.*?)#(?<port>\\d{2,5})$");
    }

    public static class CatoAlreadyStartedException
    extends RuntimeException {
    }

    public static class CatoExitEvent
    extends Event {
        private final int exitCode;
        public static final int EXIT_CODE_INTERRUPTED = -1;
        public static final int EXIT_CODE_SESSION_EXPIRED = 10;

        public CatoExitEvent(Object source, int exitCode) {
            super(source);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    public static class CatoExitException
    extends RuntimeException {
        private final int exitCode;
        private final boolean ready;

        public CatoExitException(int exitCode, boolean ready) {
            this.exitCode = exitCode;
            this.ready = ready;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public boolean isReady() {
            return this.ready;
        }
    }

    public static class CatoExitTimeoutException
    extends RuntimeException {
    }

    public static class CatoIdEvent
    extends Event {
        private final String id;

        public CatoIdEvent(Object source, String id) {
            super(source);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class CatoNotExistsException
    extends RuntimeException {
        private final Path file;

        public CatoNotExistsException(Path file) {
            this.file = file;
        }

        public Path getFile() {
            return this.file;
        }
    }

    public static class CatoSession
    extends ManagedProcess {
        private final EventManager<CatoExitEvent> onExit = new EventManager();
        private final EventManager<CatoIdEvent> onIdGenerated = new EventManager();
        private final EventManager<Event> onPeerConnected = new EventManager();
        private String name;
        private final State type;
        private String id;
        private boolean peerConnected = false;
        private MultiplayerClient client;
        private MultiplayerServer server;
        private final BufferedWriter writer;
        private static final Pattern TEMP_TOKEN_PATTERN = Pattern.compile("id\\((?<id>\\w+)\\)");
        private static final Pattern PEER_CONNECTED_PATTERN = Pattern.compile("Connected to main net");
        private static final Pattern LOG_PATTERN = Pattern.compile("(\\[\\d+])\\s+(\\w+)\\s+(\\w+-{0,1}\\w+):\\s(.*)");

        CatoSession(State type, Process process, List<String> commands) {
            super(process, commands);
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
            Logging.LOG.info("Started cato with command: " + new CommandBuilder().addAll(commands));
            this.type = type;
            this.addRelatedThread(Lang.thread(this::waitFor, "CatoExitWaiter", true));
            this.addRelatedThread(Lang.thread(new StreamPump(process.getInputStream(), this::checkCatoLog), "CatoInputStreamPump", true));
            this.addRelatedThread(Lang.thread(new StreamPump(process.getErrorStream(), this::checkCatoLog), "CatoErrorStreamPump", true));
            this.writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
        }

        public synchronized MultiplayerClient getClient() {
            return this.client;
        }

        public synchronized CatoSession setClient(MultiplayerClient client) {
            this.client = client;
            return this;
        }

        public MultiplayerServer getServer() {
            return this.server;
        }

        public CatoSession setServer(MultiplayerServer server) {
            this.server = server;
            return this;
        }

        private void checkCatoLog(String log) {
            Matcher matcher;
            Logging.LOG.info("Cato: " + log);
            if (this.id == null && (matcher = TEMP_TOKEN_PATTERN.matcher(log)).find()) {
                this.id = matcher.group("id");
                this.onIdGenerated.fireEvent(new CatoIdEvent(this, this.id));
            }
            if (!this.peerConnected && (matcher = PEER_CONNECTED_PATTERN.matcher(log)).find()) {
                this.peerConnected = true;
                this.onPeerConnected.fireEvent(new Event(this));
            }
        }

        private void waitFor() {
            try {
                int exitCode = this.getProcess().waitFor();
                Logging.LOG.info("cato exited with exitcode " + exitCode);
                this.onExit.fireEvent(new CatoExitEvent(this, exitCode));
            }
            catch (InterruptedException e) {
                this.onExit.fireEvent(new CatoExitEvent(this, -1));
            }
            finally {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to close cato stdin writer", e);
                }
            }
            this.destroyRelatedThreads();
        }

        public boolean isReady() {
            return this.id != null;
        }

        public synchronized String getName() {
            return this.name;
        }

        public synchronized void setName(String name) {
            this.name = name;
        }

        public State getType() {
            return this.type;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public String generateInvitationCode(int serverPort) {
            if (this.id == null) {
                throw new IllegalStateException("id not generated");
            }
            return this.id + "#" + serverPort;
        }

        public synchronized void invokeCommand(String command) throws IOException {
            Logging.LOG.info("Invoking cato: " + command);
            this.writer.write(command);
            this.writer.newLine();
            this.writer.flush();
        }

        public void forwardPort(String peerId, String localAddress, int localPort, String remoteAddress, int remotePort, Mode mode) throws IOException {
            this.invokeCommand(String.format("net add %s %s:%d %s:%d %s", peerId, localAddress, localPort, remoteAddress, remotePort, mode.getName()));
        }

        public void allowForwardingAddress(String address, int port) throws IOException {
            this.invokeCommand(String.format("ufw net open %s:%d", address, port));
        }

        public void showAllowedAddress() throws IOException {
            this.invokeCommand("ufw net whitelist");
        }

        public EventManager<CatoExitEvent> onExit() {
            return this.onExit;
        }

        public EventManager<CatoIdEvent> onIdGenerated() {
            return this.onIdGenerated;
        }

        public EventManager<Event> onPeerConnected() {
            return this.onPeerConnected;
        }
    }

    public static class CatoSessionExpiredException
    extends RuntimeException {
    }

    public static class ConnectionErrorException
    extends RuntimeException {
    }

    public static class IncompatibleCatoVersionException
    extends Exception {
        private final String expected;
        private final String actual;

        public IncompatibleCatoVersionException(String expected, String actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public String getExpected() {
            return this.expected;
        }

        public String getActual() {
            return this.actual;
        }
    }

    public static class Invitation {
        private final String id;
        @SerializedName(value="p")
        private final int channelPort;

        public Invitation(String id, int channelPort) {
            this.id = id;
            this.channelPort = channelPort;
        }

        public String getId() {
            return this.id;
        }

        public int getChannelPort() {
            return this.channelPort;
        }
    }

    public static class JoinRequestTimeoutException
    extends RuntimeException {
    }

    public static interface JoinSessionHandler {
        public void onWaitingForJoinResponse();
    }

    public static class KickedException
    extends RuntimeException {
        private final String reason;

        public KickedException(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static enum Mode {
        P2P,
        BRIDGE;


        String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class PeerConnectionTimeoutException
    extends RuntimeException {
    }

    static enum State {
        DISCONNECTED,
        CONNECTING,
        MASTER,
        SLAVE;

    }
}

