/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.TimerTask;
import java.util.logging.Level;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerChannel;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerServer;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;

public class MultiplayerClient
extends Thread {
    private final String id;
    private final int port;
    private int gamePort;
    private boolean connected = false;
    private final EventManager<ConnectedEvent> onConnected = new EventManager();
    private final EventManager<Event> onDisconnected = new EventManager();
    private final EventManager<KickEvent> onKicked = new EventManager();
    private final EventManager<Event> onHandshake = new EventManager();

    public MultiplayerClient(String id, int port) {
        this.id = id;
        this.port = port;
        this.setName("MultiplayerClient");
        this.setDaemon(true);
    }

    public synchronized void setGamePort(int gamePort) {
        this.gamePort = gamePort;
    }

    public synchronized int getGamePort() {
        return this.gamePort;
    }

    public EventManager<ConnectedEvent> onConnected() {
        return this.onConnected;
    }

    public EventManager<Event> onDisconnected() {
        return this.onDisconnected;
    }

    public EventManager<KickEvent> onKicked() {
        return this.onKicked;
    }

    public EventManager<Event> onHandshake() {
        return this.onHandshake;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Logging.LOG.info("Connecting to 127.0.0.1:" + this.port);
        int i = 0;
        while (true) {
            if (i >= 5) {
                Logging.LOG.info("Lost connection to 127.0.0.1:" + this.port);
                this.onDisconnected.fireEvent(new Event(this));
                return;
            }
            Thread keepAliveThread = null;
            try (Socket socket = new Socket(InetAddress.getLoopbackAddress(), this.port);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));){
                String line;
                MultiplayerServer.Endpoint endpoint = new MultiplayerServer.Endpoint(socket, writer);
                socket.setSoTimeout(30000);
                Logging.LOG.info("Connected to 127.0.0.1:" + this.port);
                endpoint.write(new MultiplayerChannel.HandshakeRequest());
                endpoint.write(new MultiplayerChannel.JoinRequest("1.2.1-1642413526", this.id));
                Logging.LOG.fine("Sent join request with id=" + this.id);
                keepAliveThread = new KeepAliveThread(endpoint);
                keepAliveThread.start();
                TimerTask task = Lang.setTimeout(() -> {
                    try {
                        Logging.LOG.log(Level.WARNING, "Socket connection timeout, closing socket");
                        socket.close();
                    }
                    catch (IOException e) {
                        Logging.LOG.log(Level.WARNING, "Failed to close socket", e);
                    }
                }, 25000L);
                while ((line = reader.readLine()) != null) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Logging.LOG.fine("Message from server:" + line);
                    MultiplayerChannel.Response response = JsonUtils.fromNonNullJson(line, MultiplayerChannel.Response.class);
                    if (response instanceof MultiplayerChannel.JoinResponse) {
                        MultiplayerChannel.JoinResponse joinResponse = JsonUtils.fromNonNullJson(line, MultiplayerChannel.JoinResponse.class);
                        this.setGamePort(joinResponse.getPort());
                        this.connected = true;
                        this.onConnected.fireEvent(new ConnectedEvent(this, joinResponse.getSessionName(), joinResponse.getPort()));
                        Logging.LOG.fine("Received join response with port " + joinResponse.getPort());
                        continue;
                    }
                    if (response instanceof MultiplayerChannel.KickResponse) {
                        Logging.LOG.fine("Kicked by the server");
                        this.onKicked.fireEvent(new KickEvent(this, ((MultiplayerChannel.KickResponse)response).getMsg()));
                        return;
                    }
                    if (response instanceof MultiplayerChannel.KeepAliveResponse) continue;
                    if (response instanceof MultiplayerChannel.HandshakeResponse) {
                        Logging.LOG.fine("Established connection with server");
                        this.onHandshake.fireEvent(new Event(this));
                        task.cancel();
                        continue;
                    }
                    Logging.LOG.log(Level.WARNING, "Unrecognized packet from server:" + line);
                }
            }
            catch (ConnectException e) {
                Logging.LOG.info("Failed to connect to 127.0.0.1:" + this.port + ", tried " + i + " time(s)");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    Logging.LOG.warning("MultiplayerClient interrupted");
                    return;
                }
            }
            catch (JsonParseException | IOException e) {
                e.printStackTrace();
            }
            finally {
                if (keepAliveThread != null) {
                    keepAliveThread.interrupt();
                }
            }
            ++i;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static class ConnectedEvent
    extends Event {
        private final String sessionName;
        private final int port;

        public ConnectedEvent(Object source, String sessionName, int port) {
            super(source);
            this.sessionName = sessionName;
            this.port = port;
        }

        public String getSessionName() {
            return this.sessionName;
        }

        public int getPort() {
            return this.port;
        }
    }

    private static class KeepAliveThread
    extends Thread {
        private final MultiplayerServer.Endpoint endpoint;

        public KeepAliveThread(MultiplayerServer.Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    this.endpoint.write(new MultiplayerChannel.KeepAliveRequest(System.currentTimeMillis()));
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to send keep alive packet", e);
                    break;
                }
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public static class KickEvent
    extends Event {
        private final String reason;

        public KickEvent(Object source, String reason) {
            super(source);
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

