/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;

public class LocalServerDetector
extends Thread {
    private final EventManager<DetectedLanServerEvent> onDetectedLanServer = new EventManager();
    private final int retry;

    public LocalServerDetector(int retry) {
        this.retry = retry;
        this.setName("LocalServerDetector");
        this.setDaemon(true);
    }

    public EventManager<DetectedLanServerEvent> onDetectedLanServer() {
        return this.onDetectedLanServer;
    }

    @Override
    public void run() {
        InetAddress broadcastAddress;
        MulticastSocket socket;
        try {
            socket = new MulticastSocket(4445);
            socket.setSoTimeout(5000);
            broadcastAddress = InetAddress.getByName("224.0.2.60");
            socket.joinGroup(broadcastAddress);
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to create datagram socket", e);
            return;
        }
        byte[] buf = new byte[1024];
        int tried = 0;
        while (!this.isInterrupted()) {
            DatagramPacket packet = new DatagramPacket(buf, 1024);
            try {
                socket.receive(packet);
            }
            catch (SocketTimeoutException e) {
                if (tried++ <= this.retry) continue;
                this.onDetectedLanServer.fireEvent(new DetectedLanServerEvent(this, null));
                break;
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to detect lan server", e);
                break;
            }
            String response = new String(packet.getData(), packet.getOffset(), packet.getLength(), StandardCharsets.UTF_8);
            Logging.LOG.fine("Local server " + packet.getAddress() + ":" + packet.getPort() + " broadcast message: " + response);
            this.onDetectedLanServer.fireEvent(new DetectedLanServerEvent(this, PingResponse.parsePingResponse(response)));
            break;
        }
        try {
            socket.leaveGroup(broadcastAddress);
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to leave multicast listening group", e);
        }
        socket.close();
    }

    public static class DetectedLanServerEvent
    extends Event {
        private final PingResponse lanServer;

        public DetectedLanServerEvent(Object source, PingResponse lanServer) {
            super(source);
            this.lanServer = lanServer;
        }

        public PingResponse getLanServer() {
            return this.lanServer;
        }
    }

    public static class PingResponse {
        private final String motd;
        private final Integer ad;

        public PingResponse(String motd, Integer ad) {
            this.motd = motd;
            this.ad = ad;
        }

        public String getMotd() {
            return this.motd;
        }

        public Integer getAd() {
            return this.ad;
        }

        public boolean isValid() {
            return this.ad != null;
        }

        public static PingResponse parsePingResponse(String message) {
            return new PingResponse(StringUtils.substringBefore(StringUtils.substringAfter(message, "[MOTD]"), "[/MOTD]"), Lang.toIntOrNull(StringUtils.substringBefore(StringUtils.substringAfter(message, "[AD]"), "[/AD]")));
        }
    }
}

