/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import com.jfoenix.controls.JFXCheckBox;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogPane;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.multiplayer.LocalServerDetector;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.i18n.I18n;

public class CreateMultiplayerRoomDialog
extends DialogPane
implements DialogAware {
    private final FutureCallback<CreationRequest> callback;
    private final LocalServerDetector lanServerDetectorThread;
    private final BooleanProperty allowAllJoinRequests = new SimpleBooleanProperty(true);
    private LocalServerDetector.PingResponse server;

    CreateMultiplayerRoomDialog(FutureCallback<CreationRequest> callback) {
        this.callback = callback;
        this.setTitle(I18n.i18n("multiplayer.session.create"));
        GridPane body = new GridPane();
        body.setMaxWidth(500.0);
        body.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing()});
        body.setVgap(8.0);
        body.setHgap(16.0);
        body.setDisable(true);
        this.setBody(new Node[]{body});
        HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
        hintPane.setText(I18n.i18n("multiplayer.session.create.hint"));
        GridPane.setColumnSpan((Node)hintPane, (Integer)2);
        body.addRow(0, new Node[]{hintPane});
        Label nameField = new Label();
        nameField.setText(Optional.ofNullable(Accounts.getSelectedAccount()).map(Account::getUsername).map(username -> I18n.i18n("multiplayer.session.name.format", username)).orElse(""));
        body.addRow(1, new Node[]{new Label(I18n.i18n("multiplayer.session.create.name")), nameField});
        Label portLabel = new Label(I18n.i18n("multiplayer.nat.testing"));
        portLabel.setText(I18n.i18n("multiplayer.nat.testing"));
        body.addRow(2, new Node[]{new Label(I18n.i18n("multiplayer.session.create.port")), portLabel});
        JFXCheckBox allowAllJoinRequestsCheckBox = new JFXCheckBox(I18n.i18n("multiplayer.session.create.join.allow"));
        allowAllJoinRequestsCheckBox.selectedProperty().bindBidirectional((Property)this.allowAllJoinRequests);
        GridPane.setColumnSpan((Node)allowAllJoinRequestsCheckBox, (Integer)2);
        body.addRow(3, new Node[]{allowAllJoinRequestsCheckBox});
        this.setValid(false);
        JFXHyperlink noinLink = new JFXHyperlink();
        noinLink.setText("noin.cn");
        noinLink.setOnAction(e -> FXUtils.openLink("https://noin.cn"));
        this.setActions(new Node[]{this.warningLabel, noinLink, this.acceptPane, this.cancelButton});
        this.lanServerDetectorThread = new LocalServerDetector(3);
        this.lanServerDetectorThread.onDetectedLanServer().register(event -> FXUtils.runInFX(() -> {
            if (event.getLanServer() != null && event.getLanServer().isValid()) {
                nameField.setText(event.getLanServer().getMotd());
                portLabel.setText(event.getLanServer().getAd().toString());
                this.setValid(true);
            } else {
                nameField.setText("");
                portLabel.setText("");
                this.onFailure(I18n.i18n("multiplayer.session.create.port.error"));
                this.setValid(false);
            }
            this.server = event.getLanServer();
            body.setDisable(false);
            this.getProgressBar().setVisible(false);
        }));
    }

    @Override
    protected void onAccept() {
        this.setLoading();
        this.callback.call(new CreationRequest(Objects.requireNonNull(this.server), this.allowAllJoinRequests.get()), () -> FXUtils.runInFX(this::onSuccess), msg -> FXUtils.runInFX(() -> this.onFailure((String)msg)));
    }

    @Override
    public void onDialogShown() {
        this.getProgressBar().setVisible(true);
        this.getProgressBar().setProgress(-1.0);
        this.lanServerDetectorThread.start();
    }

    @Override
    public void onDialogClosed() {
        this.lanServerDetectorThread.interrupt();
    }

    public static class CreationRequest {
        private final LocalServerDetector.PingResponse server;
        private final boolean allowAllJoinRequests;

        public CreationRequest(LocalServerDetector.PingResponse server, boolean allowAllJoinRequests) {
            this.server = server;
            this.allowAllJoinRequests = allowAllJoinRequests;
        }

        public LocalServerDetector.PingResponse getServer() {
            return this.server;
        }

        public boolean isAllowAllJoinRequests() {
            return this.allowAllJoinRequests;
        }
    }
}

