/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.game.OAuthServer;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.HMCLAccounts;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.DialogPane;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class FeedbackPage
extends VBox
implements PageAware {
    private final ObservableList<FeedbackResponse> feedbacks = FXCollections.observableArrayList();
    private final SpinnerPane spinnerPane = new SpinnerPane();

    public FeedbackPage() {
        this.setSpacing(10.0);
        this.setPadding(new Insets(10.0));
        HBox loginPane = new HBox(16.0);
        loginPane.setAlignment(Pos.CENTER_LEFT);
        loginPane.getStyleClass().add((Object)"card");
        TwoLineListItem accountInfo = new TwoLineListItem();
        HBox.setHgrow((Node)accountInfo, (Priority)Priority.ALWAYS);
        accountInfo.titleProperty().bind(BindingMapping.of(HMCLAccounts.accountProperty()).map(account -> account == null ? I18n.i18n("account.not_logged_in") : account.getNickname()));
        accountInfo.subtitleProperty().bind(BindingMapping.of(HMCLAccounts.accountProperty()).map(account -> account == null ? I18n.i18n("account.not_logged_in") : account.getEmail()));
        JFXButton logButton = new JFXButton();
        logButton.textProperty().bind(BindingMapping.of(HMCLAccounts.accountProperty()).map(account -> account == null ? I18n.i18n("account.login") : I18n.i18n("account.logout")));
        logButton.setOnAction(e -> this.log());
        loginPane.getChildren().setAll((Object[])new Node[]{accountInfo, logButton});
        this.getChildren().add((Object)loginPane);
        HBox searchPane = new HBox(8.0);
        searchPane.getStyleClass().add((Object)"card");
        this.getChildren().add((Object)searchPane);
        JFXTextField searchField = new JFXTextField();
        searchField.setOnAction(e -> this.search(searchField.getText(), "time", true));
        HBox.setHgrow((Node)searchField, (Priority)Priority.ALWAYS);
        searchField.setPromptText(I18n.i18n("search"));
        JFXButton searchButton = new JFXButton();
        searchButton.getStyleClass().add((Object)"toggle-icon4");
        searchButton.setGraphic(SVG.magnify(Theme.blackFillBinding(), -1.0, -1.0));
        searchButton.setOnAction(e -> this.search(searchField.getText(), "time", true));
        JFXButton addButton = new JFXButton();
        addButton.getStyleClass().add((Object)"toggle-icon4");
        addButton.setGraphic(SVG.plus(Theme.blackFillBinding(), -1.0, -1.0));
        addButton.setOnAction(e -> this.addFeedback());
        searchPane.getChildren().setAll((Object[])new Node[]{searchField, searchButton, addButton});
        this.spinnerPane.getStyleClass().add((Object)"card");
        VBox.setVgrow((Node)this.spinnerPane, (Priority)Priority.ALWAYS);
        JFXListView listView = new JFXListView();
        this.spinnerPane.setContent((Node)listView);
        Bindings.bindContent((List)listView.getItems(), this.feedbacks);
        listView.setCellFactory(x -> new MDListCell<FeedbackResponse>(listView){
            private final TwoLineListItem content;
            private final JFXButton likeButton;
            private final JFXButton unlikeButton;
            private final HBox container;
            {
                this.content = new TwoLineListItem();
                this.likeButton = new JFXButton();
                this.unlikeButton = new JFXButton();
                this.container = new HBox(8.0);
                this.container.setPickOnBounds(false);
                this.container.setAlignment(Pos.CENTER_LEFT);
                HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
                this.content.setMouseTransparent(false);
                this.setSelectable();
                this.likeButton.getStyleClass().add((Object)"toggle-icon4");
                this.likeButton.setGraphic(FXUtils.limitingSize(SVG.thumbUpOutline(Theme.blackFillBinding(), 24.0, 24.0), 24.0, 24.0));
                this.unlikeButton.getStyleClass().add((Object)"toggle-icon4");
                this.unlikeButton.setGraphic(FXUtils.limitingSize(SVG.thumbDownOutline(Theme.blackFillBinding(), 24.0, 24.0), 24.0, 24.0));
                this.container.getChildren().setAll((Object[])new Node[]{this.content, this.likeButton, this.unlikeButton});
                StackPane.setMargin((Node)this.container, (Insets)new Insets(10.0, 16.0, 10.0, 16.0));
                this.getContainer().getChildren().setAll((Object[])new Node[]{this.container});
            }

            @Override
            protected void updateControl(FeedbackResponse feedback, boolean empty) {
                if (empty) {
                    return;
                }
                this.content.setTitle(feedback.getTitle());
                this.content.setSubtitle(feedback.getAuthor());
                this.content.getTags().setAll((Object[])new String[]{"#" + feedback.getId(), I18n.i18n("feedback.state." + feedback.getState().name().toLowerCase(Locale.US)), I18n.i18n("feedback.type." + feedback.getType().name().toLowerCase(Locale.US))});
                this.content.setOnMouseClicked(e -> FeedbackPage.this.getFeedback(feedback.getId()).thenAcceptAsync(Schedulers.javafx(), f -> Controllers.dialog((Region)new ViewFeedbackDialog((FeedbackResponse)f))).start());
            }
        });
        this.getChildren().add((Object)this.spinnerPane);
    }

    @Override
    public void onPageShown() {
        this.search("", "time", false);
    }

    private void search(String keyword, String order, boolean showAll) {
        HMCLAccounts.HMCLAccount account = HMCLAccounts.getAccount();
        Task.supplyAsync(() -> {
            Map<String, String> query = Lang.mapOf(Pair.pair("keyword", keyword), Pair.pair("order", order));
            if (showAll) {
                query.put("showAll", "1");
            }
            HttpRequest.HttpGetRequest req = HttpRequest.GET(NetworkUtils.withQuery("https://hmcl.huangyuhui.net/api/feedback", query));
            if (account != null) {
                req.authorization("Bearer", HMCLAccounts.getAccount().getIdToken()).header("Authorization-Provider", HMCLAccounts.getAccount().getProvider());
            }
            return (List)req.getJson(new TypeToken<List<FeedbackResponse>>(){}.getType());
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            this.spinnerPane.hideSpinner();
            if (exception != null) {
                if (exception instanceof ResponseCodeException) {
                    int responseCode = ((ResponseCodeException)exception).getResponseCode();
                    if (responseCode == 401) {
                        this.spinnerPane.setFailedReason(I18n.i18n("feedback.failed.permission"));
                        return;
                    }
                    if (responseCode == 429) {
                        this.spinnerPane.setFailedReason(I18n.i18n("feedback.failed.too_frequently"));
                        return;
                    }
                }
                this.spinnerPane.setFailedReason(I18n.i18n("feedback.failed"));
            } else {
                this.feedbacks.setAll((Collection)result);
            }
        }).start();
    }

    private Task<FeedbackResponse> getFeedback(int id) {
        return Task.supplyAsync(() -> HttpRequest.GET("https://hmcl.huangyuhui.net/api/feedback/" + id).getJson(FeedbackResponse.class));
    }

    private void log() {
        if (HMCLAccounts.getAccount() == null) {
            Controllers.dialog((Region)new LoginDialog());
        } else {
            HMCLAccounts.setAccount(null);
        }
    }

    private void addFeedback() {
        if (HMCLAccounts.getAccount() == null) {
            Controllers.dialog(I18n.i18n("feedback.add.login"));
            return;
        }
        Controllers.dialog((Region)new AddFeedbackDialog());
    }

    private static class AddFeedbackDialog
    extends DialogPane {
        JFXTextField titleField = new JFXTextField();
        JFXComboBox<FeedbackType> comboBox = new JFXComboBox();
        JFXTextArea contentArea = new JFXTextArea();

        public AddFeedbackDialog() {
            this.setTitle(I18n.i18n("feedback.add"));
            GridPane body = new GridPane();
            body.setVgap(8.0);
            body.setHgap(8.0);
            HintPane searchHintPane = new HintPane(MessageDialogPane.MessageType.WARNING);
            GridPane.setColumnSpan((Node)searchHintPane, (Integer)2);
            searchHintPane.setText(I18n.i18n("feedback.add.hint.search_before_add"));
            body.addRow(0, new Node[]{searchHintPane});
            HintPane titleHintPane = new HintPane(MessageDialogPane.MessageType.INFO);
            GridPane.setColumnSpan((Node)titleHintPane, (Integer)2);
            titleHintPane.setText(I18n.i18n("feedback.add.hint.title"));
            body.addRow(1, new Node[]{titleHintPane});
            this.titleField.setValidators(new RequiredValidator());
            body.addRow(2, new Node[]{new Label(I18n.i18n("feedback.title")), this.titleField});
            this.comboBox.setMaxWidth(-1.0);
            this.comboBox.getItems().setAll((Object[])FeedbackType.values());
            this.comboBox.getSelectionModel().select(0);
            this.comboBox.setConverter(FXUtils.stringConverter(e -> I18n.i18n("feedback.type." + e.name().toLowerCase())));
            body.addRow(3, new Node[]{new Label(I18n.i18n("feedback.type")), this.comboBox});
            Label contentLabel = new Label(I18n.i18n("feedback.content"));
            GridPane.setColumnSpan((Node)contentLabel, (Integer)2);
            body.addRow(4, new Node[]{contentLabel});
            this.contentArea.setValidators(new RequiredValidator());
            this.contentArea.setPromptText(I18n.i18n("feedback.add.hint.content"));
            GridPane.setColumnSpan((Node)this.contentArea, (Integer)2);
            body.addRow(5, new Node[]{this.contentArea});
            this.validProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.titleField.validate() && this.contentArea.validate(), (Observable[])new Observable[]{this.titleField.textProperty(), this.contentArea.textProperty()}));
            this.setBody(new Node[]{body});
        }

        @Override
        protected void onAccept() {
            this.setLoading();
            this.addFeedback(this.titleField.getText(), (FeedbackType)((Object)this.comboBox.getValue()), this.contentArea.getText()).whenComplete(Schedulers.javafx(), exception -> {
                if (exception != null) {
                    this.onFailure(exception.getLocalizedMessage());
                } else {
                    this.onSuccess();
                }
            }).start();
        }

        private Task<?> addFeedback(String title, FeedbackType feedbackType, String content) {
            return Task.runAsync(() -> HttpRequest.POST("https://hmcl.huangyuhui.net/api/feedback").json(Lang.mapOf(Pair.pair("title", title), Pair.pair("content", content), Pair.pair("type", feedbackType.name().toLowerCase(Locale.ROOT)), Pair.pair("launcher_version", Metadata.VERSION))).authorization("Bearer", HMCLAccounts.getAccount().getIdToken()).header("Authorization-Provider", HMCLAccounts.getAccount().getProvider()).getString());
        }
    }

    private static class FeedbackResponse {
        private final int id;
        private final String title;
        private final String content;
        private final String author;
        @SerializedName(value="launcher_version")
        private final String launcherVersion;
        private final FeedbackType type;
        private final FeedbackState state;
        private final String reason;

        public FeedbackResponse(int id, String title, String content, String author, String launcherVersion, FeedbackType type, FeedbackState state, String reason) {
            this.id = id;
            this.title = title;
            this.content = content;
            this.author = author;
            this.launcherVersion = launcherVersion;
            this.type = type;
            this.state = state;
            this.reason = reason;
        }

        public int getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getLauncherVersion() {
            return this.launcherVersion;
        }

        public FeedbackType getType() {
            return this.type;
        }

        public FeedbackState getState() {
            return this.state;
        }

        public String getReason() {
            return this.reason;
        }
    }

    private static enum FeedbackState {
        OPEN,
        REJECTED,
        ACCEPTED;

    }

    private static enum FeedbackType {
        FEATURE,
        BUG;

    }

    private class LoginDialog
    extends JFXDialogLayout {
        private final SpinnerPane spinnerPane = new SpinnerPane();
        private final Label errorLabel = new Label();
        private final BooleanProperty logging = new SimpleBooleanProperty();

        public LoginDialog() {
            this.setHeading(new Node[]{new Label(I18n.i18n("feedback.login"))});
            VBox vbox = new VBox(8.0);
            this.setBody(new Node[]{vbox});
            HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
            hintPane.textProperty().bind(BindingMapping.of(this.logging).map(logging -> logging != false ? I18n.i18n("account.methods.microsoft.manual") : I18n.i18n("account.methods.microsoft.hint")));
            hintPane.setOnMouseClicked(e -> {
                if (this.logging.get() && OAuthServer.lastlyOpenedURL != null) {
                    FXUtils.copyText(OAuthServer.lastlyOpenedURL);
                }
            });
            vbox.getChildren().setAll((Object[])new Node[]{hintPane});
            JFXButton loginButton = new JFXButton();
            this.spinnerPane.setContent((Node)loginButton);
            loginButton.setText(I18n.i18n("account.login"));
            loginButton.setOnAction(e -> this.login());
            JFXButton cancelButton = new JFXButton();
            cancelButton.setText(I18n.i18n("button.cancel"));
            cancelButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
            FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
            this.setActions(new Node[]{this.errorLabel, this.spinnerPane, cancelButton});
        }

        private void login() {
            this.spinnerPane.showSpinner();
            this.errorLabel.setText("");
            this.logging.set(true);
            HMCLAccounts.login().whenComplete(Schedulers.javafx(), (result, exception) -> {
                this.logging.set(false);
                if (exception != null) {
                    if (exception instanceof IOException) {
                        this.errorLabel.setText(I18n.i18n("account.failed.connect_authentication_server"));
                    } else if (exception instanceof JsonParseException) {
                        this.errorLabel.setText(I18n.i18n("account.failed.server_response_malformed"));
                    } else {
                        this.errorLabel.setText(Accounts.localizeErrorMessage(exception));
                    }
                } else {
                    this.fireEvent(new DialogCloseEvent());
                }
            }).start();
        }
    }

    private static class ViewFeedbackDialog
    extends JFXDialogLayout {
        public ViewFeedbackDialog(FeedbackResponse feedback) {
            BorderPane heading = new BorderPane();
            TwoLineListItem left = new TwoLineListItem();
            heading.setLeft((Node)left);
            left.setTitle(feedback.getTitle());
            left.setSubtitle(feedback.getAuthor());
            left.getTags().add((Object)("#" + feedback.getId()));
            left.getTags().add((Object)I18n.i18n("feedback.state." + feedback.getState().name().toLowerCase(Locale.US)));
            left.getTags().add((Object)feedback.getLauncherVersion());
            left.getTags().add((Object)I18n.i18n("feedback.type." + feedback.getType().name().toLowerCase()));
            this.setHeading(new Node[]{heading});
            Label content = new Label(feedback.getContent());
            content.setWrapText(true);
            TwoLineListItem response = new TwoLineListItem();
            response.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            response.setTitle(I18n.i18n("feedback.response"));
            response.setSubtitle(StringUtils.isBlank(feedback.getReason()) ? I18n.i18n("feedback.response.empty") : feedback.getReason());
            VBox body = new VBox(new Node[]{content, response});
            body.setSpacing(8.0);
            this.setBody(new Node[]{body});
            JFXButton okButton = new JFXButton();
            okButton.setText(I18n.i18n("button.ok"));
            okButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
            this.setActions(new Node[]{okButton});
        }
    }
}

