/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.validation.base.ValidatorBase;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javafx.beans.NamedArg;
import javafx.scene.control.TextInputControl;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public class URLValidator
extends ValidatorBase {
    private final boolean nullable;

    public URLValidator() {
        this(false);
    }

    public URLValidator(@NamedArg(value="nullable") boolean nullable) {
        this(I18n.i18n("input.url"), nullable);
    }

    public URLValidator(@NamedArg(value="message") String message, @NamedArg(value="nullable") boolean nullable) {
        super(message);
        this.nullable = nullable;
    }

    @Override
    protected void eval() {
        if (this.srcControl.get() instanceof TextInputControl) {
            this.evalTextInputField();
        }
    }

    private void evalTextInputField() {
        TextInputControl textField = (TextInputControl)this.srcControl.get();
        if (StringUtils.isBlank(textField.getText())) {
            this.hasErrors.set(!this.nullable);
        } else {
            try {
                new URL(textField.getText()).toURI();
                this.hasErrors.set(false);
            }
            catch (IOException | URISyntaxException e) {
                this.hasErrors.set(true);
            }
        }
    }
}

