/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;

public class HintPane
extends VBox {
    private final Text label = new Text();
    private final StringProperty text = new SimpleStringProperty((Object)this, "text");
    private final TextFlow flow = new TextFlow();

    public HintPane() {
        this(MessageDialogPane.MessageType.INFO);
    }

    public HintPane(MessageDialogPane.MessageType type) {
        this.setFillWidth(true);
        this.getStyleClass().addAll((Object[])new String[]{"hint", type.name().toLowerCase()});
        HBox hbox = new HBox();
        hbox.setAlignment(Pos.CENTER_LEFT);
        switch (type) {
            case INFO: {
                hbox.getChildren().add((Object)SVG.informationOutline(Theme.blackFillBinding(), 16.0, 16.0));
                break;
            }
            case ERROR: {
                hbox.getChildren().add((Object)SVG.closeCircleOutline(Theme.blackFillBinding(), 16.0, 16.0));
                break;
            }
            case SUCCESS: {
                hbox.getChildren().add((Object)SVG.checkCircleOutline(Theme.blackFillBinding(), 16.0, 16.0));
                break;
            }
            case WARNING: {
                hbox.getChildren().add((Object)SVG.alertOutline(Theme.blackFillBinding(), 16.0, 16.0));
                break;
            }
            case QUESTION: {
                hbox.getChildren().add((Object)SVG.helpCircleOutline(Theme.blackFillBinding(), 16.0, 16.0));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized message box message type " + (Object)((Object)type));
            }
        }
        hbox.getChildren().add((Object)new Text(type.getDisplayName()));
        this.flow.getChildren().setAll((Object[])new Node[]{this.label});
        this.getChildren().setAll((Object[])new Node[]{hbox, this.flow});
        this.label.textProperty().bind((ObservableValue)this.text);
        VBox.setMargin((Node)this.flow, (Insets)new Insets(2.0, 2.0, 0.0, 2.0));
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public void setSegment(String segment) {
        this.flow.getChildren().setAll(FXUtils.parseSegment(segment, Controllers::onHyperlinkAction));
    }

    public void setChildren(Node ... children) {
        this.flow.getChildren().setAll((Object[])children);
    }
}

