/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.util.logging.Level;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public class AddAuthlibInjectorServerPane
extends StackPane
implements DialogAware {
    @FXML
    private TransitionPane root;
    @FXML
    private Label lblServerUrl;
    @FXML
    private Label lblServerName;
    @FXML
    private Label lblCreationWarning;
    @FXML
    private Label lblServerWarning;
    @FXML
    private JFXTextField txtServerUrl;
    @FXML
    private JFXDialogLayout addServerPane;
    @FXML
    private JFXDialogLayout confirmServerPane;
    @FXML
    private SpinnerPane nextPane;
    @FXML
    private JFXButton btnAddNext;
    private AuthlibInjectorServer serverBeingAdded;

    public AddAuthlibInjectorServerPane(String url) {
        this();
        this.txtServerUrl.setText(url);
        this.onAddNext();
    }

    public AddAuthlibInjectorServerPane() {
        FXUtils.loadFXML((Node)this, "/assets/fxml/authlib-injector-server-add.fxml");
        this.root.setContent((Node)this.addServerPane, ContainerAnimations.NONE.getAnimationProducer());
        this.btnAddNext.disableProperty().bind((ObservableValue)this.txtServerUrl.textProperty().isEmpty());
        this.nextPane.hideSpinner();
        FXUtils.onEscPressed((Node)this, this::onAddCancel);
    }

    @Override
    public void onDialogShown() {
        this.txtServerUrl.requestFocus();
    }

    private String resolveFetchExceptionMessage(Throwable exception) {
        if (exception instanceof IOException) {
            return I18n.i18n("account.failed.connect_injector_server");
        }
        return exception.getClass().getName() + ": " + exception.getLocalizedMessage();
    }

    @FXML
    private void onAddCancel() {
        this.fireEvent(new DialogCloseEvent());
    }

    @FXML
    private void onAddNext() {
        if (this.btnAddNext.isDisabled()) {
            return;
        }
        this.lblCreationWarning.setText("");
        String url = this.txtServerUrl.getText();
        this.nextPane.showSpinner();
        this.addServerPane.setDisable(true);
        Task.runAsync(() -> {
            this.serverBeingAdded = AuthlibInjectorServer.locateServer(url);
        }).whenComplete(Schedulers.javafx(), exception -> {
            this.addServerPane.setDisable(false);
            this.nextPane.hideSpinner();
            if (exception == null) {
                this.lblServerName.setText(this.serverBeingAdded.getName());
                this.lblServerUrl.setText(this.serverBeingAdded.getUrl());
                this.lblServerWarning.setVisible("http".equals(NetworkUtils.toURL(this.serverBeingAdded.getUrl()).getProtocol()));
                this.root.setContent((Node)this.confirmServerPane, ContainerAnimations.SWIPE_LEFT.getAnimationProducer());
            } else {
                Logging.LOG.log(Level.WARNING, "Failed to resolve auth server: " + url, exception);
                this.lblCreationWarning.setText(this.resolveFetchExceptionMessage(exception));
            }
        }).start();
    }

    @FXML
    private void onAddPrev() {
        this.root.setContent((Node)this.addServerPane, ContainerAnimations.SWIPE_RIGHT.getAnimationProducer());
    }

    @FXML
    private void onAddFinish() {
        if (!ConfigHolder.config().getAuthlibInjectorServers().contains((Object)this.serverBeingAdded)) {
            ConfigHolder.config().getAuthlibInjectorServers().add((Object)this.serverBeingAdded);
        }
        this.fireEvent(new DialogCloseEvent());
    }
}

