/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.annotations.SerializedName;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.jackhuang.hmcl.auth.OAuth;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class HMCLAccounts {
    private static final ObjectProperty<HMCLAccount> account = new SimpleObjectProperty();

    private HMCLAccounts() {
    }

    public static HMCLAccount getAccount() {
        return (HMCLAccount)account.get();
    }

    public static ObjectProperty<HMCLAccount> accountProperty() {
        return account;
    }

    public static void setAccount(HMCLAccount account) {
        HMCLAccounts.account.set((Object)account);
    }

    public static Task<Void> login() {
        String nonce = UUIDTypeAdapter.fromUUID(UUID.randomUUID());
        String scope = "openid offline_access";
        return Task.supplyAsync(() -> {
            OAuth.Session session = Accounts.OAUTH_CALLBACK.startServer();
            Accounts.OAUTH_CALLBACK.openBrowser(NetworkUtils.withQuery("https://login.microsoftonline.com/common/oauth2/v2.0/authorize", Lang.mapOf(Pair.pair("client_id", Accounts.OAUTH_CALLBACK.getClientId()), Pair.pair("response_type", "id_token code"), Pair.pair("response_mode", "form_post"), Pair.pair("scope", scope), Pair.pair("redirect_uri", session.getRedirectURI()), Pair.pair("nonce", nonce))));
            String code = session.waitFor();
            String responseText = HttpRequest.POST("https://login.microsoftonline.com/common/oauth2/v2.0/token").form(Lang.mapOf(Pair.pair("client_id", Accounts.OAUTH_CALLBACK.getClientId()), Pair.pair("code", code), Pair.pair("grant_type", "authorization_code"), Pair.pair("client_secret", Accounts.OAUTH_CALLBACK.getClientSecret()), Pair.pair("redirect_uri", session.getRedirectURI()), Pair.pair("scope", scope))).getString();
            OAuth.AuthorizationResponse response = JsonUtils.fromNonNullJson(responseText, OAuth.AuthorizationResponse.class);
            HMCLAccountProfile profile = HttpRequest.GET("https://hmcl.huangyuhui.net/api/user").header("Token-Type", response.tokenType).header("Access-Token", response.accessToken).header("Authorization-Provider", "microsoft").authorization("Bearer", session.getIdToken()).getJson(HMCLAccountProfile.class);
            return new HMCLAccount("microsoft", profile.nickname, profile.email, profile.role, session.getIdToken(), response.tokenType, response.accessToken, response.refreshToken);
        }).thenAcceptAsync(Schedulers.javafx(), account -> HMCLAccounts.setAccount(account));
    }

    public static class HMCLAccount
    implements HttpRequest.Authorization {
        private final String provider;
        private final String nickname;
        private final String email;
        private final String role;
        private final String idToken;
        private final String tokenType;
        private final String accessToken;
        private final String refreshToken;

        public HMCLAccount(String provider, String nickname, String email, String role, String idToken, String tokenType, String accessToken, String refreshToken) {
            this.provider = provider;
            this.nickname = nickname;
            this.email = email;
            this.role = role;
            this.idToken = idToken;
            this.tokenType = tokenType;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getNickname() {
            return this.nickname;
        }

        public String getEmail() {
            return this.email;
        }

        public String getRole() {
            return this.role;
        }

        public String getIdToken() {
            return this.idToken;
        }

        @Override
        public String getTokenType() {
            return this.tokenType;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }
    }

    private static class HMCLAccountProfile {
        @SerializedName(value="ID")
        String id;
        @SerializedName(value="Provider")
        String provider;
        @SerializedName(value="Email")
        String email;
        @SerializedName(value="NickName")
        String nickname;
        @SerializedName(value="Role")
        String role;

        private HMCLAccountProfile() {
        }
    }
}

