/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.task.FileDownloadTask;

public class RemoteMod {
    private final String slug;
    private final String author;
    private final String title;
    private final String description;
    private final List<String> categories;
    private final String pageUrl;
    private final String iconUrl;
    private final IMod data;

    public RemoteMod(String slug, String author, String title, String description, List<String> categories, String pageUrl, String iconUrl, IMod data) {
        this.slug = slug;
        this.author = author;
        this.title = title;
        this.description = description;
        this.categories = categories;
        this.pageUrl = pageUrl;
        this.iconUrl = iconUrl;
        this.data = data;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public IMod getData() {
        return this.data;
    }

    public static class File {
        private final Map<String, String> hashes;
        private final String url;
        private final String filename;

        public File(Map<String, String> hashes, String url, String filename) {
            this.hashes = hashes;
            this.url = url;
            this.filename = filename;
        }

        public Map<String, String> getHashes() {
            return this.hashes;
        }

        public FileDownloadTask.IntegrityCheck getIntegrityCheck() {
            if (this.hashes.containsKey("md5")) {
                return new FileDownloadTask.IntegrityCheck("MD5", this.hashes.get("sha1"));
            }
            if (this.hashes.containsKey("sha1")) {
                return new FileDownloadTask.IntegrityCheck("SHA-1", this.hashes.get("sha1"));
            }
            if (this.hashes.containsKey("sha512")) {
                return new FileDownloadTask.IntegrityCheck("SHA-256", this.hashes.get("sha1"));
            }
            return null;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static interface IMod {
        public List<RemoteMod> loadDependencies() throws IOException;

        public Stream<Version> loadVersions() throws IOException;
    }

    public static interface IVersion {
        public Type getType();
    }

    public static enum Type {
        CURSEFORGE,
        MODRINTH;

    }

    public static class Version {
        private final IVersion self;
        private final String modid;
        private final String name;
        private final String version;
        private final String changelog;
        private final Instant datePublished;
        private final VersionType versionType;
        private final File file;
        private final List<String> dependencies;
        private final List<String> gameVersions;
        private final List<ModLoaderType> loaders;

        public Version(IVersion self, String modid, String name, String version, String changelog, Instant datePublished, VersionType versionType, File file, List<String> dependencies, List<String> gameVersions, List<ModLoaderType> loaders) {
            this.self = self;
            this.modid = modid;
            this.name = name;
            this.version = version;
            this.changelog = changelog;
            this.datePublished = datePublished;
            this.versionType = versionType;
            this.file = file;
            this.dependencies = dependencies;
            this.gameVersions = gameVersions;
            this.loaders = loaders;
        }

        public IVersion getSelf() {
            return this.self;
        }

        public String getModid() {
            return this.modid;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getChangelog() {
            return this.changelog;
        }

        public Instant getDatePublished() {
            return this.datePublished;
        }

        public VersionType getVersionType() {
            return this.versionType;
        }

        public File getFile() {
            return this.file;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public List<String> getGameVersions() {
            return this.gameVersions;
        }

        public List<ModLoaderType> getLoaders() {
            return this.loaders;
        }
    }

    public static enum VersionType {
        Release,
        Beta,
        Alpha;

    }
}

