/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.MaintainTask;
import org.jackhuang.hmcl.download.game.GameAssetIndexDownloadTask;
import org.jackhuang.hmcl.download.game.GameVerificationFixTask;
import org.jackhuang.hmcl.download.game.LibraryDownloadException;
import org.jackhuang.hmcl.download.java.JavaRepository;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.game.HMCLGameLauncher;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.JavaVersionConstraint;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.CommandTooLongException;
import org.jackhuang.hmcl.launch.DefaultLauncher;
import org.jackhuang.hmcl.launch.ExecutionPolicyLimitException;
import org.jackhuang.hmcl.launch.NotDecompressingNativesException;
import org.jackhuang.hmcl.launch.PermissionException;
import org.jackhuang.hmcl.launch.ProcessCreationException;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.curse.CurseCompletionException;
import org.jackhuang.hmcl.mod.curse.CurseCompletionTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackCompletionTask;
import org.jackhuang.hmcl.mod.server.ServerModpackCompletionTask;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.LauncherVisibility;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.DialogController;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.GameCrashWindow;
import org.jackhuang.hmcl.ui.LogWindow;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class LauncherHelper {
    private final Profile profile;
    private final Account account;
    private final String selectedVersion;
    private File scriptFile;
    private final VersionSetting setting;
    private LauncherVisibility launcherVisibility;
    private boolean showLogs;
    private final TaskExecutorDialogPane launchingStepsPane = new TaskExecutorDialogPane(it -> {});
    public static final Queue<ManagedProcess> PROCESSES = new ConcurrentLinkedQueue<ManagedProcess>();

    public LauncherHelper(Profile profile, Account account, String selectedVersion) {
        this.profile = Objects.requireNonNull(profile);
        this.account = Objects.requireNonNull(account);
        this.selectedVersion = Objects.requireNonNull(selectedVersion);
        this.setting = profile.getVersionSetting(selectedVersion);
        this.launcherVisibility = this.setting.getLauncherVisibility();
        this.showLogs = this.setting.isShowLogs();
        this.launchingStepsPane.setTitle(I18n.i18n("version.launch"));
    }

    public void setTestMode() {
        this.launcherVisibility = LauncherVisibility.KEEP;
        this.showLogs = true;
    }

    public void setKeep() {
        this.launcherVisibility = LauncherVisibility.KEEP;
    }

    public void launch() {
        FXUtils.checkFxUserThread();
        Logging.LOG.info("Launching game version: " + this.selectedVersion);
        Controllers.dialog((Region)this.launchingStepsPane);
        this.launch0();
    }

    public void makeLaunchScript(File scriptFile) {
        this.scriptFile = Objects.requireNonNull(scriptFile);
        this.launch();
    }

    private void launch0() {
        HMCLGameRepository repository = this.profile.getRepository();
        DefaultDependencyManager dependencyManager = this.profile.getDependency();
        Version version = MaintainTask.maintain(repository, repository.getResolvedVersion(this.selectedVersion));
        Optional<String> gameVersion = repository.getGameVersion(version);
        boolean integrityCheck = repository.unmarkVersionLaunchedAbnormally(this.selectedVersion);
        CountDownLatch launchingLatch = new CountDownLatch(1);
        ArrayList javaAgents = new ArrayList(0);
        AtomicReference javaVersionRef = new AtomicReference();
        LauncherHelper.getLog4jPatch(version).ifPresent(javaAgents::add);
        TaskExecutor executor = LauncherHelper.checkGameState(this.profile, this.setting, version).thenComposeAsync(javaVersion -> {
            javaVersionRef.set(Objects.requireNonNull(javaVersion));
            return dependencyManager.checkPatchCompletionAsync(repository.getVersion(this.selectedVersion), integrityCheck);
        }).thenComposeAsync(Task.allOf(Task.composeAsync(() -> {
            if (this.setting.isNotCheckGame()) {
                return null;
            }
            return dependencyManager.checkGameCompletionAsync(version, integrityCheck);
        }), Task.composeAsync(() -> {
            if (this.setting.isNotCheckGame()) {
                return null;
            }
            try {
                ModpackConfiguration<?> configuration = ModpackHelper.readModpackConfiguration(repository.getModpackConfiguration(this.selectedVersion));
                if ("Curse".equals(configuration.getType())) {
                    return new CurseCompletionTask(dependencyManager, this.selectedVersion);
                }
                if ("Server".equals(configuration.getType())) {
                    return new ServerModpackCompletionTask(dependencyManager, this.selectedVersion);
                }
                if ("Mcbbs".equals(configuration.getType())) {
                    return new McbbsModpackCompletionTask(dependencyManager, this.selectedVersion);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }))).withStage("launch.state.dependencies").thenComposeAsync(() -> gameVersion.map(s -> new GameVerificationFixTask(dependencyManager, (String)s, version)).orElse(null)).thenComposeAsync(Task.supplyAsync(() -> {
            try {
                return this.account.logIn();
            }
            catch (CredentialExpiredException e) {
                Logging.LOG.info("Credential has expired: " + e);
                return DialogController.logIn(this.account);
            }
            catch (AuthenticationException e) {
                Logging.LOG.warning("Authentication failed, try playing offline: " + e);
                return this.account.playOffline().orElseThrow(() -> e);
            }
        }).withStage("launch.state.logging_in")).thenComposeAsync(authInfo -> Task.supplyAsync(() -> {
            LaunchOptions launchOptions = repository.getLaunchOptions(this.selectedVersion, (JavaVersion)javaVersionRef.get(), this.profile.getGameDir(), javaAgents, this.scriptFile != null);
            return new HMCLGameLauncher(repository, version, (AuthInfo)authInfo, launchOptions, this.launcherVisibility == LauncherVisibility.CLOSE ? null : new HMCLProcessListener(repository, version, (AuthInfo)authInfo, launchOptions, launchingLatch, gameVersion.isPresent()));
        }).thenComposeAsync(launcher -> {
            if (this.scriptFile == null) {
                return Task.supplyAsync(launcher::launch);
            }
            return Task.supplyAsync(() -> {
                launcher.makeLaunchScript(this.scriptFile);
                return null;
            });
        }).thenAcceptAsync(process -> {
            if (this.scriptFile == null) {
                PROCESSES.add((ManagedProcess)process);
                if (this.launcherVisibility == LauncherVisibility.CLOSE) {
                    Launcher.stopApplication();
                } else {
                    this.launchingStepsPane.setCancel(it -> {
                        process.stop();
                        it.fireEvent((Event)new DialogCloseEvent());
                    });
                }
            } else {
                Platform.runLater(() -> {
                    this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                    Controllers.dialog(I18n.i18n("version.launch_script.success", this.scriptFile.getAbsolutePath()));
                });
            }
        }).thenRunAsync(() -> launchingLatch.await()).withStage("launch.state.waiting_launching")).withStagesHint(Lang.immutableListOf("launch.state.java", "launch.state.dependencies", "launch.state.logging_in", "launch.state.waiting_launching")).executor();
        this.launchingStepsPane.setExecutor(executor, false);
        executor.addTaskListener(new TaskListener(){

            @Override
            public void onStop(boolean success, TaskExecutor executor) {
                Platform.runLater(() -> {
                    if (!Controllers.isStopped()) {
                        Exception ex;
                        LauncherHelper.this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                        if (!success && !((ex = executor.getException()) instanceof CancellationException)) {
                            String message;
                            if (ex instanceof CurseCompletionException) {
                                message = ex.getCause() instanceof FileNotFoundException ? I18n.i18n("modpack.type.curse.not_found") : I18n.i18n("modpack.type.curse.error");
                            } else if (ex instanceof PermissionException) {
                                message = I18n.i18n("launch.failed.executable_permission");
                            } else if (ex instanceof ProcessCreationException) {
                                message = I18n.i18n("launch.failed.creating_process") + ex.getLocalizedMessage();
                            } else if (ex instanceof NotDecompressingNativesException) {
                                message = I18n.i18n("launch.failed.decompressing_natives") + ex.getLocalizedMessage();
                            } else if (ex instanceof LibraryDownloadException) {
                                message = I18n.i18n("launch.failed.download_library", ((LibraryDownloadException)ex).getLibrary().getName()) + "\n";
                                if (ex.getCause() instanceof ResponseCodeException) {
                                    ResponseCodeException rce = (ResponseCodeException)ex.getCause();
                                    int responseCode = rce.getResponseCode();
                                    URL url = rce.getUrl();
                                    message = responseCode == 404 ? message + I18n.i18n("download.code.404", url) : message + I18n.i18n("download.failed", url, responseCode);
                                } else {
                                    message = message + StringUtils.getStackTrace(ex.getCause());
                                }
                            } else if (ex instanceof DownloadException) {
                                URL url = ((DownloadException)ex).getUrl();
                                if (ex.getCause() instanceof SocketTimeoutException) {
                                    message = I18n.i18n("install.failed.downloading.timeout", url);
                                } else if (ex.getCause() instanceof ResponseCodeException) {
                                    ResponseCodeException responseCodeException = (ResponseCodeException)ex.getCause();
                                    message = I18n.hasKey("download.code." + responseCodeException.getResponseCode()) ? I18n.i18n("download.code." + responseCodeException.getResponseCode(), url) : I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(ex.getCause());
                                } else {
                                    message = I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(ex.getCause());
                                }
                            } else if (ex instanceof GameAssetIndexDownloadTask.GameAssetIndexMalformedException) {
                                message = I18n.i18n("assets.index.malformed");
                            } else if (ex instanceof AuthlibInjectorDownloadException) {
                                message = I18n.i18n("account.failed.injector_download_failure");
                            } else if (ex instanceof CharacterDeletedException) {
                                message = I18n.i18n("account.failed.character_deleted");
                            } else if (ex instanceof ResponseCodeException) {
                                ResponseCodeException rce = (ResponseCodeException)ex;
                                int responseCode = rce.getResponseCode();
                                URL url = rce.getUrl();
                                message = responseCode == 404 ? I18n.i18n("download.code.404", url) : I18n.i18n("download.failed", url, responseCode);
                            } else if (ex instanceof CommandTooLongException) {
                                message = I18n.i18n("launch.failed.command_too_long");
                            } else {
                                if (ex instanceof ExecutionPolicyLimitException) {
                                    Controllers.prompt(new PromptDialogPane.Builder(I18n.i18n("launch.failed.execution_policy"), (result, resolve, reject) -> {
                                        if (CommandBuilder.setExecutionPolicy()) {
                                            Logging.LOG.info("Set the ExecutionPolicy for the scope 'CurrentUser' to 'RemoteSigned'");
                                            resolve.run();
                                        } else {
                                            Logging.LOG.warning("Failed to set ExecutionPolicy");
                                            reject.accept(I18n.i18n("launch.failed.execution_policy.failed_to_set"));
                                        }
                                    }).addQuestion(new PromptDialogPane.Builder.HintQuestion(I18n.i18n("launch.failed.execution_policy.hint"))));
                                    return;
                                }
                                message = ex instanceof AccessDeniedException ? I18n.i18n("exception.access_denied", ((AccessDeniedException)ex).getFile()) : StringUtils.getStackTrace(ex);
                            }
                            Controllers.dialog(message, LauncherHelper.this.scriptFile == null ? I18n.i18n("launch.failed") : I18n.i18n("version.launch_script.failed"), MessageDialogPane.MessageType.ERROR);
                        }
                    }
                    LauncherHelper.this.launchingStepsPane.setExecutor(null);
                });
            }
        });
        executor.start();
    }

    private static Task<JavaVersion> checkGameState(Profile profile, VersionSetting setting, Version version) {
        VersionNumber gameVersion = VersionNumber.asVersion(profile.getRepository().getGameVersion(version).orElse("Unknown"));
        if (setting.isNotCheckJVM()) {
            return Task.composeAsync(() -> setting.getJavaVersion(gameVersion, version)).thenApplyAsync(javaVersion -> Optional.ofNullable(javaVersion).orElseGet(JavaVersion::fromCurrentEnvironment)).withStage("launch.state.java");
        }
        return Task.composeAsync(() -> setting.getJavaVersion(gameVersion, version)).thenComposeAsync(Schedulers.javafx(), javaVersion -> {
            if (javaVersion == null) {
                CompletableFuture future = new CompletableFuture();
                Runnable continueAction = () -> future.complete(JavaVersion.fromCurrentEnvironment());
                if (setting.isJavaAutoSelected()) {
                    GameJavaVersion targetJavaVersion;
                    JavaVersionConstraint.VersionRanges range = JavaVersionConstraint.findSuitableJavaVersionRange(gameVersion, version);
                    if (range.getMandatory().contains(VersionNumber.asVersion("17.0.1"))) {
                        targetJavaVersion = GameJavaVersion.JAVA_17;
                    } else if (range.getMandatory().contains(VersionNumber.asVersion("16.0.1"))) {
                        targetJavaVersion = GameJavaVersion.JAVA_16;
                    } else {
                        String java8Version = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "1.8.0_51" : (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX ? "1.8.0_202" : (OperatingSystem.CURRENT_OS == OperatingSystem.OSX ? "1.8.0_74" : null));
                        targetJavaVersion = java8Version != null && range.getMandatory().contains(VersionNumber.asVersion(java8Version)) ? GameJavaVersion.JAVA_8 : null;
                    }
                    if (targetJavaVersion != null) {
                        ((CompletableFuture)LauncherHelper.downloadJava(gameVersion.toString(), targetJavaVersion, profile).thenAcceptAsync(downloadedJavaVersion -> future.complete(downloadedJavaVersion))).exceptionally(throwable -> {
                            Logging.LOG.log(Level.WARNING, "Failed to download java", (Throwable)throwable);
                            Controllers.dialog(I18n.i18n("launch.failed.no_accepted_java"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                            return null;
                        });
                    }
                } else {
                    Controllers.dialog(I18n.i18n("launch.wrong_javadir"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                    setting.setJava(null);
                    setting.setDefaultJavaPath(null);
                    setting.setJavaVersion(JavaVersion.fromCurrentEnvironment());
                }
                return Task.fromCompletableFuture(future);
            }
            return Task.completed(javaVersion);
        }).thenComposeAsync(javaVersion -> Task.allOf(Task.completed(javaVersion), Task.supplyAsync(() -> JavaVersionConstraint.findSuitableJavaVersion(gameVersion, version)))).thenComposeAsync(Schedulers.javafx(), javaVersions -> {
            JavaVersion javaVersion = (JavaVersion)javaVersions.get(0);
            JavaVersion suggestedJavaVersion = (JavaVersion)javaVersions.get(1);
            if (setting.isJavaAutoSelected()) {
                return Task.completed(javaVersion);
            }
            Enum violatedMandatoryConstraint = null;
            JavaVersionConstraint violatedSuggestedConstraint = null;
            for (JavaVersionConstraint constraint : JavaVersionConstraint.ALL) {
                if (!constraint.appliesToVersion(gameVersion, version, javaVersion) || constraint.checkJava(gameVersion, version, javaVersion)) continue;
                if (constraint.getType() == 1) {
                    violatedMandatoryConstraint = constraint;
                    continue;
                }
                if (constraint.getType() != 2) continue;
                violatedSuggestedConstraint = constraint;
            }
            boolean suggested = false;
            CompletableFuture<JavaVersion> future = new CompletableFuture<JavaVersion>();
            Runnable continueAction = () -> future.complete(javaVersion);
            Runnable breakAction = () -> future.completeExceptionally(new CancellationException("Launch operation was cancelled by user"));
            if (violatedMandatoryConstraint != null) {
                if (suggestedJavaVersion != null) {
                    Controllers.confirm(I18n.i18n("launch.advice.java.auto"), I18n.i18n("message.warning"), () -> {
                        setting.setJavaAutoSelected();
                        future.complete(suggestedJavaVersion);
                    }, breakAction);
                    return Task.fromCompletableFuture(future);
                }
                switch (2.$SwitchMap$org$jackhuang$hmcl$game$JavaVersionConstraint[violatedMandatoryConstraint.ordinal()]) {
                    case 1: {
                        ((CompletableFuture)LauncherHelper.downloadJava(gameVersion.toString(), version.getJavaVersion(), profile).thenAcceptAsync(downloadedJavaVersion -> {
                            setting.setJavaVersion((JavaVersion)downloadedJavaVersion);
                            future.complete((JavaVersion)downloadedJavaVersion);
                        }, Schedulers.javafx())).whenCompleteAsync((result, throwable) -> {
                            Logging.LOG.log(Level.WARNING, "Failed to download java", (Throwable)throwable);
                            breakAction.run();
                        }, Schedulers.javafx());
                        return Task.fromCompletableFuture(future);
                    }
                    case 2: {
                        Controllers.confirm(I18n.i18n("launch.advice.require_newer_java_version", gameVersion.toString(), 16), I18n.i18n("message.warning"), () -> FXUtils.openLink("https://adoptium.net/?variant=openjdk17"), breakAction);
                        return null;
                    }
                    case 3: {
                        Controllers.confirm(I18n.i18n("launch.advice.require_newer_java_version", gameVersion.toString(), 17), I18n.i18n("message.warning"), () -> FXUtils.openLink("https://adoptium.net/?variant=openjdk17"), breakAction);
                        return null;
                    }
                    case 4: {
                        Controllers.dialog(I18n.i18n("launch.advice.java8_1_13"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return null;
                    }
                    case 5: {
                        if (setting.getNativesDirType() != NativesDirectoryType.VERSION_FOLDER) break;
                        Controllers.dialog(I18n.i18n("launch.advice.vanilla_linux_java_8"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return null;
                    }
                    case 6: {
                        if (setting.getNativesDirType() != NativesDirectoryType.VERSION_FOLDER) break;
                        if (Architecture.SYSTEM_ARCH == Architecture.ARM64 && (OperatingSystem.CURRENT_OS == OperatingSystem.OSX || OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && OperatingSystem.SYSTEM_BUILD_NUMBER >= 21277)) {
                            Controllers.dialog(I18n.i18n("launch.advice.vanilla_x86.translation"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                            return null;
                        }
                        Controllers.dialog(I18n.i18n("launch.advice.vanilla_x86"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return null;
                    }
                    case 7: {
                        Controllers.dialog(I18n.i18n("launch.advice.java9") + "\n" + I18n.i18n("launch.advice.uncorrected"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return null;
                    }
                }
            }
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64 && javaVersion.getPlatform().getArchitecture() == Architecture.X86) {
                Controllers.dialog(I18n.i18n("launch.advice.different_platform"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.ERROR, continueAction);
                suggested = true;
            }
            if (javaVersion.getBits() == Bits.BIT_32 && (double)setting.getMaxMemory() > 1536.0) {
                Controllers.confirm(I18n.i18n("launch.advice.too_large_memory_for_32bit"), I18n.i18n("message.error"), continueAction, breakAction);
                suggested = true;
            }
            if (!suggested && violatedSuggestedConstraint != null) {
                suggested = true;
                switch (violatedSuggestedConstraint) {
                    case MODDED_JAVA_7: {
                        Controllers.dialog(I18n.i18n("launch.advice.java.modded_java_7"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                        return null;
                    }
                    case MODDED_JAVA_8: {
                        Controllers.dialog(I18n.i18n("launch.advice.newer_java"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                        break;
                    }
                    case MODDED_JAVA_16: {
                        Controllers.dialog(I18n.i18n("launch.advice.forge37_0_60"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                        break;
                    }
                    case VANILLA_JAVA_8_51: {
                        Controllers.dialog(I18n.i18n("launch.advice.java8_51_1_13"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                        break;
                    }
                    case MODLAUNCHER_8: {
                        Controllers.dialog(I18n.i18n("launch.advice.modlauncher8"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                    }
                }
            }
            if (!suggested && OperatingSystem.TOTAL_MEMORY > 0 && OperatingSystem.TOTAL_MEMORY < setting.getMaxMemory()) {
                Controllers.confirm(I18n.i18n("launch.advice.not_enough_space", OperatingSystem.TOTAL_MEMORY), I18n.i18n("message.error"), continueAction, breakAction);
                suggested = true;
            }
            if (!suggested) {
                boolean hasForge2760 = version.getLibraries().stream().filter(it -> it.is("net.minecraftforge", "forge")).anyMatch(it -> VersionNumber.VERSION_COMPARATOR.compare("1.12.2-14.23.5.2760", it.getVersion()) <= 0 && VersionNumber.VERSION_COMPARATOR.compare(it.getVersion(), "1.12.2-14.23.5.2773") < 0);
                boolean hasLiteLoader = version.getLibraries().stream().anyMatch(it -> it.is("com.mumfrey", "liteloader"));
                if (hasForge2760 && hasLiteLoader && gameVersion.compareTo(VersionNumber.asVersion("1.12.2")) == 0) {
                    Controllers.confirm(I18n.i18n("launch.advice.forge2760_liteloader"), I18n.i18n("message.error"), continueAction, breakAction);
                    suggested = true;
                }
            }
            if (!suggested) {
                boolean hasForge28_2_2 = version.getLibraries().stream().filter(it -> it.is("net.minecraftforge", "forge")).anyMatch(it -> VersionNumber.VERSION_COMPARATOR.compare("1.14.4-28.2.2", it.getVersion()) <= 0);
                boolean hasOptiFine = version.getLibraries().stream().anyMatch(it -> it.is("optifine", "OptiFine"));
                if (hasForge28_2_2 && hasOptiFine && gameVersion.compareTo(VersionNumber.asVersion("1.14.4")) == 0) {
                    Controllers.confirm(I18n.i18n("launch.advice.forge28_2_2_optifine"), I18n.i18n("message.error"), continueAction, breakAction);
                    suggested = true;
                }
            }
            if (!future.isDone()) {
                future.complete(javaVersion);
            }
            return Task.fromCompletableFuture(future);
        }).withStage("launch.state.java");
    }

    private static CompletableFuture<JavaVersion> downloadJava(String gameVersion, GameJavaVersion javaVersion, Profile profile) {
        CompletableFuture<JavaVersion> future = new CompletableFuture<JavaVersion>();
        JFXHyperlink link = new JFXHyperlink(I18n.i18n("download.external_link"));
        link.setOnAction(e -> {
            FXUtils.openLink("https://docs.microsoft.com/zh-cn/java/openjdk/download");
            future.completeExceptionally(new CancellationException());
        });
        Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("launch.advice.require_newer_java_version", gameVersion, javaVersion.getMajorVersion()), I18n.i18n("message.warning"), MessageDialogPane.MessageType.QUESTION).addAction((Node)link).yesOrNo(() -> ((CompletableFuture)LauncherHelper.downloadJavaImpl(javaVersion, profile.getDependency().getDownloadProvider()).thenAcceptAsync(downloadedJava -> future.complete((JavaVersion)downloadedJava))).exceptionally(throwable -> {
            Throwable resolvedException = Lang.resolveException(throwable);
            Logging.LOG.log(Level.WARNING, "Failed to download java", (Throwable)throwable);
            if (!(resolvedException instanceof CancellationException)) {
                Controllers.dialog(DownloadProviders.localizeErrorMessage(resolvedException), I18n.i18n("install.failed"));
            }
            future.completeExceptionally(new CancellationException());
            return null;
        }), () -> future.completeExceptionally(new CancellationException())).build());
        return future;
    }

    private static CompletableFuture<JavaVersion> downloadJavaImpl(GameJavaVersion javaVersion, DownloadProvider downloadProvider) {
        CompletableFuture<JavaVersion> future = new CompletableFuture<JavaVersion>();
        TaskExecutorDialogPane javaDownloadingPane = new TaskExecutorDialogPane(it -> {});
        TaskExecutor executor = JavaRepository.downloadJava(javaVersion, downloadProvider).whenComplete(Schedulers.javafx(), (downloadedJava, exception) -> {
            if (exception != null) {
                future.completeExceptionally(exception);
            } else {
                future.complete((JavaVersion)downloadedJava);
            }
        }).executor(false);
        javaDownloadingPane.setExecutor(executor, true);
        Controllers.dialog((Region)javaDownloadingPane);
        executor.start();
        return future;
    }

    private static Optional<String> getLog4jPatch(Version version) {
        Optional<String> log4jVersion = version.getLibraries().stream().filter(it -> it.is("org.apache.logging.log4j", "log4j-core") && (VersionNumber.VERSION_COMPARATOR.compare(it.getVersion(), "2.17") < 0 || "2.0-beta9".equals(it.getVersion()))).map(Library::getVersion).findFirst();
        if (log4jVersion.isPresent()) {
            String agentFileName = "log4j-patch-agent-1.0.jar";
            Path agentFile = Metadata.HMCL_DIRECTORY.resolve("log4j-patch-agent-1.0.jar").toAbsolutePath();
            String agentFilePath = agentFile.toString();
            if (agentFilePath.indexOf(61) >= 0) {
                Logging.LOG.warning("Invalid character '=' in the HMCL directory path, unable to attach log4j-patch");
                return Optional.empty();
            }
            if (Files.notExists(agentFile, new LinkOption[0])) {
                try (InputStream input = DefaultLauncher.class.getResourceAsStream("/assets/game/log4j-patch-agent-1.0.jar");){
                    Logging.LOG.info("Extract log4j patch to " + agentFilePath);
                    Files.createDirectories(agentFile.getParent(), new FileAttribute[0]);
                    Files.copy(input, agentFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to extract log4j patch");
                    try {
                        Files.deleteIfExists(agentFile);
                    }
                    catch (IOException ex) {
                        Logging.LOG.log(Level.WARNING, "Failed to delete incomplete log4j patch", ex);
                    }
                    return Optional.empty();
                }
            }
            boolean isBeta = log4jVersion.get().startsWith("2.0-beta");
            return Optional.of(agentFilePath + "=" + isBeta);
        }
        Logging.LOG.info("No log4j with security vulnerabilities found");
        return Optional.empty();
    }

    private void checkExit() {
        switch (this.launcherVisibility) {
            case HIDE_AND_REOPEN: {
                Platform.runLater(() -> Optional.ofNullable(Controllers.getStage()).ifPresent(Stage::show));
                break;
            }
            case KEEP: {
                break;
            }
            case CLOSE: {
                throw new Error("Never get to here");
            }
            case HIDE: {
                Platform.runLater(() -> {
                    Platform.setImplicitExit((boolean)true);
                    Launcher.stopWithoutPlatform();
                });
            }
        }
    }

    public static void stopManagedProcesses() {
        while (!PROCESSES.isEmpty()) {
            Optional.ofNullable(PROCESSES.poll()).ifPresent(ManagedProcess::stop);
        }
    }

    class HMCLProcessListener
    implements ProcessListener {
        private final HMCLGameRepository repository;
        private final Version version;
        private final Map<String, String> forbiddenTokens;
        private final LaunchOptions launchOptions;
        private ManagedProcess process;
        private boolean lwjgl;
        private LogWindow logWindow;
        private final boolean detectWindow;
        private final LinkedList<Pair<String, Log4jLevel>> logs;
        private final CountDownLatch logWindowLatch = new CountDownLatch(1);
        private final CountDownLatch launchingLatch;

        public HMCLProcessListener(HMCLGameRepository repository, Version version, AuthInfo authInfo, LaunchOptions launchOptions, CountDownLatch launchingLatch, boolean detectWindow) {
            this.repository = repository;
            this.version = version;
            this.launchOptions = launchOptions;
            this.launchingLatch = launchingLatch;
            this.detectWindow = detectWindow;
            this.forbiddenTokens = authInfo == null ? Collections.emptyMap() : Lang.mapOf(Pair.pair(authInfo.getAccessToken(), "<access token>"));
            this.logs = new LinkedList();
        }

        @Override
        public void setProcess(ManagedProcess process) {
            this.process = process;
            String command = new CommandBuilder().addAll(process.getCommands()).toString();
            for (Map.Entry<String, String> entry : this.forbiddenTokens.entrySet()) {
                command = command.replace(entry.getKey(), entry.getValue());
            }
            Logging.LOG.info("Launched process: " + command);
            String classpath = process.getClasspath();
            if (classpath != null) {
                Logging.LOG.info("Process ClassPath: " + classpath);
            }
            if (LauncherHelper.this.showLogs) {
                Platform.runLater(() -> {
                    this.logWindow = new LogWindow();
                    this.logWindow.showNormal();
                    this.logWindowLatch.countDown();
                });
            }
        }

        private void finishLaunch() {
            switch (LauncherHelper.this.launcherVisibility) {
                case HIDE_AND_REOPEN: {
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().hide();
                            this.launchingLatch.countDown();
                        }
                    });
                    break;
                }
                case CLOSE: {
                    break;
                }
                case KEEP: {
                    Platform.runLater(this.launchingLatch::countDown);
                    break;
                }
                case HIDE: {
                    this.launchingLatch.countDown();
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().close();
                            Controllers.shutdown();
                            Schedulers.shutdown();
                        }
                    });
                }
            }
        }

        @Override
        public synchronized void onLog(String log, Log4jLevel level) {
            String newLog = log;
            for (Map.Entry<String, String> entry : this.forbiddenTokens.entrySet()) {
                newLog = newLog.replace(entry.getKey(), entry.getValue());
            }
            String filteredLog = newLog;
            if (level.lessOrEqual(Log4jLevel.ERROR)) {
                System.err.println(filteredLog);
            } else {
                System.out.println(filteredLog);
            }
            this.logs.add(Pair.pair(filteredLog, level));
            if (this.logs.size() > ConfigHolder.config().getLogLines()) {
                this.logs.removeFirst();
            }
            if (LauncherHelper.this.showLogs) {
                try {
                    this.logWindowLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                Platform.runLater(() -> this.logWindow.logLine(filteredLog, level));
            }
            if (!this.lwjgl && (filteredLog.toLowerCase().contains("lwjgl version") || filteredLog.toLowerCase().contains("lwjgl openal") || !this.detectWindow)) {
                this.lwjgl = true;
                this.finishLaunch();
            }
        }

        @Override
        public void onExit(int exitCode, ProcessListener.ExitType exitType) {
            this.launchingLatch.countDown();
            if (exitType == ProcessListener.ExitType.INTERRUPTED) {
                return;
            }
            if (!this.lwjgl) {
                this.finishLaunch();
            }
            if (exitType != ProcessListener.ExitType.NORMAL) {
                this.repository.markVersionLaunchedAbnormally(this.version.getId());
                Platform.runLater(() -> new GameCrashWindow(this.process, exitType, this.repository, this.version, this.launchOptions, this.logs).show());
            }
            LauncherHelper.this.checkExit();
        }
    }
}

