/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Nullable;

public enum JavaVersionConstraint {
    VANILLA_JAVA_16(1, JavaVersionConstraint.versionRange("1.17", "10000"), JavaVersionConstraint.versionRange("16", "10000")),
    VANILLA_JAVA_17(1, JavaVersionConstraint.versionRange("1.18", "10000"), JavaVersionConstraint.versionRange("17", "10000")),
    MODDED_JAVA_16(2, (Range)JavaVersionConstraint.versionIs("1.17.1"), (Range)JavaVersionConstraint.versionRange("16", "16.999")){

        @Override
        protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
            if (version == null) {
                return false;
            }
            VersionNumber forgePatchVersion = LibraryAnalyzer.analyze(version).getVersion(LibraryAnalyzer.LibraryType.FORGE).map(LibraryAnalyzer.LibraryType.FORGE::patchVersion).map(VersionNumber::asVersion).orElse(null);
            return forgePatchVersion != null && forgePatchVersion.compareTo(VersionNumber.asVersion("37.0.60")) < 0;
        }
    }
    ,
    VANILLA_JAVA_8(1, JavaVersionConstraint.versionRange("1.13", "10000"), JavaVersionConstraint.versionRange("1.8", "10000")),
    MODDED_JAVA_8(2, JavaVersionConstraint.versionRange("1.7.10", "10000"), JavaVersionConstraint.versionRange("1.8", "10000")),
    MODDED_JAVA_7(2, (Range)JavaVersionConstraint.versionRange("0", "1.7.2"), (Range)JavaVersionConstraint.versionRange("0", "1.7.999")){

        @Override
        protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
            if (version == null) {
                return false;
            }
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(version);
            return analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    LAUNCH_WRAPPER(1, (Range)JavaVersionConstraint.versionRange("0", "1.12.999"), (Range)JavaVersionConstraint.versionRange("0", "1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
            if (version == null) {
                return false;
            }
            return "net.minecraft.launchwrapper.Launch".equals(version.getMainClass()) && version.getLibraries().stream().filter(library -> "launchwrapper".equals(library.getArtifactId())).anyMatch(library -> VersionNumber.asVersion(library.getVersion()).compareTo(VersionNumber.asVersion("1.13")) < 0);
        }
    }
    ,
    VANILLA_JAVA_8_51(2, JavaVersionConstraint.versionRange("1.13", "10000"), JavaVersionConstraint.versionRange("1.8.0_51", "10000")),
    GAME_JSON(1, (Range)JavaVersionConstraint.versionRange("0", "10000"), (Range)JavaVersionConstraint.versionRange("0", "10000")){

        @Override
        protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
            if (version == null) {
                return false;
            }
            return gameVersionNumber.compareTo(VersionNumber.asVersion("1.7.10")) >= 0 && version.getJavaVersion() != null;
        }

        @Override
        public Range<VersionNumber> getJavaVersionRange(Version version) {
            String javaVersion = Objects.requireNonNull(version.getJavaVersion()).getMajorVersion() >= 9 ? "" + version.getJavaVersion().getMajorVersion() : "1." + version.getJavaVersion().getMajorVersion();
            return JavaVersionConstraint.versionRange(javaVersion, JavaVersionConstraint.MAX);
        }
    }
    ,
    VANILLA_LINUX_JAVA_8(1, (Range)JavaVersionConstraint.versionRange("0", "1.12.999"), (Range)JavaVersionConstraint.versionRange("0", "1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
            return OperatingSystem.CURRENT_OS == OperatingSystem.LINUX && Architecture.SYSTEM_ARCH == Architecture.X86_64 && (javaVersion == null || javaVersion.getArchitecture() == Architecture.X86_64);
        }

        @Override
        public boolean checkJava(VersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
            return javaVersion.getArchitecture() != Architecture.X86_64 || super.checkJava(gameVersionNumber, version, javaVersion);
        }
    }
    ,
    VANILLA_X86(1, (Range)JavaVersionConstraint.versionRange("0", "10000"), (Range)JavaVersionConstraint.versionRange("0", "10000")){

        @Override
        protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
            return javaVersion != null && !javaVersion.getArchitecture().isX86();
        }

        @Override
        public boolean checkJava(VersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
            return javaVersion.getArchitecture().isX86();
        }
    }
    ,
    MODLAUNCHER_8(2, (Range)JavaVersionConstraint.versionRange("1.16.3", "1.17.1"), (Range)JavaVersionConstraint.versionRange("0", "10000")){

        @Override
        protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
            if (version == null || javaVersion == null) {
                return false;
            }
            VersionNumber forgePatchVersion = LibraryAnalyzer.analyze(version).getVersion(LibraryAnalyzer.LibraryType.FORGE).map(LibraryAnalyzer.LibraryType.FORGE::patchVersion).map(VersionNumber::asVersion).orElse(null);
            if (forgePatchVersion == null) {
                return false;
            }
            switch (gameVersionNumber.toString()) {
                case "1.16.3": {
                    return forgePatchVersion.compareTo(VersionNumber.asVersion("34.1.27")) >= 0;
                }
                case "1.16.4": {
                    return true;
                }
                case "1.16.5": {
                    return forgePatchVersion.compareTo(VersionNumber.asVersion("36.2.23")) <= 0;
                }
                case "1.17.1": {
                    return JavaVersionConstraint.versionRange("37.0.60", "37.0.75").contains(forgePatchVersion);
                }
            }
            return false;
        }

        @Override
        public boolean checkJava(VersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
            int parsedJavaVersion = javaVersion.getParsedVersion();
            if (parsedJavaVersion > 17) {
                return false;
            }
            if (parsedJavaVersion == 8) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("1.8.0_321")) < 0;
            }
            if (parsedJavaVersion == 11) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("11.0.14")) < 0;
            }
            if (parsedJavaVersion == 15) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("15.0.6")) < 0;
            }
            if (parsedJavaVersion == 17) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("17.0.2")) < 0;
            }
            return true;
        }
    };

    private final int type;
    private final Range<VersionNumber> gameVersionRange;
    private final Range<VersionNumber> javaVersionRange;
    public static final List<JavaVersionConstraint> ALL;
    public static final int RULE_MANDATORY = 1;
    public static final int RULE_SUGGESTED = 2;
    public static final String MIN = "0";
    public static final String MAX = "10000";

    private JavaVersionConstraint(int type, Range<VersionNumber> gameVersionRange, Range<VersionNumber> javaVersionRange) {
        this.type = type;
        this.gameVersionRange = gameVersionRange;
        this.javaVersionRange = javaVersionRange;
    }

    public int getType() {
        return this.type;
    }

    public Range<VersionNumber> getGameVersionRange() {
        return this.gameVersionRange;
    }

    public Range<VersionNumber> getJavaVersionRange(Version version) {
        return this.javaVersionRange;
    }

    public final boolean appliesToVersion(@Nullable VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
        return this.gameVersionRange.contains(gameVersionNumber) && this.appliesToVersionImpl(gameVersionNumber, version, javaVersion);
    }

    protected boolean appliesToVersionImpl(VersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion) {
        return true;
    }

    public boolean checkJava(VersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
        return this.getJavaVersionRange(version).contains(javaVersion.getVersionNumber());
    }

    public static VersionRanges findSuitableJavaVersionRange(VersionNumber gameVersion, Version version) {
        Range<VersionNumber> mandatoryJavaRange = JavaVersionConstraint.versionRange(MIN, MAX);
        Range<VersionNumber> suggestedJavaRange = JavaVersionConstraint.versionRange(MIN, MAX);
        for (JavaVersionConstraint java : ALL) {
            if (!java.appliesToVersion(gameVersion, version, null)) continue;
            Range<VersionNumber> javaVersionRange = java.getJavaVersionRange(version);
            if (java.type == 1) {
                mandatoryJavaRange = mandatoryJavaRange.intersectionWith(javaVersionRange);
                suggestedJavaRange = suggestedJavaRange.intersectionWith(javaVersionRange);
                continue;
            }
            if (java.type != 2) continue;
            suggestedJavaRange = suggestedJavaRange.intersectionWith(javaVersionRange);
        }
        return new VersionRanges(mandatoryJavaRange, suggestedJavaRange);
    }

    @Nullable
    public static JavaVersion findSuitableJavaVersion(VersionNumber gameVersion, Version version) throws InterruptedException {
        VersionRanges range = JavaVersionConstraint.findSuitableJavaVersionRange(gameVersion, version);
        JavaVersion mandatory = null;
        JavaVersion suggested = null;
        for (JavaVersion javaVersion : JavaVersion.getJavas()) {
            if (!javaVersion.getArchitecture().isX86()) continue;
            VersionNumber javaVersionNumber = javaVersion.getVersionNumber();
            if (range.getMandatory().contains(javaVersionNumber)) {
                if (mandatory == null) {
                    mandatory = javaVersion;
                } else if (JavaVersionConstraint.compareJavaVersion(javaVersion, mandatory) > 0) {
                    mandatory = javaVersion;
                }
            }
            if (!range.getSuggested().contains(javaVersionNumber)) continue;
            if (suggested == null) {
                suggested = javaVersion;
                continue;
            }
            if (JavaVersionConstraint.compareJavaVersion(javaVersion, suggested) <= 0) continue;
            suggested = javaVersion;
        }
        if (suggested != null) {
            return suggested;
        }
        return mandatory;
    }

    private static int compareJavaVersion(JavaVersion javaVersion1, JavaVersion javaVersion2) {
        Architecture arch2;
        Architecture arch1 = javaVersion1.getArchitecture();
        if (arch1 != (arch2 = javaVersion2.getArchitecture())) {
            if (arch1 == Architecture.X86_64) {
                return 1;
            }
            if (arch2 == Architecture.X86_64) {
                return -1;
            }
        }
        return javaVersion1.getVersionNumber().compareTo(javaVersion2.getVersionNumber());
    }

    private static Range<VersionNumber> versionRange(String fromInclusive, String toExclusive) {
        return Range.between(VersionNumber.asVersion(fromInclusive), VersionNumber.asVersion(toExclusive));
    }

    static Range<VersionNumber> versionIs(String version) {
        return Range.is(VersionNumber.asVersion(version));
    }

    static {
        ALL = Lang.immutableListOf(JavaVersionConstraint.values());
    }

    public static class VersionRanges {
        private final Range<VersionNumber> mandatory;
        private final Range<VersionNumber> suggested;

        public VersionRanges(Range<VersionNumber> mandatory, Range<VersionNumber> suggested) {
            this.mandatory = mandatory;
            this.suggested = suggested;
        }

        public Range<VersionNumber> getMandatory() {
            return this.mandatory;
        }

        public Range<VersionNumber> getSuggested() {
            return this.suggested;
        }
    }
}

