/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jackhuang.hmcl.game.AssetIndex;
import org.jackhuang.hmcl.game.AssetObject;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.LoggingInfo;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.game.VersionNotFoundException;
import org.jackhuang.hmcl.game.VersionProvider;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.platform.Platform;

public interface GameRepository
extends VersionProvider {
    @Override
    public boolean hasVersion(String var1);

    @Override
    public Version getVersion(String var1) throws VersionNotFoundException;

    default public Version getResolvedVersion(String id) throws VersionNotFoundException {
        return this.getVersion(id).resolve(this);
    }

    default public Version getResolvedPreservingPatchesVersion(String id) throws VersionNotFoundException {
        return this.getVersion(id).resolvePreservingPatches(this);
    }

    public int getVersionCount();

    public Collection<Version> getVersions();

    public void refreshVersions();

    default public Task<Void> refreshVersionsAsync() {
        return Task.runAsync(this::refreshVersions);
    }

    public File getVersionRoot(String var1);

    public File getRunDirectory(String var1);

    public File getLibrariesDirectory(Version var1);

    public File getLibraryFile(Version var1, Library var2);

    public File getNativeDirectory(String var1, Platform var2);

    public File getVersionJar(Version var1);

    public Optional<String> getGameVersion(Version var1);

    default public Optional<String> getGameVersion(String versionId) throws VersionNotFoundException {
        return this.getGameVersion(this.getVersion(versionId));
    }

    default public File getVersionJar(String version) throws VersionNotFoundException {
        return this.getVersionJar(this.getVersion(version).resolve(this));
    }

    public boolean renameVersion(String var1, String var2);

    public Path getActualAssetDirectory(String var1, String var2);

    public Path getAssetDirectory(String var1, String var2);

    public Optional<Path> getAssetObject(String var1, String var2, String var3) throws IOException;

    public Path getAssetObject(String var1, String var2, AssetObject var3);

    public AssetIndex getAssetIndex(String var1, String var2) throws IOException;

    public Path getIndexFile(String var1, String var2);

    public Path getLoggingObject(String var1, String var2, LoggingInfo var3);

    default public List<String> getClasspath(Version version) {
        ArrayList<String> classpath = new ArrayList<String>();
        for (Library library : version.getLibraries()) {
            File f;
            if (!library.appliesToCurrentEnvironment() || library.isNative() || !(f = this.getLibraryFile(version, library)).exists() || !f.isFile()) continue;
            classpath.add(f.getAbsolutePath());
        }
        return classpath;
    }
}

