/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;

public class Texture {
    private final String hash;
    private final byte[] data;
    private static final Map<String, Texture> textures = new HashMap<String, Texture>();

    public Texture(String hash, byte[] data) {
        this.hash = Objects.requireNonNull(hash);
        this.data = Objects.requireNonNull(data);
    }

    public byte[] getData() {
        return this.data;
    }

    public String getHash() {
        return this.hash;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public int getLength() {
        return this.data.length;
    }

    public static boolean hasTexture(String hash) {
        return textures.containsKey(hash);
    }

    public static Texture getTexture(String hash) {
        return textures.get(hash);
    }

    private static String computeTextureHash(BufferedImage img) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        int width = img.getWidth();
        int height = img.getHeight();
        byte[] buf = new byte[4096];
        Texture.putInt(buf, 0, width);
        Texture.putInt(buf, 4, height);
        int pos = 8;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Texture.putInt(buf, pos, img.getRGB(x, y));
                if (buf[pos + 0] == 0) {
                    buf[pos + 3] = 0;
                    buf[pos + 2] = 0;
                    buf[pos + 1] = 0;
                }
                if ((pos += 4) != buf.length) continue;
                pos = 0;
                digest.update(buf, 0, buf.length);
            }
        }
        if (pos > 0) {
            digest.update(buf, 0, pos);
        }
        byte[] sha256 = digest.digest();
        return String.format("%0" + (sha256.length << 1) + "x", new BigInteger(1, sha256));
    }

    private static void putInt(byte[] array, int offset, int x) {
        array[offset + 0] = (byte)(x >> 24 & 0xFF);
        array[offset + 1] = (byte)(x >> 16 & 0xFF);
        array[offset + 2] = (byte)(x >> 8 & 0xFF);
        array[offset + 3] = (byte)(x >> 0 & 0xFF);
    }

    public static Texture loadTexture(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        BufferedImage img = ImageIO.read(in);
        if (img == null) {
            throw new IIOException("No image found");
        }
        String hash = Texture.computeTextureHash(img);
        Texture existent = textures.get(hash);
        if (existent != null) {
            return existent;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", buf);
        Texture texture = new Texture(hash, buf.toByteArray());
        existent = textures.putIfAbsent(hash, texture);
        if (existent != null) {
            return existent;
        }
        return texture;
    }

    public static Texture loadTexture(String url) throws IOException {
        if (url == null) {
            return null;
        }
        return Texture.loadTexture(new URL(url).openStream());
    }
}

