/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Main;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.SambaException;
import org.jackhuang.hmcl.task.AsyncTaskExecutor;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.AwtUtils;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.CrashReporter;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Launcher
extends Application {
    public static final CookieManager COOKIE_MANAGER = new CookieManager();
    public static final CrashReporter CRASH_REPORTER = new CrashReporter(true);

    public void start(Stage primaryStage) {
        Thread.currentThread().setUncaughtExceptionHandler(CRASH_REPORTER);
        CookieHandler.setDefault(COOKIE_MANAGER);
        try {
            try {
                ConfigHolder.init();
            }
            catch (SambaException ignored) {
                Main.showWarningAndContinue(I18n.i18n("fatal.samba"));
            }
            catch (IOException e) {
                Logging.LOG.log(Level.SEVERE, "Failed to load config", e);
                Main.showErrorAndExit(I18n.i18n("fatal.config_loading_failure", Paths.get("", new String[0]).toAbsolutePath().normalize()));
            }
            if (Metadata.HMCL_DIRECTORY.toAbsolutePath().toString().indexOf(61) >= 0) {
                Main.showWarningAndContinue(I18n.i18n("fatal.illegal_char"));
            }
            Platform.runLater(() -> {
                Platform.setImplicitExit((boolean)false);
                Controllers.initialize(primaryStage);
                this.initIcon();
                UpdateChecker.init();
                primaryStage.show();
            });
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    public void stop() throws Exception {
        super.stop();
        Controllers.onApplicationStop();
    }

    private void initIcon() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(Launcher.class.getResource("/assets/img/icon.png"));
        AwtUtils.setAppleIcon(image);
    }

    public static void main(String[] args) {
        if (UpdateHandler.processArguments(args)) {
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(CRASH_REPORTER);
        AsyncTaskExecutor.setUncaughtExceptionHandler(new CrashReporter(false));
        try {
            Logging.LOG.info("*** " + Metadata.TITLE + " ***");
            Logging.LOG.info("Operating System: " + OperatingSystem.SYSTEM_NAME + ' ' + OperatingSystem.SYSTEM_VERSION);
            Logging.LOG.info("System Architecture: " + Architecture.SYSTEM_ARCH_NAME);
            Logging.LOG.info("Java Architecture: " + Architecture.CURRENT_ARCH_NAME);
            Logging.LOG.info("Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
            Logging.LOG.info("Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
            Logging.LOG.info("Java Home: " + System.getProperty("java.home"));
            Logging.LOG.info("Current Directory: " + Paths.get("", new String[0]).toAbsolutePath());
            Logging.LOG.info("HMCL Directory: " + Metadata.HMCL_DIRECTORY);
            Logging.LOG.info("Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "MB");
            ManagementFactory.getMemoryPoolMXBeans().stream().filter(bean -> bean.getName().equals("Metaspace")).findAny().ifPresent(bean -> Logging.LOG.info("Metaspace: " + bean.getUsage().getUsed() / 1024L / 1024L + "MB"));
            Launcher.launch(Launcher.class, (String[])args);
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    public static void stopApplication() {
        Logging.LOG.info("Stopping application.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Platform.exit();
        });
    }

    public static void stopWithoutPlatform() {
        Logging.LOG.info("Stopping application without JavaFX Toolkit.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Lang.executeDelayed(OperatingSystem::forceGC, TimeUnit.SECONDS, 5L, true);
        });
    }

    /*
     * Unable to fully structure code
     */
    public static List<File> getCurrentJarFiles() {
        result = new LinkedList<File>();
        if (Launcher.class.getClassLoader() instanceof URLClassLoader) {
            for (URL u : urls = ((URLClassLoader)Launcher.class.getClassLoader()).getURLs()) {
                try {
                    f = new File(u.toURI());
                    if (!f.isFile() || !f.getName().endsWith(".exe") && !f.getName().endsWith(".jar")) continue;
                    result.add(f);
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        } else {
            try {
                jarFile = new File(URLDecoder.decode(Launcher.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
                ext = FileUtils.getExtension(jarFile);
                if (!"jar".equals(ext) && !"exe".equals(ext)) ** GOTO lbl23
                result.add(jarFile);
            }
            catch (UnsupportedEncodingException e) {
                Logging.LOG.log(Level.WARNING, "Failed to decode jar path", e);
                return null;
            }
        }
lbl23:
        // 3 sources

        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

