/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.TheabyssModElements;

public class TheabyssModVariables {
    @CapabilityInject(value=PlayerVariables.class)
    public static Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = null;

    public TheabyssModVariables(TheabyssModElements elements) {
        elements.addNetworkMessage(WorldSavedDataSyncMessage.class, WorldSavedDataSyncMessage::buffer, WorldSavedDataSyncMessage::new, WorldSavedDataSyncMessage::handler);
        elements.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
    }

    private void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PlayerVariables.class, (Capability.IStorage)new PlayerVariablesStorage(), PlayerVariables::new);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            MapVariables mapdata = MapVariables.get((IWorld)event.getPlayer().field_70170_p);
            WorldVariables worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p);
            if (mapdata != null) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.func_201670_d() && (worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p)) != null) {
            TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("theabyss", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        clone.SaveFD = original.SaveFD;
        clone.SaveY = original.SaveY;
        clone.SaveZ = original.SaveZ;
        clone.BookSpawn = original.BookSpawn;
        clone.SaveX = original.SaveX;
        clone.SaveHP = original.SaveHP;
        clone.SleepEvent = original.SleepEvent;
        clone.Mana = original.Mana;
        clone.WandAbility = original.WandAbility;
        clone.RadioEvent = original.RadioEvent;
        clone.AbyssCloak = original.AbyssCloak;
        clone.ManaBarToggle = original.ManaBarToggle;
        clone.ManaBlinkAnimation = original.ManaBlinkAnimation;
        clone.ManaUpgrade = original.ManaUpgrade;
        clone.ManaRegenUpgrade = original.ManaRegenUpgrade;
        clone.SleepEvent2 = original.SleepEvent2;
        clone.GetConfigVersion = original.GetConfigVersion;
        clone.ArmorPotionLevel = original.ArmorPotionLevel;
        clone.FearEffect = original.FearEffect;
        clone.EnableSomnium = original.EnableSomnium;
        clone.Prolog = original.Prolog;
        clone.ManaCooldown = original.ManaCooldown;
        clone.ManaDurability = original.ManaDurability;
        clone.ManaDamage = original.ManaDamage;
        clone.Playername = original.Playername;
        clone.PlayerRep = original.PlayerRep;
        clone.NightbladeY = original.NightbladeY;
        clone.NightbladeX = original.NightbladeX;
        clone.NightbladeZ = original.NightbladeZ;
        clone.HomeY = original.HomeY;
        clone.HomeZ = original.HomeZ;
        clone.HomeX = original.HomeX;
        clone.RingOfHome = original.RingOfHome;
        clone.PocketPlayerZ = original.PocketPlayerZ;
        clone.PocketPlayerY = original.PocketPlayerY;
        clone.PocketPlayerX = original.PocketPlayerX;
        clone.PocketDimension = original.PocketDimension;
        clone.ClockX = original.ClockX;
        clone.ClockY = original.ClockY;
        clone.ClockZ = original.ClockZ;
        clone.ClockActive = original.ClockActive;
        clone.FoundBody = original.FoundBody;
        clone.DestriyAfterLifeItem = original.DestriyAfterLifeItem;
        clone.FireworkOnJoin = original.FireworkOnJoin;
        clone.ParticlesOnDeath = original.ParticlesOnDeath;
        clone.WalkParticles = original.WalkParticles;
        clone.P3 = original.P3;
        clone.P4 = original.P4;
        clone.P5 = original.P5;
        clone.P6 = original.P6;
        clone.NetherX = original.NetherX;
        clone.NetherY = original.NetherY;
        clone.NetherZ = original.NetherZ;
        clone.EndX = original.EndX;
        clone.EndY = original.EndY;
        clone.EndZ = original.EndZ;
        clone.AbyssX = original.AbyssX;
        clone.AbyssY = original.AbyssY;
        clone.AbyssZ = original.AbyssZ;
        clone.OverworldX = original.OverworldX;
        clone.OverworldY = original.OverworldY;
        clone.OverworldZ = original.OverworldZ;
        clone.CrimsonCrystalResearch = original.CrimsonCrystalResearch;
        clone.WarpedCrystalResearch = original.WarpedCrystalResearch;
        clone.EnderCrystalResearch = original.EnderCrystalResearch;
        clone.AbyssCrystalResearch = original.AbyssCrystalResearch;
        clone.FrostCrystalResearch = original.FrostCrystalResearch;
        clone.HollowCrystalResearch = original.HollowCrystalResearch;
        clone.LPMMode = original.LPMMode;
        clone.EnableManaBar = original.EnableManaBar;
        clone.FirstJoin = original.FirstJoin;
        clone.PX = original.PX;
        clone.HudX = original.HudX;
        clone.HudY = original.HudY;
        clone.HasAbsorb = original.HasAbsorb;
        clone.HasArmor = original.HasArmor;
        clone.HasExtraHP = original.HasExtraHP;
        clone.BarComp = original.BarComp;
        clone.EmptySomnium = original.EmptySomnium;
        clone.SomniumHandler = original.SomniumHandler;
        clone.EternalAbyss = original.EternalAbyss;
        clone.EA_Intro = original.EA_Intro;
        clone.FriendMode = original.FriendMode;
        clone.Infected = original.Infected;
        clone.Freeze = original.Freeze;
        clone.CavernaCrystalResearch = original.CavernaCrystalResearch;
        clone.AurelCrystalResearch = original.AurelCrystalResearch;
        if (!event.isWasDeath()) {
            // empty if block
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(PacketBuffer buffer) {
            this.data = new PlayerVariables();
            new PlayerVariablesStorage().readNBT(null, this.data, null, (INBT)buffer.func_150793_b());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, PacketBuffer buffer) {
            buffer.func_150786_a((CompoundNBT)new PlayerVariablesStorage().writeNBT(null, message.data, null));
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.func_71410_x().field_71439_g.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.SaveFD = message.data.SaveFD;
                    variables.SaveY = message.data.SaveY;
                    variables.SaveZ = message.data.SaveZ;
                    variables.BookSpawn = message.data.BookSpawn;
                    variables.SaveX = message.data.SaveX;
                    variables.SaveHP = message.data.SaveHP;
                    variables.SleepEvent = message.data.SleepEvent;
                    variables.Mana = message.data.Mana;
                    variables.WandAbility = message.data.WandAbility;
                    variables.RadioEvent = message.data.RadioEvent;
                    variables.AbyssCloak = message.data.AbyssCloak;
                    variables.ManaBarToggle = message.data.ManaBarToggle;
                    variables.ManaBlinkAnimation = message.data.ManaBlinkAnimation;
                    variables.ManaUpgrade = message.data.ManaUpgrade;
                    variables.ManaRegenUpgrade = message.data.ManaRegenUpgrade;
                    variables.SleepEvent2 = message.data.SleepEvent2;
                    variables.GetConfigVersion = message.data.GetConfigVersion;
                    variables.ArmorPotionLevel = message.data.ArmorPotionLevel;
                    variables.FearEffect = message.data.FearEffect;
                    variables.EnableSomnium = message.data.EnableSomnium;
                    variables.Prolog = message.data.Prolog;
                    variables.ManaCooldown = message.data.ManaCooldown;
                    variables.ManaDurability = message.data.ManaDurability;
                    variables.ManaDamage = message.data.ManaDamage;
                    variables.Playername = message.data.Playername;
                    variables.PlayerRep = message.data.PlayerRep;
                    variables.NightbladeY = message.data.NightbladeY;
                    variables.NightbladeX = message.data.NightbladeX;
                    variables.NightbladeZ = message.data.NightbladeZ;
                    variables.HomeY = message.data.HomeY;
                    variables.HomeZ = message.data.HomeZ;
                    variables.HomeX = message.data.HomeX;
                    variables.RingOfHome = message.data.RingOfHome;
                    variables.PocketPlayerZ = message.data.PocketPlayerZ;
                    variables.PocketPlayerY = message.data.PocketPlayerY;
                    variables.PocketPlayerX = message.data.PocketPlayerX;
                    variables.PocketDimension = message.data.PocketDimension;
                    variables.ClockX = message.data.ClockX;
                    variables.ClockY = message.data.ClockY;
                    variables.ClockZ = message.data.ClockZ;
                    variables.ClockActive = message.data.ClockActive;
                    variables.FoundBody = message.data.FoundBody;
                    variables.DestriyAfterLifeItem = message.data.DestriyAfterLifeItem;
                    variables.FireworkOnJoin = message.data.FireworkOnJoin;
                    variables.ParticlesOnDeath = message.data.ParticlesOnDeath;
                    variables.WalkParticles = message.data.WalkParticles;
                    variables.P3 = message.data.P3;
                    variables.P4 = message.data.P4;
                    variables.P5 = message.data.P5;
                    variables.P6 = message.data.P6;
                    variables.NetherX = message.data.NetherX;
                    variables.NetherY = message.data.NetherY;
                    variables.NetherZ = message.data.NetherZ;
                    variables.EndX = message.data.EndX;
                    variables.EndY = message.data.EndY;
                    variables.EndZ = message.data.EndZ;
                    variables.AbyssX = message.data.AbyssX;
                    variables.AbyssY = message.data.AbyssY;
                    variables.AbyssZ = message.data.AbyssZ;
                    variables.OverworldX = message.data.OverworldX;
                    variables.OverworldY = message.data.OverworldY;
                    variables.OverworldZ = message.data.OverworldZ;
                    variables.CrimsonCrystalResearch = message.data.CrimsonCrystalResearch;
                    variables.WarpedCrystalResearch = message.data.WarpedCrystalResearch;
                    variables.EnderCrystalResearch = message.data.EnderCrystalResearch;
                    variables.AbyssCrystalResearch = message.data.AbyssCrystalResearch;
                    variables.FrostCrystalResearch = message.data.FrostCrystalResearch;
                    variables.HollowCrystalResearch = message.data.HollowCrystalResearch;
                    variables.LPMMode = message.data.LPMMode;
                    variables.EnableManaBar = message.data.EnableManaBar;
                    variables.FirstJoin = message.data.FirstJoin;
                    variables.PX = message.data.PX;
                    variables.HudX = message.data.HudX;
                    variables.HudY = message.data.HudY;
                    variables.HasAbsorb = message.data.HasAbsorb;
                    variables.HasArmor = message.data.HasArmor;
                    variables.HasExtraHP = message.data.HasExtraHP;
                    variables.BarComp = message.data.BarComp;
                    variables.EmptySomnium = message.data.EmptySomnium;
                    variables.SomniumHandler = message.data.SomniumHandler;
                    variables.EternalAbyss = message.data.EternalAbyss;
                    variables.EA_Intro = message.data.EA_Intro;
                    variables.FriendMode = message.data.FriendMode;
                    variables.Infected = message.data.Infected;
                    variables.Freeze = message.data.Freeze;
                    variables.CavernaCrystalResearch = message.data.CavernaCrystalResearch;
                    variables.AurelCrystalResearch = message.data.AurelCrystalResearch;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double SaveFD = 0.0;
        public double SaveY = 0.0;
        public double SaveZ = 0.0;
        public boolean BookSpawn = false;
        public double SaveX = 0.0;
        public double SaveHP = 0.0;
        public boolean SleepEvent = false;
        public double Mana = 0.0;
        public String WandAbility = "";
        public boolean RadioEvent = false;
        public boolean AbyssCloak = false;
        public boolean ManaBarToggle = false;
        public boolean ManaBlinkAnimation = false;
        public double ManaUpgrade = 1.0;
        public double ManaRegenUpgrade = 0.0;
        public boolean SleepEvent2 = false;
        public String GetConfigVersion = "";
        public double ArmorPotionLevel = 0.0;
        public boolean FearEffect = true;
        public boolean EnableSomnium = true;
        public boolean Prolog = true;
        public double ManaCooldown = 1.0;
        public double ManaDurability = 1.0;
        public double ManaDamage = 0.0;
        public String Playername = "";
        public double PlayerRep = 0.0;
        public double NightbladeY = 0.0;
        public double NightbladeX = 0.0;
        public double NightbladeZ = 0.0;
        public double HomeY = 0.0;
        public double HomeZ = 0.0;
        public double HomeX = 0.0;
        public boolean RingOfHome = false;
        public double PocketPlayerZ = 0.0;
        public double PocketPlayerY = 0.0;
        public double PocketPlayerX = 0.0;
        public boolean PocketDimension = false;
        public double ClockX = 0.0;
        public double ClockY = 0.0;
        public double ClockZ = 0.0;
        public boolean ClockActive = false;
        public boolean FoundBody = false;
        public boolean DestriyAfterLifeItem = false;
        public boolean FireworkOnJoin = false;
        public boolean ParticlesOnDeath = false;
        public boolean WalkParticles = false;
        public boolean P3 = false;
        public boolean P4 = false;
        public boolean P5 = false;
        public boolean P6 = false;
        public double NetherX = 0.0;
        public double NetherY = 0.0;
        public double NetherZ = 0.0;
        public double EndX = 0.0;
        public double EndY = 0.0;
        public double EndZ = 0.0;
        public double AbyssX = 0.0;
        public double AbyssY = 0.0;
        public double AbyssZ = 0.0;
        public double OverworldX = 0.0;
        public double OverworldY = 0.0;
        public double OverworldZ = 0.0;
        public boolean CrimsonCrystalResearch = false;
        public boolean WarpedCrystalResearch = false;
        public boolean EnderCrystalResearch = false;
        public boolean AbyssCrystalResearch = false;
        public boolean FrostCrystalResearch = false;
        public boolean HollowCrystalResearch = false;
        public boolean LPMMode = false;
        public boolean EnableManaBar = false;
        public boolean FirstJoin = false;
        public boolean PX = false;
        public double HudX = 0.0;
        public double HudY = 0.0;
        public boolean HasAbsorb = false;
        public boolean HasArmor = false;
        public boolean HasExtraHP = false;
        public boolean BarComp = false;
        public boolean EmptySomnium = false;
        public boolean SomniumHandler = false;
        public boolean EternalAbyss = false;
        public boolean EA_Intro = false;
        public boolean FriendMode = false;
        public double Infected = 0.0;
        public double Freeze = 0.0;
        public boolean CavernaCrystalResearch = false;
        public boolean AurelCrystalResearch = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayerEntity) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new PlayerVariablesSyncMessage(this));
            }
        }
    }

    private static class PlayerVariablesStorage
    implements Capability.IStorage<PlayerVariables> {
        private PlayerVariablesStorage() {
        }

        public INBT writeNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74780_a("SaveFD", instance.SaveFD);
            nbt.func_74780_a("SaveY", instance.SaveY);
            nbt.func_74780_a("SaveZ", instance.SaveZ);
            nbt.func_74757_a("BookSpawn", instance.BookSpawn);
            nbt.func_74780_a("SaveX", instance.SaveX);
            nbt.func_74780_a("SaveHP", instance.SaveHP);
            nbt.func_74757_a("SleepEvent", instance.SleepEvent);
            nbt.func_74780_a("Mana", instance.Mana);
            nbt.func_74778_a("WandAbility", instance.WandAbility);
            nbt.func_74757_a("RadioEvent", instance.RadioEvent);
            nbt.func_74757_a("AbyssCloak", instance.AbyssCloak);
            nbt.func_74757_a("ManaBarToggle", instance.ManaBarToggle);
            nbt.func_74757_a("ManaBlinkAnimation", instance.ManaBlinkAnimation);
            nbt.func_74780_a("ManaUpgrade", instance.ManaUpgrade);
            nbt.func_74780_a("ManaRegenUpgrade", instance.ManaRegenUpgrade);
            nbt.func_74757_a("SleepEvent2", instance.SleepEvent2);
            nbt.func_74778_a("GetConfigVersion", instance.GetConfigVersion);
            nbt.func_74780_a("ArmorPotionLevel", instance.ArmorPotionLevel);
            nbt.func_74757_a("FearEffect", instance.FearEffect);
            nbt.func_74757_a("EnableSomnium", instance.EnableSomnium);
            nbt.func_74757_a("Prolog", instance.Prolog);
            nbt.func_74780_a("ManaCooldown", instance.ManaCooldown);
            nbt.func_74780_a("ManaDurability", instance.ManaDurability);
            nbt.func_74780_a("ManaDamage", instance.ManaDamage);
            nbt.func_74778_a("Playername", instance.Playername);
            nbt.func_74780_a("PlayerRep", instance.PlayerRep);
            nbt.func_74780_a("NightbladeY", instance.NightbladeY);
            nbt.func_74780_a("NightbladeX", instance.NightbladeX);
            nbt.func_74780_a("NightbladeZ", instance.NightbladeZ);
            nbt.func_74780_a("HomeY", instance.HomeY);
            nbt.func_74780_a("HomeZ", instance.HomeZ);
            nbt.func_74780_a("HomeX", instance.HomeX);
            nbt.func_74757_a("RingOfHome", instance.RingOfHome);
            nbt.func_74780_a("PocketPlayerZ", instance.PocketPlayerZ);
            nbt.func_74780_a("PocketPlayerY", instance.PocketPlayerY);
            nbt.func_74780_a("PocketPlayerX", instance.PocketPlayerX);
            nbt.func_74757_a("PocketDimension", instance.PocketDimension);
            nbt.func_74780_a("ClockX", instance.ClockX);
            nbt.func_74780_a("ClockY", instance.ClockY);
            nbt.func_74780_a("ClockZ", instance.ClockZ);
            nbt.func_74757_a("ClockActive", instance.ClockActive);
            nbt.func_74757_a("FoundBody", instance.FoundBody);
            nbt.func_74757_a("DestriyAfterLifeItem", instance.DestriyAfterLifeItem);
            nbt.func_74757_a("FireworkOnJoin", instance.FireworkOnJoin);
            nbt.func_74757_a("ParticlesOnDeath", instance.ParticlesOnDeath);
            nbt.func_74757_a("WalkParticles", instance.WalkParticles);
            nbt.func_74757_a("P3", instance.P3);
            nbt.func_74757_a("P4", instance.P4);
            nbt.func_74757_a("P5", instance.P5);
            nbt.func_74757_a("P6", instance.P6);
            nbt.func_74780_a("NetherX", instance.NetherX);
            nbt.func_74780_a("NetherY", instance.NetherY);
            nbt.func_74780_a("NetherZ", instance.NetherZ);
            nbt.func_74780_a("EndX", instance.EndX);
            nbt.func_74780_a("EndY", instance.EndY);
            nbt.func_74780_a("EndZ", instance.EndZ);
            nbt.func_74780_a("AbyssX", instance.AbyssX);
            nbt.func_74780_a("AbyssY", instance.AbyssY);
            nbt.func_74780_a("AbyssZ", instance.AbyssZ);
            nbt.func_74780_a("OverworldX", instance.OverworldX);
            nbt.func_74780_a("OverworldY", instance.OverworldY);
            nbt.func_74780_a("OverworldZ", instance.OverworldZ);
            nbt.func_74757_a("CrimsonCrystalResearch", instance.CrimsonCrystalResearch);
            nbt.func_74757_a("WarpedCrystalResearch", instance.WarpedCrystalResearch);
            nbt.func_74757_a("EnderCrystalResearch", instance.EnderCrystalResearch);
            nbt.func_74757_a("AbyssCrystalResearch", instance.AbyssCrystalResearch);
            nbt.func_74757_a("FrostCrystalResearch", instance.FrostCrystalResearch);
            nbt.func_74757_a("HollowCrystalResearch", instance.HollowCrystalResearch);
            nbt.func_74757_a("LPMMode", instance.LPMMode);
            nbt.func_74757_a("EnableManaBar", instance.EnableManaBar);
            nbt.func_74757_a("FirstJoin", instance.FirstJoin);
            nbt.func_74757_a("PX", instance.PX);
            nbt.func_74780_a("HudX", instance.HudX);
            nbt.func_74780_a("HudY", instance.HudY);
            nbt.func_74757_a("HasAbsorb", instance.HasAbsorb);
            nbt.func_74757_a("HasArmor", instance.HasArmor);
            nbt.func_74757_a("HasExtraHP", instance.HasExtraHP);
            nbt.func_74757_a("BarComp", instance.BarComp);
            nbt.func_74757_a("EmptySomnium", instance.EmptySomnium);
            nbt.func_74757_a("SomniumHandler", instance.SomniumHandler);
            nbt.func_74757_a("EternalAbyss", instance.EternalAbyss);
            nbt.func_74757_a("EA_Intro", instance.EA_Intro);
            nbt.func_74757_a("FriendMode", instance.FriendMode);
            nbt.func_74780_a("Infected", instance.Infected);
            nbt.func_74780_a("Freeze", instance.Freeze);
            nbt.func_74757_a("CavernaCrystalResearch", instance.CavernaCrystalResearch);
            nbt.func_74757_a("AurelCrystalResearch", instance.AurelCrystalResearch);
            return nbt;
        }

        public void readNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side, INBT inbt) {
            CompoundNBT nbt = (CompoundNBT)inbt;
            instance.SaveFD = nbt.func_74769_h("SaveFD");
            instance.SaveY = nbt.func_74769_h("SaveY");
            instance.SaveZ = nbt.func_74769_h("SaveZ");
            instance.BookSpawn = nbt.func_74767_n("BookSpawn");
            instance.SaveX = nbt.func_74769_h("SaveX");
            instance.SaveHP = nbt.func_74769_h("SaveHP");
            instance.SleepEvent = nbt.func_74767_n("SleepEvent");
            instance.Mana = nbt.func_74769_h("Mana");
            instance.WandAbility = nbt.func_74779_i("WandAbility");
            instance.RadioEvent = nbt.func_74767_n("RadioEvent");
            instance.AbyssCloak = nbt.func_74767_n("AbyssCloak");
            instance.ManaBarToggle = nbt.func_74767_n("ManaBarToggle");
            instance.ManaBlinkAnimation = nbt.func_74767_n("ManaBlinkAnimation");
            instance.ManaUpgrade = nbt.func_74769_h("ManaUpgrade");
            instance.ManaRegenUpgrade = nbt.func_74769_h("ManaRegenUpgrade");
            instance.SleepEvent2 = nbt.func_74767_n("SleepEvent2");
            instance.GetConfigVersion = nbt.func_74779_i("GetConfigVersion");
            instance.ArmorPotionLevel = nbt.func_74769_h("ArmorPotionLevel");
            instance.FearEffect = nbt.func_74767_n("FearEffect");
            instance.EnableSomnium = nbt.func_74767_n("EnableSomnium");
            instance.Prolog = nbt.func_74767_n("Prolog");
            instance.ManaCooldown = nbt.func_74769_h("ManaCooldown");
            instance.ManaDurability = nbt.func_74769_h("ManaDurability");
            instance.ManaDamage = nbt.func_74769_h("ManaDamage");
            instance.Playername = nbt.func_74779_i("Playername");
            instance.PlayerRep = nbt.func_74769_h("PlayerRep");
            instance.NightbladeY = nbt.func_74769_h("NightbladeY");
            instance.NightbladeX = nbt.func_74769_h("NightbladeX");
            instance.NightbladeZ = nbt.func_74769_h("NightbladeZ");
            instance.HomeY = nbt.func_74769_h("HomeY");
            instance.HomeZ = nbt.func_74769_h("HomeZ");
            instance.HomeX = nbt.func_74769_h("HomeX");
            instance.RingOfHome = nbt.func_74767_n("RingOfHome");
            instance.PocketPlayerZ = nbt.func_74769_h("PocketPlayerZ");
            instance.PocketPlayerY = nbt.func_74769_h("PocketPlayerY");
            instance.PocketPlayerX = nbt.func_74769_h("PocketPlayerX");
            instance.PocketDimension = nbt.func_74767_n("PocketDimension");
            instance.ClockX = nbt.func_74769_h("ClockX");
            instance.ClockY = nbt.func_74769_h("ClockY");
            instance.ClockZ = nbt.func_74769_h("ClockZ");
            instance.ClockActive = nbt.func_74767_n("ClockActive");
            instance.FoundBody = nbt.func_74767_n("FoundBody");
            instance.DestriyAfterLifeItem = nbt.func_74767_n("DestriyAfterLifeItem");
            instance.FireworkOnJoin = nbt.func_74767_n("FireworkOnJoin");
            instance.ParticlesOnDeath = nbt.func_74767_n("ParticlesOnDeath");
            instance.WalkParticles = nbt.func_74767_n("WalkParticles");
            instance.P3 = nbt.func_74767_n("P3");
            instance.P4 = nbt.func_74767_n("P4");
            instance.P5 = nbt.func_74767_n("P5");
            instance.P6 = nbt.func_74767_n("P6");
            instance.NetherX = nbt.func_74769_h("NetherX");
            instance.NetherY = nbt.func_74769_h("NetherY");
            instance.NetherZ = nbt.func_74769_h("NetherZ");
            instance.EndX = nbt.func_74769_h("EndX");
            instance.EndY = nbt.func_74769_h("EndY");
            instance.EndZ = nbt.func_74769_h("EndZ");
            instance.AbyssX = nbt.func_74769_h("AbyssX");
            instance.AbyssY = nbt.func_74769_h("AbyssY");
            instance.AbyssZ = nbt.func_74769_h("AbyssZ");
            instance.OverworldX = nbt.func_74769_h("OverworldX");
            instance.OverworldY = nbt.func_74769_h("OverworldY");
            instance.OverworldZ = nbt.func_74769_h("OverworldZ");
            instance.CrimsonCrystalResearch = nbt.func_74767_n("CrimsonCrystalResearch");
            instance.WarpedCrystalResearch = nbt.func_74767_n("WarpedCrystalResearch");
            instance.EnderCrystalResearch = nbt.func_74767_n("EnderCrystalResearch");
            instance.AbyssCrystalResearch = nbt.func_74767_n("AbyssCrystalResearch");
            instance.FrostCrystalResearch = nbt.func_74767_n("FrostCrystalResearch");
            instance.HollowCrystalResearch = nbt.func_74767_n("HollowCrystalResearch");
            instance.LPMMode = nbt.func_74767_n("LPMMode");
            instance.EnableManaBar = nbt.func_74767_n("EnableManaBar");
            instance.FirstJoin = nbt.func_74767_n("FirstJoin");
            instance.PX = nbt.func_74767_n("PX");
            instance.HudX = nbt.func_74769_h("HudX");
            instance.HudY = nbt.func_74769_h("HudY");
            instance.HasAbsorb = nbt.func_74767_n("HasAbsorb");
            instance.HasArmor = nbt.func_74767_n("HasArmor");
            instance.HasExtraHP = nbt.func_74767_n("HasExtraHP");
            instance.BarComp = nbt.func_74767_n("BarComp");
            instance.EmptySomnium = nbt.func_74767_n("EmptySomnium");
            instance.SomniumHandler = nbt.func_74767_n("SomniumHandler");
            instance.EternalAbyss = nbt.func_74767_n("EternalAbyss");
            instance.EA_Intro = nbt.func_74767_n("EA_Intro");
            instance.FriendMode = nbt.func_74767_n("FriendMode");
            instance.Infected = nbt.func_74769_h("Infected");
            instance.Freeze = nbt.func_74769_h("Freeze");
            instance.CavernaCrystalResearch = nbt.func_74767_n("CavernaCrystalResearch");
            instance.AurelCrystalResearch = nbt.func_74767_n("AurelCrystalResearch");
        }
    }

    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<INBT> {
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> PLAYER_VARIABLES_CAPABILITY.getDefaultInstance());

        private PlayerVariablesProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PLAYER_VARIABLES_CAPABILITY.getStorage().writeNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_VARIABLES_CAPABILITY.getStorage().readNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null, nbt);
        }
    }

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            this.data.func_76184_a(buffer.func_150793_b());
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(WorldSavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "theabyss_mapvars";
        public double XTest = 0.0;
        public double ZTest = 0.0;
        public boolean FullSomnium = false;
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.XTest = nbt.func_74769_h("XTest");
            this.ZTest = nbt.func_74769_h("ZTest");
            this.FullSomnium = nbt.func_74767_n("FullSomnium");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74780_a("XTest", this.XTest);
            nbt.func_74780_a("ZTest", this.ZTest);
            nbt.func_74757_a("FullSomnium", this.FullSomnium);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !world.func_201670_d()) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(IWorld world) {
            if (world instanceof IServerWorld) {
                return (MapVariables)((IServerWorld)world).func_201672_e().func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "theabyss_worldvars";
        public double MobLevel = 0.0;
        public double PocketDimensionX = 0.0;
        public double PocketDimensionZ = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.MobLevel = nbt.func_74769_h("MobLevel");
            this.PocketDimensionX = nbt.func_74769_h("PocketDimensionX");
            this.PocketDimensionZ = nbt.func_74769_h("PocketDimensionZ");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74780_a("MobLevel", this.MobLevel);
            nbt.func_74780_a("PocketDimensionX", this.PocketDimensionX);
            nbt.func_74780_a("PocketDimensionZ", this.PocketDimensionZ);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !world.func_201670_d()) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((World)((World)world)).func_234923_W_()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(IWorld world) {
            if (world instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

