# 执行模块

![执——行!](item:tis3d:module_execution)

执行模块是编程TIS-3D计算机的主要手段。当它被安装 在[框架](../block/casing.md)上时，用一本写有代码的书对其使用就可以对它进行编程。为了更愉快的编程体验，你可以考虑投资一本[编码书](book_code.md)。这是任何一个职业码农都应当拥有的，广为使用而久经测试的编程工具。

## 架构
执行模块允许用户以极大灵活性控制TIS-3D计算机的操 作。每个执行模块可使用原始汇编语言进行编程，当然还带有一些优化过的指令集。激活时，执行模块将会从第一个指令开始，逐一处理指令。所有跳转指令以外的指令都会使程序计数器增加一，这样当这条指令执行完时，程序就会自动运行下一条指令。如果程序计数器离开指令的有效范围内(最后一条)，程序会自动从第一条指令执行。**这直接意味着程序循环**。

指令可以对不同类型的目标进行操作。一个目标可以是有效的数据源，或者是可以写入数据的目标。这包括执行模块的四个端口，执行模块的寄存器和少量的虚拟寄存器和端口。

一台TIS-3D计算机，或者说一个执行模块，支持16位的值 范围，符号值范围为-32768至32767。*由于技术上的限制，一些模块，包括执行模块，也许会将数值显示为无符号十六进制*。


## 执行目标
`ACC`
寄存器。这是一个执行模块的首要寄存器。数学运算经常将它们的运算结果储存到这个寄存器中。

`BAK`
不可寻址寄存器。这是一个特殊的寄存器，只可以与ACC进行交互，而不可以被直接寻址。你可以通过`SAV`和`SWP`两个指令写入和读取BAK中的数值。

`NIL`
虚拟寄存器。这是一个假的目标。你可以通过把值写入到这个寄存器中来将其销毁。当你从`NIL`读取时，他会提 供零值。

`LEFT`, `RIGHT`, `UP`, `DOWN`
端口。这几个目标代表着执行模块的四个端口。总体而言，对外部端口的读写操作要慢于对寄存器的操作速度。

`ANY`
虚拟端口。这是一个虚拟的目标，他会对所有的端口同步地进行操作。不过他实质上只会对第一个有效端口进行操作。举个例子，`MOV 10 ANY`会尝试向所有端口写入数值10，但是当数值被任意一个端口接收后，其余端口均不会再次接收这个数值。任何一个端口上成功的写入操作都会取消后续的尝试。
[前译者注：经本人实验，从ANY读入时，如果同时有多个接口输入，优先级是：左>右>上>下；向ANY输出时，如果同时有多个接口可以输出，优先级是上>左>右>下]

`LAST`
虚拟端口。这是一个虚拟的目标，将会指代最近用ANY伪端口读入或写出的端口。

## 编程语言参考
除去指令列表，提供给执行模块的汇编代码还有可能包含元数据：注释是在编译执行时会被完全忽略的文本。标签（Label）是可以给跳转指令提供定位的标记。注释，标签和空行对于一个已经完成编译的程序而言，在寻址时不会产生任何影响。这在使用'JRO'指令时可能会有参考作用。

### 注释（Comments）
注释由开头的井号（`#`）所标记。他们可以作为一个完整的行，也可以附加在指令或者标签代码后。
例:
`# Single line comment`
`LOOP: # Start of loop`
`MOV 0, ACC # Reset`

### 标签（Labels）
标签是一个由冒号（':'）结尾的字符串。标签永远指代着 尾随其后的代码。当被作为跳转指令的目标使用时，程序将会直接跳转到该标签的位置。值得注意的是，你可以用单独的一行作为标签，也可以将一些指令添加在标签后方。这对程序的执行不会有任何影响。
例:
`START: MOV 8, ACC`
`LOOP:`
`SUB 1`
`JGZ LOOP`
`JMP START`
`# Never reached`

### 指令（Instructions）
`NOP`
这是一条伪指令，他不会对执行模块的任何寄存器和端口产生影响。也就是说，完全不会影响执行模块的状态。编译时，他会被自动替换为`ADD NIL`。

#### 数据转移
`MOV <SRC> <DST>`
将`SRC`中的数据转移到`DST`中。上文中已经给出了可用目标的列表。值得一题的是，对内部寄存器或者状态的操作会明显快于对端口的操作。具体的时间消耗并不会在该指南中提供，请参考制造商提供的文档。另外，将数据写入`NIL`相当于直接丢弃数据。
例:
`MOV 8, ACC` 将8写入`ACC`寄存器。
`MOV LEFT, RIGHT` 从左侧端口读入，写入右侧。
`MOV DOWN, NIL` 从下部端口读入，写入`NIL`。

`SWP`
将`ACC`和`BAK`寄存器中的值互换。

`SAV`
将当前`ACC`中的值写入`BAK`。

#### 数学操作
`ADD <SRC>`
从目标`SRC`中读取数据，和当前`ACC`的数据相加，再将结果 赋值给`ACC`。请注意这个操作中的溢出值会被削除。运算结果会被限制在有效值范围内。
例:
`ADD 1` 把1加到`ACC`的当前值。
`ADD LEFT` 从左侧端口读取值，加到`ACC`上。

`SUB <SRC>`
从目标`SRC`中读取数据，从当前`ACC`的数值中减去该值，再 将结果赋值给`ACC`。请注意这个操作中的溢出值会被削除。运算结果会被限制在有效范围以内。
例:
`SUB 1` 将`ACC`的当前值减小1。
`SUB LEFT` 从左侧端口读取值，从`ACC`中减去。

`NEG`
计算`ACC`中数字的相反数，再赋值给`ACC`。

### 位运算
TODO

### 流程控制

`JMP <LABEL>`
执行无条件跳转。跳转到标签`LABEL`后的语句接着执 行。

`JEZ <LABEL>`
执行有条件跳转。如果ACC的值是0，跳转到标签`LABEL`后的语句接着执行，否则执行下一条指令。

`JNZ <LABEL>`
执行有条件跳转。如果ACC的值*不是*0，跳转到标签`LABEL`后的语句接着执行，否则执行下一条指令。

`JGZ <LABEL>`
执行有条件跳转。如果ACC的值*大于*0，跳转到标签`LABEL`后的语句接着执行，否则执行下一条指令。

`JLZ <LABEL>`
执行有条件转移。如果ACC的值*小于*0，跳到标签`LABEL`后的语句接着执行，否则执行下一条指令。

`JRO <SRC>`
无条件跳转到一个相对地址，偏移量由`SRC`中参数确定。 这个指令会将当前`SRC`中的数值加到程序计数器上（执行前程序计数器的数值为当前指令地址），下一条指令则会执行到程序计数器中修改后的地址。`JRO 0`会使得程序 无限停止。

## 译者注
更新这段文本的译文时，注意到之前的译者将相关英文缩写的全称都标注出来了，不过考虑到这可能影响到排版效果，所以我就把相关内容转移到这个部分，稍加补充。

- ACC accumulator 累加器
- BAK backup 备用寄存器
- NIL nothing 空
- NOP no operation 无操作
- MOV move 移动
- SWP swap 交换
- SAV save 存储
- SUB subtract 减
- NEG negate 取反
- JMP jump 跳转
- JEZ jump equal zero 零跳转
- JNZ jump not zero 非零跳转
- JGZ jump greater (than) zero 大于零跳转
- JLZ jump less (than) zero 小于零跳转
- JRO jump relative offset 相对偏移跳转
