# 捆绑红石模块

![16合1](item:tis3d:module_bundled_redstone)

捆绑红石模块用于实现TIS-3D与各厂商生产的捆绑红石 线缆的相互通信。它**仅能**与捆绑电缆连接。针对各种常规的绝缘红石线缆，请参阅常规[红石模块](module_redstone.md)获取更多信息。由于接口有多个频道，捆绑红石模块需要一个更高级的协议。就像普通的[红石模块](module_redstone.md)它允许读取和发送信号。注意，捆绑红石模块将不执行任何信号处理。非法值会导致未定义行为。请查阅您捆绑电缆供应商的技术规范以确定合法数值。

捆绑红石模块有一个活动频道的概念。这决定了模块从哪个频道读取数值。活动频道可以通过提供特定格式的数据来改变(请查阅**技术规范**)。该模块从他的四个输入端口读取参数，解码之后会将给定的信号强度输出到给定的频道(请查阅**技术规范**)。

## 技术规范
捆绑红石模块从端口读取的值被解释为两个单独的值，一个在高位字节( `0xFF00`)另一个在低位字节( `0x00FF`)。高位字节通常代表着将写入的频道。作为唯一的例外，如果高位字节等于`0xFF`低字节包含的数据将用以设置活动频道。换句话说，设置活动频道，也就是读取数据的频道时，高位字节必须包含`0xFF`，而低位字节则是将被激活的 频道编号。

这个例子展示了如何设置执行模块左侧的捆绑红石模块，使其激活6频道：
`MOV 0XFF ACC`
`SHL 8 # HI = 0xFF`
`ADD 6 # LO = 6`
`MOV ACC LEFT`
