# 纳米机器

![纳米机器，小子！](oredict:oc:nanomachines)

这些小家伙能与你的神经系统交互，让你变得更猛更棒更快更强，但也有可能弄死你。有时候二者会同时发生！简而言之，纳米机器是一种需耗能驱动的系统，可以为它们的宿主玩家带来增益（以及负增益）。要“安装”纳米机器只需将它们吃掉！

纳米机器注入你体内后，你的HUD中将会新出现一个能量指示图标，显示了你的纳米机器人还剩余多少电量。站在[充电机](../block/charger.md)旁边即可为它们充电。纳米机器用得越多，能耗就越大。

纳米机器提供了一些可触发的“输入”，它们能对玩家造成不同效果，从视觉效果（如在玩家附近产生粒子特效）到可选择的选择药水效果，以及一些更罕见和特殊的行为！

何种输入触发何种效果取决于纳米机器的当前配置，实际“对应关系”随配置不同而不同。这意味着你只有尝试启用输入才能知道它们的效果。如果你对配置不满意，摄入新的一批纳米机器即可改变配置（多吃就完事了）。要完全清除体内的纳米机器，你可以考虑喝一些[腐蚀液](acid.md)。此外，同时启用太多的输入会产生严重的负面效果！

默认情况下纳米机器处于待机状态。因为你需要用无线网络信息控制它们，所以强烈推荐你携带一块装有[无线网卡](wlanCard1.md)的[平板电脑](tablet.md)。纳米机器只会响应两格范围内设备发出的无线网络信息，但是能响应任何端口上以及任意设备发出的信息！

纳米机器使用一套简单的专有协议：向其发送的每个数据包都必须包含数个部分，第一部分是“信息头”，需要为字符串`nanomachines`。第二部分需要为命令名称。其余部分是命令所需的参数。可用命令在下方列出，格式为`命令名称(参数1, ...)`：

- `setResponsePort(port:number)` - 设定纳米机器发送响应信息所用的端口，对带有响应信息的命令生效。
- `getPowerState()` - 获取纳米机器当前能量值以及能量上限。
- `getHealth()` - 获取玩家的生命值。
- `getHunger()` - 返回当前玩家的饥饿值。
- `getAge()` - 获取玩家的年龄，单位为秒。
- `getName()` - 获取玩家的显示名称。
- `getExperience()` - 获取玩家的经验等级。
- `getTotalInputCount()` -  获取可用输入总数。
- `getSafeActiveInputs()` - 获取最大**安全**启用输入数。
- `getMaxActiveInputs()` - 获取**最大**启用输入数。
- `getInput(index:number)` - 获取指定索引号对应输入的当前状态。
- `setInput(index:number, value:boolean)` - 将指定索引号对应输入的状态设定为指定值。
- `getActiveEffects()` - 获取生效的效果列表。请注意一些效果可能不会在列表中出现。
- `saveConfiguration()` - 玩家物品栏中需要有一份纳米机器，本命令会将当前配置存储到其中。

例如，在OpenOS中：
- `component.modem.broadcast(1, "nanomachines", "setInput", 1, true)`将会启用第一个输入。
- `component.modem.broadcast(1, "nanomachines", "getHealth")`将会获取玩家的健康值信息。
