/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.util.virtualjar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import makamys.neodymium.Constants;
import makamys.neodymium.util.virtualjar.IVirtualJar;
import makamys.neodymium.util.virtualjar.URLStreamHandlerHelper;
import makamys.neodymium.util.virtualjar.protocol.neodymiumvirtualjar.Handler;
import net.minecraft.launchwrapper.Launch;

public class VirtualJar {
    private static boolean registered;
    private static Map<String, IVirtualJar> jars;

    public static void registerHandler() {
        if (registered) {
            return;
        }
        Constants.LOGGER.debug("Registering URL protocol handler: neodymiumvirtualjar");
        Launch.classLoader.addClassLoaderExclusion("makamys.neodymium.util.virtualjar.protocol.neodymiumvirtualjar");
        StreamHandlerImpl streamHandlerImpl = new StreamHandlerImpl();
        Launch.blackboard.put("neodymium.neodymiumvirtualjar.impl", streamHandlerImpl);
        URLStreamHandlerHelper.register(Handler.class);
        registered = true;
    }

    public static void add(IVirtualJar jar) {
        VirtualJar.registerHandler();
        Constants.LOGGER.trace("Adding virtual jar to class path: neodymiumvirtualjar:" + jar.getName() + ".jar");
        String urlStr = "neodymiumvirtualjar:" + jar.getName() + ".jar!/";
        try {
            URL url = new URL(urlStr);
            Launch.classLoader.addURL(url);
            Launch.classLoader.getSources().remove(url);
            jars.put(jar.getName(), jar);
        }
        catch (MalformedURLException e) {
            Constants.LOGGER.fatal("Failed to add virtual jar to class path");
            e.printStackTrace();
        }
    }

    static {
        jars = new HashMap<String, IVirtualJar>();
    }

    public static class StreamHandlerImpl
    implements Handler.IURLStreamHandlerImpl {
        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return new VirtualJarConnection(url);
        }

        public static class VirtualJarConnection
        extends URLConnection {
            IVirtualJar jar;
            private String filePath;

            public VirtualJarConnection(URL url) throws IOException {
                super(url);
                String path = url.getPath();
                String nameSuffix = ".jar!";
                int nameEnd = path.indexOf(nameSuffix);
                String name = path.substring(0, nameEnd);
                this.jar = (IVirtualJar)jars.get(name);
                if (this.jar == null) {
                    throw new IOException();
                }
                this.filePath = path.substring(nameEnd + nameSuffix.length());
                if (!this.jar.hasFile(this.filePath)) {
                    throw new IOException();
                }
            }

            @Override
            public void connect() throws IOException {
            }

            @Override
            public Object getContent() throws IOException {
                return super.getContent();
            }

            @Override
            public String getHeaderField(String name) {
                return super.getHeaderField(name);
            }

            @Override
            public InputStream getInputStream() {
                return this.jar.getInputStream(this.filePath);
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return super.getOutputStream();
            }
        }
    }
}

