/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import makamys.neodymium.renderer.NeoChunk;
import net.minecraft.entity.Entity;

public class NeoRegion {
    private NeoChunk[][] data = new NeoChunk[32][32];
    int regionX;
    int regionZ;
    public int meshes = 0;
    private int emptyTicks = 0;

    public NeoRegion(int regionX, int regionZ) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.data[i][j] = new NeoChunk(regionX * 32 + i, regionZ * 32 + j, this);
            }
        }
    }

    public static NeoRegion load(int regionX, int regionZ) {
        return new NeoRegion(regionX, regionZ);
    }

    public NeoChunk getChunkAbsolute(int chunkXAbs, int chunkZAbs) {
        return this.getChunk(chunkXAbs - this.regionX * 32, chunkZAbs - this.regionZ * 32);
    }

    public NeoChunk getChunk(int x, int z) {
        if (x >= 0 && x < 32 && z >= 0 && z < 32) {
            return this.data[x][z];
        }
        return null;
    }

    public void tick() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                NeoChunk chunk = this.data[i][j];
                if (chunk == null) continue;
                chunk.tick();
            }
        }
        this.emptyTicks = this.meshes == 0 ? ++this.emptyTicks : 0;
    }

    public void destroy() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                NeoChunk chunk = this.data[i][j];
                if (chunk == null) continue;
                chunk.destroy();
            }
        }
    }

    public double distanceTaxicab(Entity entity) {
        double centerX = (this.regionX * 32 + 16) * 16;
        double centerZ = (this.regionZ * 32 + 16) * 16;
        return Math.max(Math.abs(centerX - entity.field_70165_t), Math.abs(centerZ - entity.field_70161_v));
    }

    public String toString() {
        return "LODRegion(" + this.regionX + ", " + this.regionZ + ")";
    }

    public boolean shouldDelete() {
        return this.emptyTicks > 100;
    }
}

