/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import makamys.neodymium.Compat;
import makamys.neodymium.Constants;
import makamys.neodymium.Neodymium;
import makamys.neodymium.config.Config;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.util.ChatUtil;
import makamys.neodymium.util.GuiHelper;
import org.lwjgl.opengl.GL15;

public class GPUMemoryManager {
    private long bufferSize;
    public int VBO;
    private int nextMesh;
    private List<Mesh> sentMeshes = new ArrayList<Mesh>();
    private long usedVRAM;
    private long lastUsedVRAMUpdate;
    private static final long USED_VRAM_UPDATE_RATE = 1000000000L;
    private static final long MAX_VRAM_FULLNESS_INTERVAL = 30000000000L;
    private static long lastVRAMFullness = -1L;

    public GPUMemoryManager() {
        this.VBO = GL15.glGenBuffers();
        this.bufferSize = (long)Config.VRAMSize * 1024L * 1024L;
        GL15.glBindBuffer((int)34962, (int)this.VBO);
        GL15.glBufferData((int)34962, (long)this.bufferSize, (int)35048);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void runGC(boolean full) {
        GL15.glBindBuffer((int)34962, (int)this.VBO);
        int moved = 0;
        int timesReachedEnd = 0;
        int checksLeft = this.sentMeshes.size();
        int MB256 = 0x10000000;
        int panicRate = (int)((float)Math.max(0x10000000L - (this.bufferSize - this.end()), 0L) / 2.6843546E8f * 64.0f);
        while (!full && moved < 4 + panicRate && checksLeft-- > 0 || full && timesReachedEnd < 2 && !this.sentMeshes.isEmpty()) {
            ++this.nextMesh;
            if (this.nextMesh >= this.sentMeshes.size()) {
                this.nextMesh = 0;
                ++timesReachedEnd;
            }
            Mesh mesh = this.sentMeshes.get(this.nextMesh);
            if (mesh.gpuStatus == Mesh.GPUStatus.SENT) {
                long offset;
                long l = offset = this.nextMesh == 0 ? 0L : this.sentMeshes.get(this.nextMesh - 1).getEnd();
                if (mesh.offset != offset) {
                    GL15.glBufferSubData((int)34962, (long)offset, (ByteBuffer)mesh.buffer);
                    ++moved;
                }
                mesh.iFirst = (int)(offset / (long)mesh.getStride());
                mesh.offset = offset;
                continue;
            }
            if (mesh.gpuStatus != Mesh.GPUStatus.PENDING_DELETE) continue;
            mesh.iFirst = -1;
            mesh.offset = -1L;
            mesh.visible = false;
            mesh.gpuStatus = Mesh.GPUStatus.UNSENT;
            this.sentMeshes.remove(this.nextMesh);
            mesh.destroyBuffer();
            if (this.nextMesh <= 0) continue;
            --this.nextMesh;
        }
        GL15.glBindBuffer((int)34962, (int)0);
    }

    private long end() {
        return this.sentMeshes.isEmpty() ? 0L : this.sentMeshes.get(this.sentMeshes.size() - 1).getEnd();
    }

    public void sendMeshToGPU(Mesh mesh) {
        if (mesh == null || mesh.buffer == null) {
            return;
        }
        if (this.end() + (long)mesh.bufferSize() >= this.bufferSize) {
            this.runGC(true);
        }
        if (this.end() + (long)mesh.bufferSize() >= this.bufferSize) {
            Neodymium.renderer.destroyPending = true;
            long t = System.nanoTime();
            if (lastVRAMFullness != -1L && t - lastVRAMFullness < 30000000000L) {
                ChatUtil.showNeoChatMessage("VRAM keeps getting full! Reverting to vanilla renderer. Try increasing the VRAM buffer size in the config, if possible.", ChatUtil.MessageVerbosity.ERROR, false);
                Compat.onNotEnoughVRAM(Config.VRAMSize);
            } else {
                Constants.LOGGER.debug("Reloading renderer because VRAM is full.");
            }
            lastVRAMFullness = t;
            return;
        }
        int size = mesh.bufferSize();
        int insertIndex = -1;
        long nextBase = -1L;
        if (!this.sentMeshes.isEmpty()) {
            if (this.nextMesh < this.sentMeshes.size() - 1) {
                Mesh next = this.sentMeshes.get(this.nextMesh);
                Mesh nextnext = null;
                for (int i = this.nextMesh + 1; i < this.sentMeshes.size(); ++i) {
                    Mesh m = this.sentMeshes.get(i);
                    if (m.gpuStatus != Mesh.GPUStatus.SENT) continue;
                    nextnext = m;
                    break;
                }
                if (nextnext != null && nextnext.offset - next.getEnd() >= (long)size) {
                    nextBase = next.getEnd();
                    insertIndex = this.nextMesh + 1;
                }
            }
            if (nextBase == -1L) {
                nextBase = this.sentMeshes.get(this.sentMeshes.size() - 1).getEnd();
            }
        }
        if (nextBase == -1L) {
            nextBase = 0L;
        }
        if (mesh.gpuStatus == Mesh.GPUStatus.UNSENT) {
            mesh.prepareBuffer();
            GL15.glBindBuffer((int)34962, (int)this.VBO);
            GL15.glBufferSubData((int)34962, (long)nextBase, (ByteBuffer)mesh.buffer);
            mesh.iFirst = (int)(nextBase / (long)mesh.getStride());
            mesh.iCount = mesh.quadCount * 4;
            mesh.offset = nextBase;
            if (insertIndex == -1) {
                this.sentMeshes.add(mesh);
            } else {
                this.sentMeshes.add(insertIndex, mesh);
                this.nextMesh = insertIndex;
            }
            GL15.glBindBuffer((int)34962, (int)0);
        }
        mesh.gpuStatus = Mesh.GPUStatus.SENT;
    }

    public void deleteMeshFromGPU(Mesh mesh) {
        if (mesh == null || mesh.gpuStatus == Mesh.GPUStatus.UNSENT) {
            return;
        }
        mesh.gpuStatus = Mesh.GPUStatus.PENDING_DELETE;
    }

    public void destroy() {
        GL15.glDeleteBuffers((int)this.VBO);
    }

    public List<String> getDebugText() {
        long t = System.nanoTime();
        if (t - this.lastUsedVRAMUpdate > 1000000000L) {
            this.usedVRAM = 0L;
            for (Mesh mesh : this.sentMeshes) {
                this.usedVRAM += (long)mesh.bufferSize();
            }
            this.lastUsedVRAMUpdate = t;
        }
        return Arrays.asList("VRAM: " + this.usedVRAM / 1024L / 1024L + "MB (" + this.end() / 1024L / 1024L + "MB) / " + this.bufferSize / 1024L / 1024L + "MB");
    }

    public void drawInfo() {
        int scale = 10000;
        int rowLength = 512;
        int yOff = 20;
        int height = (int)(this.bufferSize / (long)scale) / rowLength;
        GuiHelper.drawRectangle(0, yOff, rowLength, height, 0, 50);
        int meshI = 0;
        Iterator<Mesh> iterator = this.sentMeshes.iterator();
        while (iterator.hasNext()) {
            Mesh mesh;
            int o = (int)(mesh.offset / 10000L);
            mesh = iterator.next();
            int o2 = (int)((mesh.offset + (long)mesh.bufferSize()) / 10000L);
            if (o / rowLength == o2 / rowLength) {
                if (mesh.gpuStatus != Mesh.GPUStatus.PENDING_DELETE) {
                    GuiHelper.drawRectangle(o % rowLength, o / rowLength + yOff, mesh.buffer.limit() / scale + 1, 1, meshI == this.nextMesh ? 65280 : 0xFFFFFF);
                }
            } else {
                for (int i = o; i < o2; ++i) {
                    int x = i % rowLength;
                    int y = i / rowLength;
                    if (mesh.gpuStatus == Mesh.GPUStatus.PENDING_DELETE) continue;
                    GuiHelper.drawRectangle(x, y + yOff, 1, 1, 0xFFFFFF);
                }
            }
            ++meshI;
        }
        GuiHelper.drawRectangle(0 % rowLength, 0 + yOff, 4, 4, 65280);
        GuiHelper.drawRectangle((int)(this.bufferSize / (long)scale) % rowLength, (int)(this.bufferSize / (long)scale) / rowLength + yOff, 4, 4, 0xFF0000);
    }

    public float getCoherenceRate() {
        return (float)ChunkMesh.usedRAM / (float)this.end();
    }
}

