/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.config;

import cpw.mods.fml.client.config.IConfigElement;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import makamys.neodymium.Constants;
import makamys.neodymium.config.HumanReadableConfigElement;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.EnumUtils;

public class Config {
    @ConfigBoolean(cat="_general", def=true, com="Set this to false to fully disable the mod.")
    public static boolean enabled;
    @ConfigBoolean(cat="_general", def=false, com="Apply changes made in the config file immediately without having to manually reload the renderer. Off by default because it could potentially cause poor performance on certain platforms.")
    public static boolean hotswap;
    @NeedsReload
    @ConfigBoolean(cat="render", def=false, com="Simplify chunk meshes so they are made of less vertices. Reduces vertex count at the cost of increasing shader complexity. It seems to reduce performance overall.")
    public static boolean simplifyChunkMeshes;
    @ConfigBoolean(cat="render", def=true, com="Don't submit faces for rendering if they are facing away from the camera. Reduces GPU workload at the cost of increasing driver overhead. This will improve the framerate most of the time, but may reduce it if you are not fillrate-limited (such as when playing on a small resolution).")
    public static boolean cullFaces;
    @NeedsReload
    @ConfigBoolean(cat="render", def=false, com="Store texture coordinates as shorts instead of floats. Slightly reduces memory usage and might improve performance by small amount. Might affect visuals slightly, but it's only noticable if the texture atlas is huge.")
    public static boolean shortUV;
    @ConfigInt(cat="render", def=1, min=1, max=0x7FFFFFFF, com="Interval (in frames) between the sorting of transparent meshes. Increasing this will reduce CPU usage, but also increase the likelyhood of graphical artifacts appearing when transparent chunks are loaded.")
    public static int sortFrequency;
    @ConfigBoolean(cat="render", def=true, com="Don't render meshes that are shrouded in fog. OptiFine also does this when fog is turned on, this setting makes Neodymium follow suit.")
    public static boolean fogOcclusion;
    @ConfigBoolean(cat="render", def=false, com="Do fog occlusion even if fog is disabled.")
    public static boolean fogOcclusionWithoutFog;
    @NeedsReload
    @ConfigInt(cat="render", def=512, min=1, max=0x7FFFFFFF, com="VRAM buffer size (MB). 512 seems to be a good value on Normal render distance. Increase this if you encounter warnings about the VRAM getting full. Does not affect RAM usage.")
    public static int VRAMSize;
    @ConfigEnum(cat="render", def="auto", clazz=AutomatableBoolean.class, com="Render fog? Slightly reduces framerate. `auto` means the OpenGL setting will be respected (as set by mods like OptiFine).\nValid values: true, false, auto")
    public static AutomatableBoolean renderFog;
    @ConfigInt(cat="render", def=0x7FFFFFFF, min=0, max=0x7FFFFFFF, com="Chunks further away than this distance (in chunks) will not have unaligned quads such as tall grass rendered.")
    public static int maxUnalignedQuadDistance;
    @ConfigBoolean(cat="misc", def=true, com="Replace splash that says 'OpenGL 1.2!' with 'OpenGL 3.3!'. Just for fun.")
    public static boolean replaceOpenGLSplash;
    @ConfigBoolean(cat="misc", def=false, com="Don't warn about incompatibilities in chat, and activate renderer even in spite of critical ones.")
    public static boolean ignoreIncompatibilities;
    @ConfigBoolean(cat="misc", def=false, com="Don't print non-critical rendering errors.")
    public static boolean silenceErrors;
    @ConfigInt(cat="debug", def=-1, min=-1, max=0x7FFFFFFF)
    public static int maxMeshesPerFrame;
    @ConfigInt(cat="debug", def=62, min=-1, max=0x7FFFFFFF, com="The LWJGL keycode of the key that has to be held down while pressing the debug keybinds. Setting this to 0 will make the keybinds usable without holding anything else down. Setting this to -1 will disable debug keybinds entirely.")
    public static int debugPrefix;
    @ConfigBoolean(cat="debug", def=true, com="Set this to false to stop showing the debug info in the F3 overlay.")
    public static boolean showDebugInfo;
    @ConfigBoolean(cat="debug", def=false)
    public static boolean wireframe;
    @ConfigBoolean(cat="debug", def=false, com="Enable building of vanilla chunk meshes. Makes it possible to switch to the vanilla renderer on the fly, at the cost of reducing chunk update performance.")
    public static boolean enableVanillaChunkMeshes;
    private static Configuration config;
    private static File configFile;
    private static WatchService watcher;

    public static void reloadConfig(ReloadInfo info) {
        try {
            if (configFile.exists() && Files.size(configFile.toPath()) == 0L) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        config = new Configuration(configFile, "0.1.8.4");
        config.load();
        boolean needReload = Config.loadFields(config);
        if (info != null) {
            info.needReload = needReload;
        }
        config.setCategoryComment("debug", "Note: Some debug features are only available in creative mode or dev environments.");
        if (config.hasChanged() || !config.getLoadedConfigVersion().equals(config.getDefinedConfigVersion())) {
            config.save();
        }
        if (hotswap && watcher == null) {
            try {
                Config.registerWatchService();
            }
            catch (IOException e) {
                Constants.LOGGER.warn("Failed to register watch service: " + e + " (" + e.getMessage() + "). Changes to the config file will not be reflected");
            }
        }
    }

    public static void reloadConfig() {
        Config.reloadConfig(null);
    }

    private static boolean loadFields(Configuration config) {
        boolean needReload = false;
        for (Field field : Config.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            NeedsReload needsReload = null;
            ConfigBoolean configBoolean = null;
            ConfigInt configInt = null;
            ConfigEnum configEnum = null;
            for (Annotation an : field.getAnnotations()) {
                if (an instanceof NeedsReload) {
                    needsReload = (NeedsReload)an;
                    continue;
                }
                if (an instanceof ConfigInt) {
                    configInt = (ConfigInt)an;
                    continue;
                }
                if (an instanceof ConfigBoolean) {
                    configBoolean = (ConfigBoolean)an;
                    continue;
                }
                if (!(an instanceof ConfigEnum)) continue;
                configEnum = (ConfigEnum)an;
            }
            if (configBoolean == null && configInt == null && configEnum == null) continue;
            Object currentValue = null;
            Object newValue = null;
            try {
                currentValue = field.get(null);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Failed to get value of field " + field.getName());
                e.printStackTrace();
                continue;
            }
            if (configBoolean != null) {
                newValue = config.getBoolean(field.getName(), configBoolean.cat(), configBoolean.def(), configBoolean.com());
            } else if (configInt != null) {
                newValue = config.getInt(field.getName(), configInt.cat(), configInt.def(), configInt.min(), configInt.max(), configInt.com());
            } else if (configEnum != null) {
                boolean lowerCase = true;
                Class<? extends Enum> configClass = configEnum.clazz();
                Map enumMap = EnumUtils.getEnumMap(configClass);
                String[] valuesStrUpper = (String[])enumMap.keySet().stream().toArray(String[]::new);
                String[] valuesStr = (String[])Arrays.stream(valuesStrUpper).map(s -> lowerCase ? s.toLowerCase() : s).toArray(String[]::new);
                ConfigCategory cat = config.getCategory(configEnum.cat());
                Property oldProp = cat.get(field.getName());
                String oldVal = null;
                if (oldProp != null && oldProp.getType() != Property.Type.STRING) {
                    oldVal = oldProp.getString();
                    cat.remove((Object)field.getName());
                }
                String newValueStr = config.getString(field.getName(), configEnum.cat(), lowerCase ? configEnum.def().toLowerCase() : configEnum.def().toUpperCase(), configEnum.com(), valuesStr);
                if (oldVal != null) {
                    newValueStr = oldVal;
                }
                if (!enumMap.containsKey(newValueStr.toUpperCase())) {
                    newValueStr = configEnum.def().toUpperCase();
                    if (lowerCase) {
                        newValueStr = newValueStr.toLowerCase();
                    }
                }
                newValue = enumMap.get(newValueStr.toUpperCase());
                Property newProp = cat.get(field.getName());
                if (!newProp.getString().equals(newValueStr)) {
                    newProp.set(newValueStr);
                }
            }
            if (needsReload != null && !newValue.equals(currentValue)) {
                needReload = true;
            }
            try {
                field.set(null, newValue);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Failed to set value of field " + field.getName());
                e.printStackTrace();
            }
        }
        return needReload;
    }

    public static boolean reloadIfChanged(ReloadInfo info) {
        WatchKey key;
        boolean reloaded = false;
        if (watcher != null && (key = watcher.poll()) != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (!event.context().toString().equals(configFile.getName())) continue;
                Config.reloadConfig(info);
                reloaded = true;
            }
            key.reset();
        }
        return reloaded;
    }

    private static void registerWatchService() throws IOException {
        watcher = FileSystems.getDefault().newWatchService();
        configFile.toPath().getParent().register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public static List<IConfigElement> getElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        for (Property prop : config.getCategory("render").values()) {
            list.add((IConfigElement)new HumanReadableConfigElement(prop));
        }
        return list;
    }

    public static void flush() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        configFile = new File(Launch.minecraftHome, "config/neodymium.cfg");
    }

    public static enum AutomatableBoolean {
        FALSE,
        TRUE,
        AUTO;

    }

    public static class ReloadInfo {
        public boolean needReload;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigEnum {
        public String cat();

        public String def();

        public String com() default "";

        public Class<? extends Enum> clazz();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigInt {
        public String cat();

        public int min();

        public int max();

        public int def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigBoolean {
        public String cat();

        public boolean def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NeedsReload {
    }
}

