/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium;

import com.falsepattern.triangulator.api.ToggleableTessellator;
import cpw.mods.fml.common.Loader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import makamys.neodymium.Constants;
import makamys.neodymium.config.Config;
import makamys.neodymium.util.virtualjar.IVirtualJar;
import makamys.neodymium.util.virtualjar.VirtualJar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import org.lwjgl.opengl.GLContext;

public class Compat {
    private static boolean isGL33Supported;
    private static boolean wasAdvancedOpenGLEnabled;
    private static int notEnoughVRAMAmountMB;

    public static void init() {
        isGL33Supported = GLContext.getCapabilities().OpenGL33;
        if (Loader.isModLoaded((String)"triangulator")) {
            Compat.disableTriangulator();
        }
    }

    private static void disableTriangulator() {
        ((ToggleableTessellator)Tessellator.field_78398_a).disableTriangulator();
    }

    public static void getCompatibilityWarnings(List<Warning> warns, List<Warning> criticalWarns, boolean statusCommand) {
        if (Minecraft.func_71410_x().field_71474_y.field_74349_h) {
            warns.add(new Warning("Advanced OpenGL is enabled, performance may be poor." + (statusCommand ? " Click here to disable it." : "")).chatAction("neodymium disable_advanced_opengl"));
        }
        try {
            Class<?> shaders = Class.forName("shadersmod.client.Shaders");
            try {
                String shaderPack = (String)shaders.getMethod("getShaderPackName", new Class[0]).invoke(null, new Object[0]);
                if (shaderPack != null) {
                    criticalWarns.add(new Warning("A shader pack is enabled, this is not supported."));
                }
            }
            catch (Exception e) {
                Constants.LOGGER.warn("Failed to get shader pack name");
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!isGL33Supported) {
            criticalWarns.add(new Warning("OpenGL 3.3 is not supported."));
        }
        if (Compat.detectedNotEnoughVRAM()) {
            criticalWarns.add(new Warning("Not enough VRAM"));
        }
    }

    public static boolean hasChanged() {
        boolean changed = false;
        boolean advGL = Minecraft.func_71410_x().field_71474_y.field_74349_h;
        if (advGL != wasAdvancedOpenGLEnabled) {
            changed = true;
        }
        wasAdvancedOpenGLEnabled = advGL;
        return changed;
    }

    public static void onNotEnoughVRAM(int amountMB) {
        notEnoughVRAMAmountMB = amountMB;
    }

    public static void reset() {
        notEnoughVRAMAmountMB = -1;
    }

    private static boolean detectedNotEnoughVRAM() {
        return Config.VRAMSize == notEnoughVRAMAmountMB;
    }

    public static void forceEnableOptiFineDetectionOfFastCraft() {
        if (Compat.class.getResource("/fastcraft/Tweaker.class") != null) {
            Constants.LOGGER.info("FastCraft is present, applying hack to forcingly enable FastCraft's OptiFine compat");
            VirtualJar.add(new OptiFineStubVirtualJar());
        }
    }

    public static boolean disableAdvancedOpenGL() {
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (gameSettings.field_74349_h) {
            gameSettings.field_74349_h = false;
            gameSettings.func_74303_b();
            return true;
        }
        return false;
    }

    static {
        notEnoughVRAMAmountMB = -1;
    }

    public static class Warning {
        public String text;
        public String chatAction;

        public Warning(String text) {
            this.text = text;
        }

        public Warning chatAction(String command) {
            this.chatAction = command;
            return this;
        }
    }

    private static class OptiFineStubVirtualJar
    implements IVirtualJar {
        private OptiFineStubVirtualJar() {
        }

        @Override
        public String getName() {
            return "optifine-stub";
        }

        @Override
        public InputStream getInputStream(String path) {
            if (path.equals("/optifine/OptiFineForgeTweaker.class")) {
                Constants.LOGGER.debug("Returning a dummy /optifine/OptiFineForgeTweaker.class to force FastCraft compat.");
                return new ByteArrayInputStream(new byte[0]);
            }
            return null;
        }
    }
}

