/*
 * Decompiled with CFR 0.152.
 */
package com.integral.forgottenrelics.minetweaker;

import com.integral.forgottenrelics.Main;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.research.ResearchCategories;

@ZenClass(value="mods.forgottenrelics.JusticeHandler")
public class JusticeHandlerInteraction {
    @ZenMethod
    public static void addTrigger(String researchKey, IItemStack stack) {
        MineTweakerAPI.apply((IUndoableAction)new Executor(researchKey, stack));
    }

    @ZenMethod
    public static void obliterateJusticeTriggers(String researchKey) {
        MineTweakerAPI.apply((IUndoableAction)new Executor(researchKey));
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            MineTweakerAPI.logError((String)("Invalid ItemStack: " + iStack));
            return null;
        }
        ItemStack theStack = (ItemStack)internal;
        theStack.field_77994_a = 1;
        return theStack;
    }

    private static class Executor
    implements IUndoableAction {
        String researchKey;
        IItemStack iStack;
        boolean obliteration;
        List<ItemStack> obliteratedStacks;
        ItemStack operableStack;

        public Executor(String researchKey, IItemStack stack) {
            this.researchKey = researchKey;
            this.iStack = stack;
            this.obliteration = false;
        }

        public Executor(String researchKey) {
            this.researchKey = researchKey;
            this.iStack = null;
            this.obliteration = true;
        }

        public void apply() {
            if (this.researchKey == "Apotheosis") {
                MineTweakerAPI.logError((String)"You can't redefine triggers for Apotheosis research. Don't even try.");
                return;
            }
            if (ResearchCategories.getResearch((String)this.researchKey) == null) {
                MineTweakerAPI.logError((String)("The research " + this.researchKey + " is unlikely to exist."));
                return;
            }
            if (this.obliteration) {
                if (Main.forgottenKnowledge.containsKey(this.researchKey)) {
                    this.obliteratedStacks = Main.forgottenKnowledge.get(this.researchKey);
                }
                Main.forgottenKnowledge.remove(this.researchKey);
            } else {
                ItemStack stack = JusticeHandlerInteraction.toStack(this.iStack);
                ArrayList<ItemStack> triggerList = new ArrayList<ItemStack>();
                if (Main.forgottenKnowledge.get(this.researchKey) != null) {
                    triggerList.addAll((Collection)Main.forgottenKnowledge.get(this.researchKey));
                }
                if (stack != null) {
                    triggerList.add(stack);
                    this.operableStack = stack;
                    Main.forgottenKnowledge.put(this.researchKey, triggerList);
                }
            }
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            if (this.obliteration) {
                return "Obliterating Justice triggers of " + this.researchKey + " research";
            }
            return "Adding " + this.iStack + " to Justice triggers of " + this.researchKey;
        }

        public void undo() {
            if (this.researchKey == "Apotheosis") {
                return;
            }
            if (ResearchCategories.getResearch((String)this.researchKey) == null) {
                return;
            }
            if (this.obliteration) {
                if (this.obliteratedStacks != null) {
                    Main.forgottenKnowledge.put(this.researchKey, this.obliteratedStacks);
                }
            } else {
                ArrayList triggerList = new ArrayList();
                if (Main.forgottenKnowledge.get(this.researchKey) != null) {
                    triggerList.addAll(Main.forgottenKnowledge.get(this.researchKey));
                }
                if (triggerList != null) {
                    triggerList.remove(this.operableStack);
                    if (triggerList.size() > 0) {
                        Main.forgottenKnowledge.put(this.researchKey, triggerList);
                    } else {
                        Main.forgottenKnowledge.remove(this.researchKey);
                    }
                }
            }
        }

        public String describeUndo() {
            if (this.obliteration) {
                return "Reversing obliteration of " + this.researchKey + " research";
            }
            return "Removing " + this.iStack + " from Justice triggers of " + this.researchKey;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

