/*
 * Decompiled with CFR 0.152.
 */
package com.integral.forgottenrelics.handlers;

import baubles.api.BaubleType;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.integral.forgottenrelics.Main;
import com.integral.forgottenrelics.handlers.DamageRegistryHandler;
import com.integral.forgottenrelics.handlers.JusticeHandler;
import com.integral.forgottenrelics.handlers.RelicsConfigHandler;
import com.integral.forgottenrelics.packets.ArcLightningMessage;
import com.integral.forgottenrelics.packets.BurstMessage;
import com.integral.forgottenrelics.packets.ICanSwingMySwordMessage;
import com.integral.forgottenrelics.packets.LightningMessage;
import com.integral.forgottenrelics.packets.NotificationMessage;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.WandManager;
import vazkii.botania.common.block.subtile.functional.SubTileHeiseiDream;
import vazkii.botania.common.entity.EntityDoppleganger;

public class SuperpositionHandler {
    public static JusticeHandler justiceHandler = null;

    public static void bringTheJustice(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        try {
            if (!justiceHandler.isAlive()) {
                justiceHandler = new JusticeHandler(player);
                justiceHandler.start();
            }
        }
        catch (NullPointerException ex) {
            justiceHandler = new JusticeHandler(player);
            justiceHandler.start();
        }
    }

    public static void setupResearchTriggers(String researchKey, ItemStack ... stacks) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(Arrays.asList(stacks));
        Main.forgottenKnowledge.put(researchKey, stackList);
    }

    public static void sendNotification(EntityPlayer player, int type) {
        if (!player.field_70170_p.field_72995_K) {
            Main.packetInstance.sendTo((IMessage)new NotificationMessage(type), (EntityPlayerMP)player);
        }
    }

    public static void setResearchUnhidden(ResearchItem research) {
        try {
            Field target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isHidden");
            target.setAccessible(true);
            target.setBoolean(research, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setResearchUnlost(ResearchItem research) {
        try {
            Field target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isLost");
            target.setAccessible(true);
            target.setBoolean(research, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setupOverrides() {
        for (String s : RelicsConfigHandler.forgottenKnowledgeOverrides) {
            String[] itemList;
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            s = s.replaceAll("\\s", "");
            String[] splat = s.split("\\[");
            String researchKey = splat[0];
            String unformattedItemList = splat[1];
            unformattedItemList = unformattedItemList.replaceAll("\\]", "");
            for (String item : itemList = unformattedItemList.split(",")) {
                NullPointerException ex;
                String[] params = item.split(":");
                String modid = params[0];
                String itemname = params[1];
                int meta = Integer.parseInt(params[2]);
                Object uncheckedItem = Item.field_150901_e.func_82594_a(modid + ":" + itemname);
                if (!(uncheckedItem instanceof Item)) {
                    ex = new NullPointerException("Setting up the Justice Handler overrides has failed. You may have specified invalid items or messed up with formatting.");
                    throw ex;
                }
                if (researchKey == "Apotheosis") {
                    ex = new NullPointerException("Apotheosis research can't have it's trigger overrided.");
                    throw ex;
                }
                Item theItem = (Item)uncheckedItem;
                ItemStack theStack = new ItemStack(theItem, 1, meta);
                stackList.add(theStack);
            }
            Main.forgottenKnowledge.put(researchKey, stackList);
            Main.log.info("Set trigger overrides for research " + researchKey + ": " + stackList);
        }
    }

    public static void cryHavoc(World world, EntityPlayer player, int RANGE) {
        block1: {
            EntityLiving entity1;
            IMob mob;
            List mobs = world.func_72872_a(IMob.class, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)RANGE), (double)(player.field_70163_u - (double)RANGE), (double)(player.field_70161_v - (double)RANGE), (double)(player.field_70165_t + (double)RANGE + 1.0), (double)(player.field_70163_u + (double)RANGE + 1.0), (double)(player.field_70161_v + (double)RANGE + 1.0)));
            if (mobs.size() <= 1) break block1;
            Iterator iterator = mobs.iterator();
            while (!(!iterator.hasNext() || (mob = (IMob)iterator.next()) instanceof EntityLiving && SubTileHeiseiDream.brainwashEntity((EntityLiving)(entity1 = (EntityLiving)mob), (List)mobs))) {
            }
        }
    }

    public static void imposeArcLightning(World world, int dimension, double x, double y, double z, double destX, double destY, double destZ, float r, float g, float b, float h) {
        if (!world.field_72995_K) {
            Main.packetInstance.sendToAllAround((IMessage)new ArcLightningMessage(x, y, z, destX, destY, destZ, r, g, b, h), new NetworkRegistry.TargetPoint(dimension, x, y, z, 128.0));
        }
    }

    public static void imposeLightning(World world, int dimension, double x, double y, double z, double destX, double destY, double destZ, int duration, float curve, int speed, int type, float width) {
        if (!world.field_72995_K) {
            Main.packetInstance.sendToAllAround((IMessage)new LightningMessage(x, y, z, destX, destY, destZ, duration, curve, speed, type, width), new NetworkRegistry.TargetPoint(dimension, x, y, z, 128.0));
        }
    }

    public static void imposeBurst(World world, int dimension, double x, double y, double z, float size) {
        if (!world.field_72995_K) {
            Main.packetInstance.sendToAllAround((IMessage)new BurstMessage(x, y, z, size), new NetworkRegistry.TargetPoint(dimension, x, y, z, 128.0));
        }
    }

    public static boolean validatePosition(World world, int x, int y, int z) {
        return !world.func_147437_c(x, y - 1, z) & world.func_147439_a(x, y - 1, z).func_149703_v() & world.func_147437_c(x, y, z) & world.func_147437_c(x, y + 1, z);
    }

    public static boolean isOnCoodown(EntityPlayer player) {
        int cooldown;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        try {
            cooldown = Main.castingCooldowns.get(player);
        }
        catch (NullPointerException ex) {
            Main.castingCooldowns.put(player, 0);
            cooldown = 0;
        }
        return cooldown != 0;
    }

    public static void setCasted(EntityPlayer player, int cooldown, boolean swing) {
        if (!player.field_70170_p.field_72995_K) {
            Main.castingCooldowns.put(player, cooldown);
            if (swing) {
                player.func_71038_i();
                Main.packetInstance.sendTo((IMessage)new ICanSwingMySwordMessage(true), (EntityPlayerMP)player);
            }
        }
    }

    public static void setItemAspectsForMetaRange(ItemStack stack, AspectList list, int metaLimit, int startCount) {
        for (int counter = startCount; counter <= metaLimit; ++counter) {
            stack.func_77964_b(counter);
            ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)list);
        }
    }

    public static boolean isDamageTypeAbsolute(DamageSource source) {
        return source == DamageSource.field_76380_i || source == DamageSource.field_76366_f || source instanceof DamageRegistryHandler.DamageSourceFate || source instanceof DamageRegistryHandler.DamageSourceOblivion || source instanceof DamageRegistryHandler.DamageSourceSoulDrain || source instanceof DamageRegistryHandler.DamageSourceTrueDamage || source instanceof DamageRegistryHandler.DamageSourceTrueDamageUndef;
    }

    public static boolean isEntityBlacklistedFromTelekinesis(EntityLivingBase entity) {
        return entity instanceof EntityThaumcraftBoss || entity instanceof EntityDoppleganger;
    }

    public static String getBaubleTooltip(BaubleType type) {
        String str = "";
        switch (type) {
            case AMULET: {
                str = StatCollector.func_74838_a((String)"item.FRAmulet.lore");
                break;
            }
            case BELT: {
                str = StatCollector.func_74838_a((String)"item.FRBelt.lore");
                break;
            }
            case RING: {
                str = StatCollector.func_74838_a((String)"item.FRRing.lore");
                break;
            }
            default: {
                str = "";
            }
        }
        return str;
    }

    public static MovingObjectPosition getPointedBlock(EntityPlayer player, World world, float range) {
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70161_v;
        Vec3 position = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        Vec3 look = player.func_70676_i(1.0f);
        Vec3 finalvec = position.func_72441_c(look.field_72450_a * (double)range, look.field_72448_b * (double)range, look.field_72449_c * (double)range);
        MovingObjectPosition mop = world.func_72933_a(position, finalvec);
        return mop;
    }

    public static List<EntityPlayer> getBaubleOwnersList(World world, Item baubleItem) {
        LinkedList<EntityPlayer> returnList = new LinkedList<EntityPlayer>();
        if (!world.field_72995_K) {
            ArrayList playersList = new ArrayList(MinecraftServer.func_71276_C().func_71203_ab().field_72404_b);
            for (int counter = playersList.size() - 1; counter >= 0; --counter) {
                if (!SuperpositionHandler.hasBauble((EntityPlayer)playersList.get(counter), baubleItem)) continue;
                returnList.add((EntityPlayer)playersList.get(counter));
            }
        }
        return returnList;
    }

    public static EntityPlayer findPlayerWithBauble(World world, int radius, Item baubleItem, EntityLivingBase entity) {
        LinkedList returnList = new LinkedList();
        if (!world.field_72995_K) {
            List playerList = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - (double)radius), (double)(entity.field_70163_u - (double)radius), (double)(entity.field_70161_v - (double)radius), (double)(entity.field_70165_t + (double)radius), (double)(entity.field_70163_u + (double)radius), (double)(entity.field_70161_v + (double)radius)));
            if (playerList.contains(entity)) {
                playerList.remove(entity);
            }
            for (int counter = playerList.size() - 1; counter >= 0; --counter) {
                if (!SuperpositionHandler.hasBauble((EntityPlayer)playerList.get(counter), baubleItem)) continue;
                returnList.add(playerList.get(counter));
            }
            if (returnList.size() > 0) {
                return (EntityPlayer)returnList.get((int)((double)(returnList.size() - 1) * Math.random()));
            }
            return null;
        }
        return null;
    }

    public static boolean hasBauble(EntityPlayer player, Item theBauble) {
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        ArrayList<Item> baubleList = new ArrayList<Item>();
        if (baubles.func_70301_a(0) != null) {
            baubleList.add(baubles.func_70301_a(0).func_77973_b());
        }
        if (baubles.func_70301_a(1) != null) {
            baubleList.add(baubles.func_70301_a(1).func_77973_b());
        }
        if (baubles.func_70301_a(2) != null) {
            baubleList.add(baubles.func_70301_a(2).func_77973_b());
        }
        if (baubles.func_70301_a(3) != null) {
            baubleList.add(baubles.func_70301_a(3).func_77973_b());
        }
        return baubleList.contains(theBauble);
    }

    public static boolean validTeleport(Entity entity, double x_init, double y_init, double z_init, World world) {
        int x = (int)x_init;
        int y = (int)y_init;
        int z = (int)z_init;
        Block block = world.func_147439_a(x, y - 1, z);
        if (block != Blocks.field_150350_a & block.func_149703_v()) {
            for (int counter = 0; counter <= 32; ++counter) {
                if (!(!world.func_147437_c(x, y + counter - 1, z) & world.func_147439_a(x, y + counter - 1, z).func_149703_v() & world.func_147437_c(x, y + counter, z) & world.func_147437_c(x, y + counter + 1, z))) continue;
                SuperpositionHandler.imposeBurst(entity.field_70170_p, entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, 1.25f);
                entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
                ((EntityLivingBase)entity).func_70634_a((double)x + 0.5, (double)(y + counter), (double)z + 0.5);
                entity.field_70170_p.func_72908_a((double)x, (double)(y + counter), (double)z, "mob.endermen.portal", 1.0f, 1.0f);
                return true;
            }
        } else {
            for (int counter = 0; counter <= 32; ++counter) {
                if (!(!world.func_147437_c(x, y - counter - 1, z) & world.func_147439_a(x, y - counter - 1, z).func_149703_v() & world.func_147437_c(x, y - counter, z) & world.func_147437_c(x, y - counter + 1, z))) continue;
                SuperpositionHandler.imposeBurst(entity.field_70170_p, entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, 1.25f);
                entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
                ((EntityLivingBase)entity).func_70634_a((double)x + 0.5, (double)(y - counter), (double)z + 0.5);
                entity.field_70170_p.func_72908_a((double)x, (double)(y - counter), (double)z, "mob.endermen.portal", 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public static boolean validTeleportRandomly(Entity entity, World world, int radius) {
        int d = radius * 2;
        double x = entity.field_70165_t + (Math.random() - 0.5) * (double)d;
        double y = entity.field_70163_u + (Math.random() - 0.5) * (double)d;
        double z = entity.field_70161_v + (Math.random() - 0.5) * (double)d;
        return SuperpositionHandler.validTeleport(entity, x, y, z, world);
    }

    public static ItemStack getRandomValidWand(List<ItemStack> list, Aspect aspect) {
        LinkedList<ItemStack> validWand = new LinkedList<ItemStack>();
        ItemStack randomWand = null;
        if (list.size() > 0) {
            for (int counter = 0; counter < list.size(); ++counter) {
                ItemStack sheduledWand = list.get(counter);
                if (((ItemWandCasting)sheduledWand.func_77973_b()).getVis(sheduledWand, aspect) >= ((ItemWandCasting)sheduledWand.func_77973_b()).getMaxVis(sheduledWand)) continue;
                validWand.add(sheduledWand);
            }
            if (validWand.size() > 0) {
                randomWand = (ItemStack)validWand.get((int)(Math.random() * (double)(validWand.size() - 1 + 1)));
            }
            return randomWand;
        }
        return randomWand;
    }

    public static List wandSearch(EntityPlayer player) {
        LinkedList<ItemStack> itemStackList = new LinkedList<ItemStack>();
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || !(player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof ItemWandCasting)) continue;
            itemStackList.add(player.field_71071_by.field_70462_a[slot]);
        }
        return itemStackList;
    }

    public static List itemSearch(EntityPlayer player, Item researchItem) {
        LinkedList<ItemStack> itemStackList = new LinkedList<ItemStack>();
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != researchItem) continue;
            itemStackList.add(player.field_71071_by.field_70462_a[slot]);
        }
        return itemStackList;
    }

    public static boolean sidedVisConsumption(EntityPlayer player, World world, AspectList list) {
        if (!world.field_72995_K) {
            return WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)list);
        }
        return true;
    }

    public static void insanelyDisastrousConsequences(EntityPlayer player) {
        while (player.field_71071_by.func_146028_b(Main.itemFateTome)) {
            player.field_71071_by.func_146026_a(Main.itemFateTome);
        }
        List entityList = player.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - 64.0), (double)(player.field_70163_u - 64.0), (double)(player.field_70161_v - 64.0), (double)(player.field_70165_t + 64.0), (double)(player.field_70163_u + 64.0), (double)(player.field_70161_v + 64.0)));
        if (entityList != null & entityList.size() > 0) {
            for (int counter = entityList.size(); counter > 0; --counter) {
                ((EntityLivingBase)entityList.get(counter - 1)).func_70097_a((DamageSource)new DamageRegistryHandler.DamageSourceFate(), 40000.0f);
                player.field_70170_p.func_72885_a((Entity)player, ((EntityLivingBase)entityList.get((int)(counter - 1))).field_70165_t, ((EntityLivingBase)entityList.get((int)(counter - 1))).field_70163_u, ((EntityLivingBase)entityList.get((int)(counter - 1))).field_70161_v, 16.0f, true, true);
            }
        }
        player.field_70170_p.func_72885_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0f, true, true);
    }

    public static ItemStack findFirst(EntityPlayer player, Item searchItem) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != searchItem) continue;
            return player.field_71071_by.field_70462_a[slot];
        }
        return null;
    }

    public static void convertStuff(EntityPlayer player, Item consumableItem, Item leftoverItem) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != consumableItem) continue;
            player.field_71071_by.field_70462_a[slot] = new ItemStack(leftoverItem);
            return;
        }
    }

    public static int[] addInt(int[] series, int newInt) {
        int[] newSeries = new int[series.length + 1];
        for (int i = 0; i < series.length; ++i) {
            newSeries[i] = series[i];
        }
        newSeries[newSeries.length - 1] = newInt;
        return newSeries;
    }
}

