/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.tooltip;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.client.tooltip.LoreHolder;
import com.gtnewhorizon.gtnhlib.reflect.Fields;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LoreHolderDiscoverer {
    static final Map<Fields.ClassFields.Field<String>, String> LORE_HOLDERS = new HashMap<Fields.ClassFields.Field<String>, String>();

    public static void harvestData(ASMDataTable table) {
        for (ASMDataTable.ASMData asmData : table.getAll(LoreHolder.class.getName())) {
            Fields.ClassFields.Field<String> field;
            Class<?> clazz;
            String className = asmData.getClassName();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                GTNHLib.LOG.error("Class " + className + " could not be found!", (Throwable)e);
                continue;
            }
            String fieldName = asmData.getObjectName();
            try {
                field = Fields.ofClass(clazz).getField(Fields.LookupType.DECLARED, fieldName, String.class);
            }
            catch (ClassCastException e) {
                GTNHLib.LOG.error("Field " + fieldName + " of class " + className + " is not of type java.lang.String!", (Throwable)e);
                continue;
            }
            if (field == null) {
                GTNHLib.LOG.error("Field {} of class {} could not be found!", new Object[]{fieldName, className});
                continue;
            }
            if (!field.isStatic) {
                GTNHLib.LOG.error("Field {} of class {} is not static!", new Object[]{fieldName, className});
                continue;
            }
            String key = (String)asmData.getAnnotationInfo().get("value");
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            LORE_HOLDERS.put(field, key);
        }
    }
}

