/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.util;

import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.BetterHud;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.ColoredText;

public class RenderUtil {
    public static int colorRGB(int r, int g, int b) {
        return RenderUtil.colorARGB(255, r, g, b);
    }

    public static int colorARGB(int a, int r, int g, int b) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static void renderQuad(Tessellator t, int x, int y, int width, int height, float red, float green, float blue, float alpha) {
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glBindTexture((int)3553, (int)0);
        t.func_78382_b();
        t.func_78377_a((double)x, (double)y, 0.0);
        t.func_78377_a((double)x, (double)(y + height), 0.0);
        t.func_78377_a((double)(x + width), (double)(y + height), 0.0);
        t.func_78377_a((double)(x + width), (double)y, 0.0);
        t.func_78381_a();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        int j1;
        if (left < right) {
            j1 = left;
            left = right;
            right = j1;
        }
        if (top < bottom) {
            j1 = top;
            top = bottom;
            bottom = j1;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)left, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)top, 0.0);
        tessellator.func_78377_a((double)left, (double)top, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static void drawProgressBar(int x, int y, int right, int bottom, float value) {
        int width = right - x - 1;
        int color = RenderUtil.colorRGB(Math.round((1.0f - value) * 255.0f), Math.round(value * 255.0f), 0);
        RenderUtil.drawRect(x, y, right, bottom, RenderUtil.colorRGB(0, 0, 0));
        RenderUtil.drawRect(x, y, x + Math.round(value * (float)width), bottom - 1, color);
    }

    public static void drawProgressBarV(int x, int y, int right, int bottom, float value) {
        int height = bottom - y - 1;
        int color = RenderUtil.colorRGB(Math.round((1.0f - value) * 255.0f), Math.round(value * 255.0f), 0);
        RenderUtil.drawRect(x, y, right, bottom, RenderUtil.colorRGB(0, 0, 0));
        RenderUtil.drawRect(x, bottom - 1 - Math.round(value * (float)height), right - 1, bottom - 1, color);
    }

    public static void renderQuadWithUV(Tessellator t, int x, int y, float u, float v, float u2, float v2, int width, int height, float red, float green, float blue, float alpha) {
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        t.func_78382_b();
        t.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
        t.func_78374_a((double)x, (double)(y + height), 0.0, (double)u, (double)v2);
        t.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)u2, (double)v2);
        t.func_78374_a((double)(x + width), (double)y, 0.0, (double)u2, (double)v);
        t.func_78381_a();
    }

    public static void billBoard(Entity entity, EntityPlayer player, float partialTicks) {
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double dx = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks - (player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks);
        double dy = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks - (player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks);
        double dz = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks - (player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks);
        GL11.glDisable((int)2896);
        double scale = Math.max(1.0, Math.sqrt(dx * dx + dy * dy + dz * dz) / 5.0);
        GL11.glTranslated((double)dx, (double)(dy + 0.5 + (double)entity.field_70131_O), (double)dz);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        GL11.glEnable((int)3042);
    }

    public static void renderItem(RenderItem ri, FontRenderer fr, TextureManager tm, ItemStack item, int x, int y) {
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        BetterHud.renderItem.func_82406_b(fr, tm, item, x, y);
        RenderHelper.func_74518_a();
    }

    public static Bounds renderStrings(FontRenderer fr, ArrayList<String> text, int x, int y, int color, ElementSettingPosition.Position pos) {
        return RenderUtil.renderStrings(fr, text.toArray(new String[text.size()]), x, y, color, pos);
    }

    public static Bounds renderStrings(FontRenderer fr, String[] text, int x, int y, int color, ElementSettingPosition.Position pos) {
        boolean right = pos == ElementSettingPosition.Position.TOP_RIGHT || pos == ElementSettingPosition.Position.MIDDLE_RIGHT || pos == ElementSettingPosition.Position.BOTTOM_RIGHT;
        boolean bottom = pos == ElementSettingPosition.Position.BOTTOM_LEFT || pos == ElementSettingPosition.Position.BOTTOM_CENTER || pos == ElementSettingPosition.Position.BOTTOM_RIGHT;
        int maxWidth = 0;
        for (int i = 0; i < text.length; ++i) {
            int width = fr.func_78256_a(text[i]);
            fr.func_78261_a(text[i], right ? x - width : x, bottom ? y - ((i + 1) * (fr.field_78288_b + 2) - 2) : y + i * (fr.field_78288_b + 2), color);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int height = text.length * (fr.field_78288_b + 2) - 2;
        int bx = right ? x - maxWidth : x;
        int by = bottom ? y - height : y;
        return new Bounds(bx, by, maxWidth, height);
    }

    public static Bounds renderStrings(FontRenderer fr, ArrayList<ColoredText> text, int x, int y, ElementSettingPosition.Position pos) {
        return RenderUtil.renderStrings(fr, text.toArray(new ColoredText[text.size()]), x, y, pos);
    }

    public static Bounds renderStrings(FontRenderer fr, ColoredText[] text, int x, int y, ElementSettingPosition.Position pos) {
        boolean right = pos == ElementSettingPosition.Position.TOP_RIGHT || pos == ElementSettingPosition.Position.MIDDLE_RIGHT || pos == ElementSettingPosition.Position.BOTTOM_RIGHT;
        boolean bottom = pos == ElementSettingPosition.Position.BOTTOM_LEFT || pos == ElementSettingPosition.Position.BOTTOM_CENTER || pos == ElementSettingPosition.Position.BOTTOM_RIGHT;
        int maxWidth = 0;
        for (int i = 0; i < text.length; ++i) {
            int width = fr.func_78256_a(text[i].text);
            fr.func_78261_a(text[i].text, right ? x - width : x, bottom ? y - ((i + 1) * (fr.field_78288_b + 2) - 2) : y + i * (fr.field_78288_b + 2), text[i].color);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int height = text.length * (fr.field_78288_b + 2) - 2;
        int bx = right ? x - maxWidth : x;
        int by = bottom ? y - height : y;
        return new Bounds(bx, by, maxWidth, height);
    }

    public static void zIncrease() {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.001f);
    }
}

