/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.settings;

import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import tk.nukeduck.hud.BetterHud;
import tk.nukeduck.hud.element.settings.ElementSetting;
import tk.nukeduck.hud.gui.GuiElementSettings;
import tk.nukeduck.hud.gui.GuiToggleButton;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.RenderUtil;

public class ElementSettingPosition
extends ElementSetting {
    public GuiToggleButton topLeft;
    public GuiToggleButton topCenter;
    public GuiToggleButton topRight;
    public GuiToggleButton middleLeft;
    public GuiToggleButton middleCenter;
    public GuiToggleButton middleRight;
    public GuiToggleButton bottomLeft;
    public GuiToggleButton bottomCenter;
    public GuiToggleButton bottomRight;
    public int possibleLocations = Position.TOP_LEFT.getFlag();
    public Position value = Position.TOP_LEFT;
    protected GuiToggleButton[] radios;

    public ElementSettingPosition(String name, int possibleLocations) {
        super(name);
        this.possibleLocations = possibleLocations;
    }

    @Override
    public int getGuiHeight() {
        return 64;
    }

    public boolean isValid(Position pos) {
        return (pos.getFlag() & this.possibleLocations) == pos.getFlag();
    }

    public void set(Position pos) {
        if (this.isValid(pos)) {
            this.value = pos;
        }
    }

    @Override
    public Gui[] getGuiParts(int width, int y) {
        this.topLeft = new GuiToggleButton(Position.TOP_LEFT.ordinal(), width / 2 - 100, y, 20, 20, "");
        this.topCenter = new GuiToggleButton(Position.TOP_CENTER.ordinal(), width / 2 - 78, y, 20, 20, "");
        this.topRight = new GuiToggleButton(Position.TOP_RIGHT.ordinal(), width / 2 - 56, y, 20, 20, "");
        this.middleLeft = new GuiToggleButton(Position.MIDDLE_LEFT.ordinal(), width / 2 - 100, y + 22, 20, 20, "");
        this.middleCenter = new GuiToggleButton(Position.MIDDLE_CENTER.ordinal(), width / 2 - 78, y + 22, 20, 20, "");
        this.middleRight = new GuiToggleButton(Position.MIDDLE_RIGHT.ordinal(), width / 2 - 56, y + 22, 20, 20, "");
        this.bottomLeft = new GuiToggleButton(Position.BOTTOM_LEFT.ordinal(), width / 2 - 100, y + 44, 20, 20, "");
        this.bottomCenter = new GuiToggleButton(Position.BOTTOM_CENTER.ordinal(), width / 2 - 78, y + 44, 20, 20, "");
        this.bottomRight = new GuiToggleButton(Position.BOTTOM_RIGHT.ordinal(), width / 2 - 56, y + 44, 20, 20, "");
        for (GuiToggleButton but : this.radios = new GuiToggleButton[]{this.topLeft, this.topCenter, this.topRight, this.middleLeft, this.middleCenter, this.middleRight, this.bottomLeft, this.bottomCenter, this.bottomRight}) {
            but.field_146124_l = (Position.values()[but.field_146127_k].getFlag() & this.possibleLocations) == Position.values()[but.field_146127_k].getFlag();
            but.pressed = but.field_146127_k == this.value.ordinal();
        }
        return this.radios;
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
        for (GuiToggleButton g : this.radios) {
            g.setPressed(g == button);
        }
        this.value = Position.values()[button.field_146127_k];
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
    }

    @Override
    public void render(GuiScreen gui, int yScroll) {
        gui.func_73731_b(BetterHud.mc.field_71466_p, FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("setting." + this.value.name, new String[0])), this.middleRight.field_146128_h + this.middleRight.field_146120_f + 5, this.middleRight.field_146129_i + (this.middleRight.field_146121_g - BetterHud.mc.field_71466_p.field_78288_b) / 2, RenderUtil.colorRGB(255, 255, 255));
    }

    @Override
    public String toString() {
        return this.value.name;
    }

    @Override
    public void fromString(String val) {
        Position p = Position.fromName(val);
        if (p != null) {
            this.value = p;
        }
    }

    @Override
    public void otherAction(Collection<ElementSetting> settings) {
        boolean enabled = this.getEnabled();
        for (GuiToggleButton but : this.radios) {
            but.field_146124_l = enabled && (Position.values()[but.field_146127_k].getFlag() & this.possibleLocations) == Position.values()[but.field_146127_k].getFlag();
            but.pressed = Position.values()[but.field_146127_k] == this.value;
        }
    }

    public static enum Position {
        TOP_LEFT("topLeft"),
        TOP_CENTER("topCenter"),
        TOP_RIGHT("topRight"),
        MIDDLE_LEFT("middleLeft"),
        MIDDLE_CENTER("middleCenter"),
        MIDDLE_RIGHT("middleRight"),
        BOTTOM_LEFT("bottomLeft"),
        BOTTOM_CENTER("bottomCenter"),
        BOTTOM_RIGHT("bottomRight");

        public static final int CORNERS;
        public String name;

        private Position(String name) {
            this.name = name;
        }

        public int getFlag() {
            return 1 << this.ordinal();
        }

        public static Position fromName(String name) {
            for (Position p : Position.values()) {
                if (!p.name.equals(name)) continue;
                return p;
            }
            return null;
        }

        public static int combine(Position ... pos) {
            int x = 0;
            for (Position p : pos) {
                x |= p.getFlag();
            }
            return x;
        }

        static {
            CORNERS = Position.combine(TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_RIGHT);
        }
    }
}

