/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.entityinfo;

import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.element.entityinfo.ExtraGuiElementEntityInfo;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.RenderUtil;

public class ExtraGuiElementMobInfo
extends ExtraGuiElementEntityInfo {
    ElementSettingBoolean players = new ElementSettingBoolean("players");
    ElementSettingBoolean mobs;
    private static ResourceLocation icons = new ResourceLocation("textures/gui/icons.png");

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.players.value = true;
        this.mobs.value = true;
        this.distance.value = 100.0;
    }

    @Override
    public String getName() {
        return "mobInfo";
    }

    public ExtraGuiElementMobInfo() {
        this.settings.add(this.players);
        this.mobs = new ElementSettingBoolean("mobs");
        this.settings.add(this.mobs);
        this.distance = new ElementSettingSlider("distance", 5.0, 200.0){

            @Override
            public String getSliderText() {
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), FormatUtil.translatePre("strings.distanceShort", String.valueOf((int)this.value)));
            }
        };
        this.settings.add(this.distance);
    }

    @Override
    public void renderInfo(EntityLivingBase entity, Minecraft mc, float partialTicks) {
        if (this.enabled) {
            int i;
            EntityClientPlayerMP player = mc.field_71439_g;
            boolean isPlayer = entity instanceof EntityPlayer;
            if (isPlayer && !this.players.value || !isPlayer && !this.mobs.value) {
                return;
            }
            GL11.glPushMatrix();
            Tessellator t = Tessellator.field_78398_a;
            RenderUtil.billBoard((Entity)entity, (EntityPlayer)player, partialTicks);
            if (entity.func_70694_bm() == null || !entity.func_70694_bm().func_77948_v()) {
                GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            String text = entity.func_145748_c_().func_150254_d() + " (" + (int)entity.func_110143_aJ() + "/" + (int)entity.func_110138_aP() + ")";
            float perLine = 10.0f;
            int width = Math.max(8 * Math.min(10, (int)entity.func_110138_aP() / 2) + 1 + (entity instanceof EntityPlayer ? 85 : 0), mc.field_71466_p.func_78256_a(text)) + 10;
            int height = mc.field_71466_p.field_78288_b + 12 + 9 * (int)Math.ceil(Math.ceil(entity.func_110138_aP() / 2.0f) / (double)perLine);
            float scale = 1.0f / (float)width;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            RenderUtil.renderQuad(t, 0, 0, width, height, 0.0f, 0.0f, 0.0f, 0.5f);
            RenderUtil.zIncrease();
            mc.field_71456_v.func_73731_b(mc.field_71466_p, text, 5, 5, RenderUtil.colorRGB(255, 255, 255));
            if (isPlayer) {
                String text2 = "(" + entity.func_70658_aO() + "/20)";
                mc.field_71456_v.func_73731_b(mc.field_71466_p, text2, width - 5 - mc.field_71466_p.func_78256_a(text2), 5, RenderUtil.colorRGB(255, 255, 255));
            }
            mc.field_71446_o.func_110577_a(icons);
            for (i = 0; i < Math.round(entity.func_110138_aP() / 2.0f); ++i) {
                RenderUtil.renderQuadWithUV(t, 5 + i % 10 * 8, mc.field_71466_p.field_78288_b + 7 + i / 10 * 9, 0.0625f, 0.0f, 0.09765625f, 0.03515625f, 9, 9, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            for (i = 0; i < (int)entity.func_110143_aJ() / 2; ++i) {
                RenderUtil.renderQuadWithUV(t, 5 + i % 10 * 8, mc.field_71466_p.field_78288_b + 7 + i / 10 * 9, 0.203125f, 0.0f, 0.23828125f, 0.03515625f, 9, 9, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if ((int)entity.func_110143_aJ() % 2 == 1) {
                RenderUtil.renderQuadWithUV(t, 5 + i % 10 * 8, mc.field_71466_p.field_78288_b + 7 + i / 10 * 9, 0.23828125f, 0.0f, 0.2734375f, 0.03515625f, 9, 9, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (isPlayer) {
                EntityPlayer playerObj;
                int armor = entity.func_70658_aO();
                for (i = 0; i < 10; ++i) {
                    RenderUtil.renderQuadWithUV(t, 8 * Math.min(10, (int)entity.func_110138_aP() / 2) + 10 + i * 8, mc.field_71466_p.field_78288_b + 7 + i / 10 * 9, 0.0625f, 0.03515625f, 0.09765625f, 0.0703125f, 9, 9, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                for (i = 0; i < armor / 2; ++i) {
                    RenderUtil.renderQuadWithUV(t, 8 * Math.min(10, (int)entity.func_110138_aP() / 2) + 10 + i * 8, mc.field_71466_p.field_78288_b + 7 + i / 10 * 9, 0.1328125f, 0.03515625f, 0.16796875f, 0.0703125f, 9, 9, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (armor % 2 == 1) {
                    RenderUtil.renderQuadWithUV(t, 8 * Math.min(10, (int)entity.func_110138_aP() / 2) + 10 + i * 8, mc.field_71466_p.field_78288_b + 7 + i / 10 * 9, 0.09765625f, 0.03515625f, 0.1328125f, 0.0703125f, 9, 9, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if ((playerObj = (EntityPlayer)entity).func_70694_bm() != null) {
                    mc.field_71456_v.func_73731_b(mc.field_71466_p, "Holding:", 5, height + 5, RenderUtil.colorRGB(255, 255, 255));
                    ItemStack is = playerObj.func_70694_bm();
                    GL11.glPushAttrib((int)1048575);
                    GL11.glPopAttrib();
                    if (is.func_77986_q() != null && is.func_77986_q().func_74745_c() != 0) {
                        for (int b = 0; b < is.func_77986_q().func_74745_c(); ++b) {
                            NBTTagCompound thisEnchant = is.func_77986_q().func_150305_b(b);
                            short short1 = thisEnchant.func_74765_d("id");
                            short short2 = thisEnchant.func_74765_d("lvl");
                            String display = ChatFormatting.LIGHT_PURPLE + Enchantment.field_77331_b[short1].func_77316_c((int)short2);
                            mc.field_71456_v.func_73731_b(mc.field_71466_p, display, 5 + 100 * (b / 4), height + 10 + mc.field_71466_p.field_78288_b + (mc.field_71466_p.field_78288_b + 2) * (b % 4), RenderUtil.colorRGB(255, 255, 255));
                        }
                    }
                    mc.field_71456_v.func_73731_b(mc.field_71466_p, (is.func_82837_s() ? ChatFormatting.ITALIC : "") + "" + (is.func_77948_v() ? ChatFormatting.AQUA : "") + is.func_82833_r(), 26 + mc.field_71466_p.func_78256_a("Holding:"), height + 5, RenderUtil.colorRGB(255, 255, 255));
                }
            }
            GL11.glPopMatrix();
        }
    }
}

