/*
 * Decompiled with CFR 0.152.
 */
package net.moecraft.nechar;

import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.Language;
import net.minecraft.util.EnumChatFormatting;
import net.moecraft.nechar.NecharDisplayFilter;
import net.moecraft.nechar.NecharSearchParserProvider;
import net.moecraft.nechar.NecharTooltipFilter;
import net.moecraft.nechar.NotEnoughCharacters;
import net.vfyjxf.nechar.NechConfig;

public class NEINecharConfig
implements IConfigureNEI {
    public void loadConfig() {
        List<Language> matchingLanguages = this.getMatchingLanguages();
        API.addSearchProvider((SearchTokenParser.ISearchParserProvider)new NecharSearchParserProvider('\u0000', "default", EnumChatFormatting.RESET, NecharDisplayFilter::new, matchingLanguages){

            @Override
            public SearchTokenParser.SearchMode getSearchMode() {
                return SearchTokenParser.SearchMode.ALWAYS;
            }
        });
        API.addSearchProvider((SearchTokenParser.ISearchParserProvider)new NecharSearchParserProvider('#', "tooltip", EnumChatFormatting.YELLOW, NecharTooltipFilter::new, matchingLanguages));
        NotEnoughCharacters.logger.info("search provider added!");
    }

    protected List<Language> getMatchingLanguages() {
        return SearchTokenParser.ISearchParserProvider.getAllLanguages().stream().filter(lang -> Arrays.stream(NechConfig.neiAllowedLanguages).anyMatch(lang.func_135034_a()::equals)).collect(Collectors.toList());
    }

    public String getName() {
        return "nechar";
    }

    public String getVersion() {
        return NotEnoughCharacters.VERSION;
    }
}

