/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.tips;

import club.someoneice.tips.GuiLoadingWorldWithTips;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="tips", name="PineappleTips", useMetadata=true)
public class TipsMain {
    public static final String MODID = "tips";
    public static final String NAME = "PineappleTips";
    public static final String VERSION = "@VERSION@";
    public static final Logger LOG = LogManager.getLogger((String)"PineappleTips");
    @Mod.Instance(value="tips")
    public static TipsMain INSTANCE;
    public boolean obfuscated;
    public static final List<String> TIPS;
    static int tickOfClientInRender;
    static String tipHolder;
    static Random random;
    List<Class<? extends GuiScreen>> screens = Lists.newArrayList((Object[])new Class[]{GuiGameOver.class, GuiConnecting.class, GuiDisconnected.class, GuiIngameMenu.class});

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        INSTANCE = this;
        TipsMain.readConfig();
        ArrayList tips = Lists.newArrayList(TIPS);
        TIPS.clear();
        tips.stream().map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).forEach(TIPS::add);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.obfuscated = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") == false;
    }

    private static void readConfig() throws IOException {
        File configFile = new File(Loader.instance().getConfigDir(), "PineappleTips.json");
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        if (configFile.isFile()) {
            TIPS.addAll((Collection)gson.fromJson(new String(Files.readAllBytes(configFile.toPath())), new TypeToken<List<String>>(){}.getType()));
            return;
        }
        configFile.createNewFile();
        TIPS.add("\u51e4\u68a8\u7ea7\u6d4b\u8bd5\uff01");
        TIPS.add("\u54a9\u72fc\u7684\u5c3e\u5df4\u6709\u591a\u957f\uff1f");
        TIPS.add("\u4f55\u4e0d\u8bd5\u8bd5 ManaMetalMod \uff01");
        TIPS.add("\u4f60\u662f\u5426\u505a\u8fc7\u4e00\u4e2a PasterDream \uff1f");
        Files.write(configFile.toPath(), gson.toJson(TIPS).getBytes(), new OpenOption[0]);
    }

    public static void getAndDrawTip(FontRenderer font, int x, int y) {
        if (tipHolder.isEmpty() || ++tickOfClientInRender >= 1000) {
            tickOfClientInRender = 0;
            tipHolder = TIPS.get(random.nextInt(TIPS.size()));
        }
        font.func_78276_b("\u00a7l\u00a7eTips:", x, y, Color.WHITE.getRGB());
        y += 10;
        if (tipHolder.length() < 20) {
            font.func_78276_b(tipHolder, x, y, Color.WHITE.getRGB());
        } else {
            String tip0 = tipHolder.substring(0, 20);
            String tip1 = tipHolder.substring(20);
            font.func_78276_b(tip0, x, y, Color.WHITE.getRGB());
            font.func_78276_b(tip1, x, y + 10, Color.WHITE.getRGB());
        }
    }

    @SubscribeEvent
    public void onScreenLoading(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!this.screens.contains(event.gui.getClass())) {
            return;
        }
        int x = 10;
        int y = event.gui.field_146295_m - event.gui.field_146295_m / 10 - 10;
        FontRenderer font = event.gui.field_146297_k.field_71466_p;
        TipsMain.getAndDrawTip(font, x, y);
    }

    @SubscribeEvent
    public void onScreenOpen(GuiOpenEvent event) {
        if (!(event.gui instanceof GuiDownloadTerrain)) {
            return;
        }
        try {
            NetHandlerPlayClient npc = (NetHandlerPlayClient)ReflectionHelper.getPrivateValue(GuiDownloadTerrain.class, (Object)((GuiDownloadTerrain)event.gui), (String[])new String[]{"field_146594_a"});
            event.gui = new GuiLoadingWorldWithTips(npc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        TIPS = Lists.newArrayList();
        tickOfClientInRender = 0;
        tipHolder = "";
        random = new Random();
    }
}

