/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.ClientHelper;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class AbstractPartMonitor
extends AbstractPartDisplay
implements IPartStorageMonitor,
IStackWatcherHost {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private IAEItemStack configuredItem;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;
    @SideOnly(value=Side.CLIENT)
    private boolean updateList;
    @SideOnly(value=Side.CLIENT)
    private Integer dspList;

    public AbstractPartMonitor(ItemStack is) {
        super(is);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isLocked = data.func_74767_n("isLocked");
        NBTTagCompound myItem = data.func_74775_l("configuredItem");
        this.configuredItem = AEItemStack.loadItemStackFromNBT(myItem);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isLocked", this.isLocked);
        NBTTagCompound myItem = new NBTTagCompound();
        if (this.configuredItem != null) {
            this.configuredItem.writeToNBT(myItem);
        }
        data.func_74782_a("configuredItem", (NBTBase)myItem);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            this.configuredItem.writeToPacket(data);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw = this.isLocked != isLocked;
        this.isLocked = isLocked;
        boolean val = data.readBoolean();
        this.configuredItem = val ? AEItemStack.loadItemStackFromPacket(data) : null;
        this.updateList = true;
        return needRedraw;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        TileEntity te = this.getTile();
        ItemStack eq = player.func_71045_bC();
        if (Platform.isWrench(player, eq, te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
            this.isLocked = !this.isLocked;
            player.func_145747_a((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).get());
            this.getHost().markForUpdate();
        } else if (!this.isLocked) {
            this.configuredItem = AEItemStack.create(eq);
            this.configureWatchers();
            this.getHost().markForUpdate();
        } else {
            this.extractItem(player);
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        try {
            if (this.configuredItem != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add(this.configuredItem);
                }
                this.updateReportingValue(this.getProxy().getStorage().getItemInventory());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void extractItem(EntityPlayer player) {
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> itemInventory) {
        if (this.configuredItem != null) {
            IAEItemStack result = itemInventory.getStorageList().findPrecise(this.configuredItem);
            if (result == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(result.getStackSize());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dspList != null) {
            TickHandler.INSTANCE.scheduleCallListDelete(this.dspList);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper rh, RenderBlocks renderer) {
        if (this.dspList == null) {
            this.dspList = GLAllocation.func_74526_a((int)1);
        }
        Tessellator tess = Tessellator.field_78398_a;
        if ((this.getClientFlags() & 0x14) != 20) {
            return;
        }
        IAEItemStack ais = (IAEItemStack)this.getDisplayed();
        if (ais != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            if (this.updateList) {
                this.updateList = false;
                GL11.glNewList((int)this.dspList, (int)4865);
                this.tesrRenderScreen(tess, ais);
                GL11.glEndList();
            } else {
                GL11.glCallList((int)this.dspList);
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @Override
    public IAEStack<?> getDisplayed() {
        return this.configuredItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tesrRenderScreen(Tessellator tess, IAEItemStack ais) {
        ForgeDirection d = this.getSide();
        GL11.glTranslated((double)((double)d.offsetX * 0.77), (double)((double)d.offsetY * 0.77), (double)((double)d.offsetZ * 0.77));
        switch (d) {
            case UP: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((float)this.getSpin() * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((float)this.getSpin() * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        try {
            ItemStack sis = ais.getItemStack();
            sis.field_77994_a = 1;
            int br = 0x1000100;
            int var11 = 256;
            int var12 = 256;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.8f, (float)204.8f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)32826);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            ClientHelper.proxy.doRenderItem(sis, this.getTile().func_145831_w());
        }
        catch (Exception e) {
            AELog.debug(e);
        }
        finally {
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
        }
        this.tesrRenderItemNumber(ais);
    }

    public void tesrRenderItemNumber(IAEItemStack ais) {
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
        GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        long stackSize = ais.getStackSize();
        String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedStackSize);
        GL11.glTranslatef((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(renderedStackSize, 0, 0, 0);
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (this.configuredItem != null) {
            if (fullStack == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(fullStack.getStackSize());
            }
            long stackSize = this.configuredItem.getStackSize();
            String humanReadableText = NUMBER_CONVERTER.toWideReadableForm(stackSize);
            if (!humanReadableText.equals(this.lastHumanReadableText)) {
                this.lastHumanReadableText = humanReadableText;
                this.getHost().markForUpdate();
            }
        }
    }

    @Override
    public boolean showNetworkInfo(MovingObjectPosition where) {
        return false;
    }
}

