/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.NetworkMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassThrough;
import appeng.me.storage.NetworkInventoryHandler;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public class StorageBusInventoryHandler<T extends IAEStack<T>>
extends MEInventoryHandler<T> {
    private static final ThreadLocal<Map<Integer, Map<NetworkInventoryHandler<?>, IItemList<?>>>> networkItemsForIteration = new ThreadLocal();

    public StorageBusInventoryHandler(IMEInventory<T> i, StorageChannel channel) {
        super(i, channel);
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out, int iteration) {
        if (!this.hasReadAccess && !this.isVisible()) {
            return out;
        }
        if (this.isExtractFilterActive() && !this.getExtractPartitionList().isEmpty()) {
            return this.filterAvailableItems(out, iteration);
        }
        return this.getAvailableItems(out, iteration, e -> true);
    }

    @Override
    protected IItemList<T> filterAvailableItems(IItemList<T> out, int iteration) {
        Predicate filterCondition = this.getExtractFilterCondition();
        this.getAvailableItems(out, iteration, filterCondition);
        return out;
    }

    private IItemList<T> getAvailableItems(IItemList<T> out, int iteration, Predicate<T> filterCondition) {
        IItemList<T> allAvailableItems = this.getAllAvailableItems(iteration);
        Iterator<T> it = allAvailableItems.iterator();
        while (it.hasNext()) {
            IAEStack items = (IAEStack)it.next();
            if (!filterCondition.test(items)) continue;
            out.add(items);
            it.remove();
        }
        return out;
    }

    private IItemList<T> getAllAvailableItems(int iteration) {
        Map<NetworkInventoryHandler<?>, IItemList<?>> networkInventoryItems;
        NetworkInventoryHandler<T> networkInventoryHandler = this.getNetworkInventoryHandler();
        if (networkInventoryHandler == null) {
            return this.getInternal().getAvailableItems(this.getInternal().getChannel().createList(), iteration);
        }
        Map<Integer, Map<NetworkInventoryHandler<?>, IItemList<?>>> s = networkItemsForIteration.get();
        if (s != null && !s.containsKey(iteration)) {
            s = null;
        }
        if (s == null) {
            s = Collections.singletonMap(iteration, new IdentityHashMap());
            networkItemsForIteration.set(s);
        }
        if (!(networkInventoryItems = s.get(iteration)).containsKey(networkInventoryHandler)) {
            IItemList allAvailableItems = this.getInternal().getAvailableItems(this.getInternal().getChannel().createList(), iteration);
            networkInventoryItems.put(networkInventoryHandler, allAvailableItems);
        }
        return networkInventoryItems.get(networkInventoryHandler);
    }

    private NetworkInventoryHandler<T> getNetworkInventoryHandler() {
        return this.findNetworkInventoryHandler(this.getInternal());
    }

    private NetworkInventoryHandler<?> findNetworkInventoryHandler(IMEInventory<?> inventory) {
        if (inventory instanceof MEPassThrough) {
            MEPassThrough passThrough = (MEPassThrough)inventory;
            return this.findNetworkInventoryHandler(passThrough.getInternal());
        }
        if (inventory instanceof NetworkMonitor) {
            NetworkMonitor networkMonitor = (NetworkMonitor)inventory;
            return this.findNetworkInventoryHandler(networkMonitor.getHandler());
        }
        if (inventory instanceof NetworkInventoryHandler) {
            NetworkInventoryHandler networkInventoryHandler = (NetworkInventoryHandler)inventory;
            return networkInventoryHandler;
        }
        return null;
    }
}

