/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.PriorityCardMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.items.AEBaseItem;
import appeng.items.contents.PriorityCardObject;
import appeng.parts.AEBasePart;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolPriorityCard
extends AEBaseItem
implements IGuiItem {
    public ToolPriorityCard() {
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_77625_d(1);
    }

    @Override
    protected void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        GuiText guiText;
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        lines.add(GuiText.PriorityCardTooltip.getLocal());
        switch (ToolPriorityCard.getMode(stack)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EDIT: {
                guiText = GuiText.PriorityCardTooltipModeEdit;
                break;
            }
            case VIEW: {
                guiText = GuiText.PriorityCardTooltipModeView;
                break;
            }
            case SET: {
                guiText = GuiText.PriorityCardTooltipModeSet;
                break;
            }
            case INC: {
                guiText = GuiText.PriorityCardTooltipModeInc;
                break;
            }
            case DEC: {
                guiText = GuiText.PriorityCardTooltipModeDec;
            }
        }
        GuiText mode = guiText;
        lines.add(mode.getLocal());
    }

    public ItemStack func_77659_a(ItemStack it, World w, EntityPlayer p) {
        if (p.func_70093_af()) {
            if (Platform.isServer()) {
                Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_PRIORITY_CARD);
            }
            p.func_71038_i();
        }
        return it;
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, World world, int x, int y, int z) {
        return new PriorityCardObject(is, x);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void handleUse(EntityPlayer player, AEBaseTile tile, ItemStack stack, ForgeDirection side) {
        if (Platform.isClient()) {
            return;
        }
        if (tile instanceof IPriorityHost) {
            IPriorityHost iph = (IPriorityHost)((Object)tile);
            if (tile instanceof IActionHost) {
                IActionHost iah = (IActionHost)((Object)tile);
                ToolPriorityCard.handleUse(player, tile, iph, iah, stack, side);
                return;
            }
        }
        player.func_145747_a(PlayerMessages.PriorityInvalidTarget.get());
    }

    public static void handleUse(EntityPlayer player, AEBasePart part, ItemStack stack, ForgeDirection side) {
        if (Platform.isClient()) {
            return;
        }
        if (part instanceof IPriorityHost) {
            IPriorityHost iph = (IPriorityHost)((Object)part);
            ToolPriorityCard.handleUse(player, part.getTile(), iph, part, stack, side);
        } else {
            player.func_145747_a(PlayerMessages.PriorityInvalidTarget.get());
        }
    }

    private static void handleUse(EntityPlayer player, TileEntity tile, IPriorityHost priorityHost, IActionHost actionHost, ItemStack stack, ForgeDirection side) {
        if (!ToolPriorityCard.securityCheck(actionHost, player)) {
            return;
        }
        switch (ToolPriorityCard.getMode(stack)) {
            case EDIT: {
                Platform.openGUI(player, tile, side, GuiBridge.GUI_PRIORITY);
                break;
            }
            case VIEW: {
                player.func_145747_a(PlayerMessages.PriorityReadout.get(priorityHost.getPriority()));
                break;
            }
            case SET: {
                priorityHost.setPriority(ToolPriorityCard.getPriority(stack));
                player.func_145747_a(PlayerMessages.PriorityConfigured.get(priorityHost.getPriority()));
                break;
            }
            case INC: {
                int priority = ToolPriorityCard.getPriority(stack);
                priorityHost.setPriority(priority);
                ToolPriorityCard.setPriority(stack, priority + 1);
                player.func_145747_a(PlayerMessages.PriorityConfigured.get(priorityHost.getPriority()));
                break;
            }
            case DEC: {
                int priority = ToolPriorityCard.getPriority(stack);
                priorityHost.setPriority(priority);
                ToolPriorityCard.setPriority(stack, priority - 1);
                player.func_145747_a(PlayerMessages.PriorityConfigured.get(priorityHost.getPriority()));
            }
        }
    }

    private static boolean securityCheck(IActionHost actionHost, EntityPlayer player) {
        IGrid g;
        IGridNode gn = actionHost.getActionableNode();
        if (gn != null && (g = gn.getGrid()) != null) {
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            return sg.hasPermission(player, SecurityPermissions.BUILD);
        }
        return false;
    }

    public static int getPriority(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("priority");
        }
        return 0;
    }

    public static void setPriority(ItemStack stack, int priority) {
        Platform.openNbtData(stack).func_74768_a("priority", priority);
    }

    private static PriorityCardMode getMode(ItemStack stack) {
        NBTTagCompound tagCompound = Platform.openNbtData(stack);
        try {
            if (tagCompound.func_74764_b(Settings.PRIORITY_CARD_MODE.name())) {
                return PriorityCardMode.valueOf(tagCompound.func_74779_i(Settings.PRIORITY_CARD_MODE.name()));
            }
        }
        catch (IllegalArgumentException e) {
            AELog.debug(e);
        }
        return PriorityCardMode.EDIT;
    }
}

