/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.IGridHost;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerPatternMulti;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPatternTermEx;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class PacketPatternMultiSet
extends AppEngPacket {
    private final GuiBridge originGui;
    private final int multi;

    public PacketPatternMultiSet(ByteBuf stream) {
        this.originGui = GuiBridge.values()[stream.readInt()];
        this.multi = stream.readInt();
    }

    public PacketPatternMultiSet(int originalGui, int multi) {
        this.originGui = GuiBridge.values()[originalGui];
        this.multi = multi;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(originalGui);
        data.writeInt(this.multi);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerOpenContext context;
        ContainerPatternMulti cpv;
        Object target;
        Container container = player.field_71070_bA;
        if (container instanceof ContainerPatternMulti && (target = (cpv = (ContainerPatternMulti)container).getTarget()) instanceof IGridHost && (context = cpv.getOpenContext()) != null) {
            TileEntity te = context.getTile();
            Platform.openGUI(player, te, cpv.getOpenContext().getSide(), this.originGui);
            Container container2 = player.field_71070_bA;
            if (container2 instanceof ContainerPatternTerm) {
                ContainerPatternTerm cpt = (ContainerPatternTerm)container2;
                cpt.multiplyOrDivideStacks(this.multi);
            } else {
                container2 = player.field_71070_bA;
                if (container2 instanceof ContainerPatternTermEx) {
                    ContainerPatternTermEx cpt = (ContainerPatternTermEx)container2;
                    cpt.multiplyOrDivideStacks(this.multi);
                }
            }
        }
    }
}

