/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.ClientHelper;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerPatternMulti;
import appeng.container.implementations.ContainerPatternValueAmount;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class PacketInventoryAction
extends AppEngPacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final IAEItemStack slotItem;

    public PacketInventoryAction(ByteBuf stream) throws IOException {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        boolean hasItem = stream.readBoolean();
        this.slotItem = hasItem ? AEItemStack.loadItemStackFromPacket(stream) : null;
    }

    public PacketInventoryAction(InventoryAction action, int slot, IAEItemStack slotItem) throws IOException {
        if (Platform.isClient()) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    public PacketInventoryAction(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.writeBoolean(false);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        Container container = sender.field_71070_bA;
        if (container instanceof AEBaseContainer) {
            ContainerOpenContext context;
            AEBaseContainer baseContainer = (AEBaseContainer)container;
            if (this.action == InventoryAction.AUTO_CRAFT) {
                context = baseContainer.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    Platform.openGUI((EntityPlayer)sender, te, baseContainer.getOpenContext().getSide(), GuiBridge.GUI_CRAFTING_AMOUNT);
                    Container container2 = sender.field_71070_bA;
                    if (container2 instanceof ContainerCraftAmount) {
                        ContainerCraftAmount cca = (ContainerCraftAmount)container2;
                        if (baseContainer.getTargetStack() != null) {
                            cca.getCraftingItem().func_75215_d(baseContainer.getTargetStack().getItemStack());
                            cca.setItemToCraft(baseContainer.getTargetStack());
                        }
                        cca.func_75142_b();
                    }
                }
            } else if (this.action == InventoryAction.SET_PATTERN_VALUE) {
                context = baseContainer.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    Platform.openGUI((EntityPlayer)sender, te, baseContainer.getOpenContext().getSide(), GuiBridge.GUI_PATTERN_VALUE_AMOUNT);
                    Container container3 = sender.field_71070_bA;
                    if (container3 instanceof ContainerPatternValueAmount) {
                        ContainerPatternValueAmount cpv = (ContainerPatternValueAmount)container3;
                        if (baseContainer.getTargetStack() != null) {
                            cpv.setValueIndex(this.slot);
                            cpv.getPatternValue().func_75215_d(baseContainer.getTargetStack().getItemStack());
                        }
                        cpv.func_75142_b();
                    }
                }
            } else if (this.action == InventoryAction.SET_PATTERN_MULTI) {
                context = baseContainer.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    Platform.openGUI((EntityPlayer)sender, te, baseContainer.getOpenContext().getSide(), GuiBridge.GUI_PATTERN_MULTI);
                    Container container4 = sender.field_71070_bA;
                    if (container4 instanceof ContainerPatternMulti) {
                        ContainerPatternMulti cpm = (ContainerPatternMulti)container4;
                        cpm.func_75142_b();
                    }
                }
            } else {
                baseContainer.doAction(sender, this.action, this.slot, this.id);
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        if (this.action == InventoryAction.UPDATE_HAND) {
            if (this.slotItem == null) {
                ClientHelper.proxy.getPlayers().get((int)0).field_71071_by.func_70437_b(null);
            } else {
                ClientHelper.proxy.getPlayers().get((int)0).field_71071_by.func_70437_b(this.slotItem.getItemStack());
            }
        }
    }
}

