/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.TmpFlippableIcon;
import appeng.tile.AEBaseTile;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRenderInfo {
    private final BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> rendererInstance;
    private final ThreadLocal<ThreadState> threadState = ThreadLocal.withInitial(() -> new ThreadState());
    private FlippableIcon topIcon = null;
    private FlippableIcon bottomIcon = null;
    private FlippableIcon southIcon = null;
    private FlippableIcon northIcon = null;
    private FlippableIcon eastIcon = null;
    private FlippableIcon westIcon = null;

    public BlockRenderInfo(BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> inst) {
        this.rendererInstance = inst;
    }

    public void updateIcons(FlippableIcon bottom, FlippableIcon top, FlippableIcon north, FlippableIcon south, FlippableIcon east, FlippableIcon west) {
        this.topIcon = top;
        this.bottomIcon = bottom;
        this.southIcon = south;
        this.northIcon = north;
        this.eastIcon = east;
        this.westIcon = west;
    }

    public void setTemporaryRenderIcon(IIcon icon) {
        ThreadState state = this.threadState.get();
        if (icon == null) {
            state.useTmp = false;
        } else {
            state.useTmp = true;
            state.tmpTopIcon.setOriginal(icon);
            state.tmpBottomIcon.setOriginal(icon);
            state.tmpSouthIcon.setOriginal(icon);
            state.tmpNorthIcon.setOriginal(icon);
            state.tmpEastIcon.setOriginal(icon);
            state.tmpWestIcon.setOriginal(icon);
        }
    }

    public void setTemporaryRenderIcons(IIcon nTopIcon, IIcon nBottomIcon, IIcon nSouthIcon, IIcon nNorthIcon, IIcon nEastIcon, IIcon nWestIcon) {
        ThreadState state = this.threadState.get();
        state.tmpTopIcon.setOriginal(nTopIcon == null ? this.getTexture(ForgeDirection.UP) : nTopIcon);
        state.tmpBottomIcon.setOriginal(nBottomIcon == null ? this.getTexture(ForgeDirection.DOWN) : nBottomIcon);
        state.tmpSouthIcon.setOriginal(nSouthIcon == null ? this.getTexture(ForgeDirection.SOUTH) : nSouthIcon);
        state.tmpNorthIcon.setOriginal(nNorthIcon == null ? this.getTexture(ForgeDirection.NORTH) : nNorthIcon);
        state.tmpEastIcon.setOriginal(nEastIcon == null ? this.getTexture(ForgeDirection.EAST) : nEastIcon);
        state.tmpWestIcon.setOriginal(nWestIcon == null ? this.getTexture(ForgeDirection.WEST) : nWestIcon);
        state.useTmp = true;
    }

    public boolean hasTemporaryRenderIcons() {
        return this.threadState.get().useTmp;
    }

    public FlippableIcon getTexture(ForgeDirection dir) {
        ThreadState state = this.threadState.get();
        if (state.useTmp) {
            switch (dir) {
                case DOWN: {
                    return state.tmpBottomIcon;
                }
                case UP: {
                    return state.tmpTopIcon;
                }
                case NORTH: {
                    return state.tmpNorthIcon;
                }
                case SOUTH: {
                    return state.tmpSouthIcon;
                }
                case EAST: {
                    return state.tmpEastIcon;
                }
                case WEST: {
                    return state.tmpWestIcon;
                }
            }
        }
        switch (dir) {
            case DOWN: {
                return this.bottomIcon;
            }
            case UP: {
                return this.topIcon;
            }
            case NORTH: {
                return this.northIcon;
            }
            case SOUTH: {
                return this.southIcon;
            }
            case EAST: {
                return this.eastIcon;
            }
            case WEST: {
                return this.westIcon;
            }
        }
        return this.topIcon;
    }

    boolean isValid() {
        return this.topIcon != null && this.bottomIcon != null && this.southIcon != null && this.northIcon != null && this.eastIcon != null && this.westIcon != null;
    }

    public BaseBlockRender getRendererInstance() {
        return this.rendererInstance;
    }

    private static class ThreadState {
        private boolean useTmp = false;
        private final TmpFlippableIcon tmpTopIcon = new TmpFlippableIcon();
        private final TmpFlippableIcon tmpBottomIcon = new TmpFlippableIcon();
        private final TmpFlippableIcon tmpSouthIcon = new TmpFlippableIcon();
        private final TmpFlippableIcon tmpNorthIcon = new TmpFlippableIcon();
        private final TmpFlippableIcon tmpEastIcon = new TmpFlippableIcon();
        private final TmpFlippableIcon tmpWestIcon = new TmpFlippableIcon();

        private ThreadState() {
        }
    }
}

