/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import appeng.core.localization.GuiColors;
import codechicken.nei.FormattedTextField;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;

public class MEGuiTextField
implements ITooltip {
    protected GuiTextField field;
    private static final int PADDING = 2;
    private static boolean previousKeyboardRepeatEnabled;
    private static MEGuiTextField previousKeyboardRepeatEnabledField;
    private Method setFormatterMethod;
    private String tooltip;
    private int fontPad;
    public int x;
    public int y;
    public int w;
    public int h;

    public MEGuiTextField(int width, int height, String tooltip) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        try {
            Class<?> formattedTextFieldClass = Class.forName("codechicken.nei.FormattedTextField");
            Constructor<?> defaultConstructor = formattedTextFieldClass.getConstructor(FontRenderer.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.field = (GuiTextField)defaultConstructor.newInstance(fontRenderer, 0, 0, 0, 0);
            this.setFormatterMethod = formattedTextFieldClass.getMethod("setFormatter", FormattedTextField.TextFormatter.class);
        }
        catch (Throwable __) {
            this.field = new GuiTextField(fontRenderer, 0, 0, 0, 0);
        }
        this.w = width;
        this.h = height;
        this.field.func_146185_a(false);
        this.field.func_146203_f(256);
        this.field.func_146193_g(GuiColors.SearchboxText.getColor());
        this.field.func_146196_d();
        this.setMessage(tooltip);
        this.fontPad = fontRenderer.func_78263_a('_');
        this.setDimensionsAndColor();
    }

    public MEGuiTextField(int width, int height) {
        this(width, height, "");
    }

    public MEGuiTextField() {
        this(0, 0);
    }

    public void setFormatter(Object formatter) {
        if (this.setFormatterMethod != null) {
            try {
                this.setFormatterMethod.invoke((Object)this.field, formatter);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void setDimensionsAndColor() {
        this.field.field_146209_f = this.x + 2;
        this.field.field_146210_g = this.y + 2;
        this.field.field_146218_h = this.w - 4 - this.fontPad;
        this.field.field_146219_i = this.h - 4;
    }

    public void onTextChange(String oldText) {
    }

    public void mouseClicked(int xPos, int yPos, int button) {
        if (!this.isMouseIn(xPos, yPos)) {
            this.setFocused(false);
            return;
        }
        this.field.func_146205_d(false);
        this.setFocused(true);
        if (button == 1) {
            this.setText("");
        } else {
            this.field.func_146192_a(xPos, yPos, button);
        }
        this.field.func_146205_d(true);
    }

    public boolean isMouseIn(int xCoord, int yCoord) {
        boolean withinXRange = this.x <= xCoord && xCoord < this.x + this.w;
        boolean withinYRange = this.y <= yCoord && yCoord < this.y + this.h;
        return withinXRange && withinYRange;
    }

    public boolean textboxKeyTyped(char keyChar, int keyID) {
        if (!this.isFocused()) {
            return false;
        }
        String oldText = this.getText();
        boolean handled = this.field.func_146201_a(keyChar, keyID);
        if (!(handled || keyID != 28 && keyID != 156 && keyID != 1)) {
            this.setFocused(false);
        }
        if (handled) {
            this.onTextChange(oldText);
        }
        return handled;
    }

    public void drawTextBox() {
        if (this.field.func_146176_q()) {
            this.setDimensionsAndColor();
            GuiTextField.func_73734_a((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.w - 1), (int)(this.y + this.h - 1), (int)(this.isFocused() ? GuiColors.SearchboxFocused.getColor() : GuiColors.SearchboxUnfocused.getColor()));
            this.field.func_146194_f();
        }
    }

    public void setText(String text, boolean ignoreTrigger) {
        String oldText = this.getText();
        int currentCursorPos = this.field.func_146198_h();
        this.field.func_146180_a(text);
        this.field.func_146190_e(currentCursorPos);
        if (!ignoreTrigger) {
            this.onTextChange(oldText);
        }
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public void setCursorPositionEnd() {
        this.field.func_146202_e();
    }

    public void setFocused(boolean focus) {
        if (this.field.func_146206_l() == focus) {
            return;
        }
        this.field.func_146195_b(focus);
        if (focus) {
            if (previousKeyboardRepeatEnabledField == null) {
                previousKeyboardRepeatEnabled = Keyboard.areRepeatEventsEnabled();
            }
            previousKeyboardRepeatEnabledField = this;
            Keyboard.enableRepeatEvents((boolean)true);
        } else if (previousKeyboardRepeatEnabledField == this) {
            previousKeyboardRepeatEnabledField = null;
            Keyboard.enableRepeatEvents((boolean)previousKeyboardRepeatEnabled);
        }
    }

    public void setMaxStringLength(int size) {
        this.field.func_146203_f(size);
    }

    public boolean isFocused() {
        return this.field.func_146206_l();
    }

    public String getText() {
        return this.field.func_146179_b();
    }

    public void setMessage(String t) {
        this.tooltip = t;
    }

    @Override
    public String getMessage() {
        return this.tooltip;
    }

    @Override
    public boolean isVisible() {
        return this.field.func_146176_q();
    }

    @Override
    public int xPos() {
        return this.x;
    }

    @Override
    public int yPos() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    @Override
    public int getHeight() {
        return this.h;
    }
}

