/*
 * Decompiled with CFR 0.152.
 */
package com.Ephemeral_12.m3ecore.mixins;

import cpw.mods.fml.common.Loader;
import io.github.tox1cozz.mixinbooterlegacy.ILateMixinLoader;
import io.github.tox1cozz.mixinbooterlegacy.LateMixin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@LateMixin
public class M3ELateMixinLoader
implements ILateMixinLoader {
    public static final Logger LOG = LogManager.getLogger((String)"M3E");
    public static final String LOG_PREFIX = "[M3E] ";
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier supplier = MIXIN_CONFIGS.get(mixinConfig);
        if (supplier == null) {
            LOG.warn("[M3E] Mixin config {} is not found in config map! It will never be loaded.", new Object[]{mixinConfig});
            return false;
        }
        return supplier.getAsBoolean();
    }

    private static boolean modLoaded(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID) {
        MIXIN_CONFIGS.put(mixinConfig, () -> M3ELateMixinLoader.modLoaded(modID));
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID, String ... modIDs) {
        MIXIN_CONFIGS.put(mixinConfig, () -> M3ELateMixinLoader.modLoaded(modID) && Arrays.stream(modIDs).allMatch(Loader::isModLoaded));
    }

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    static {
        M3ELateMixinLoader.addMixinCFG("mixins.m3e_core.json");
    }
}

