/*
 * Decompiled with CFR 0.152.
 */
package com.Ephemeral_12.m3ecore.hander;

import com.Ephemeral_12.m3ecore.event.Reward;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;

public class DistributeItemHander {
    public static DistributeItemHander INSTANCE = new DistributeItemHander();
    private static final Map<String, List<Reward>> rewardTable = new LinkedHashMap<String, List<Reward>>();

    private DistributeItemHander() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        String playerUUID = player.func_110124_au().toString();
        NBTTagCompound playerData = player.getEntityData();
        String currentVersion = this.getPlayerVersion(player);
        for (Map.Entry<String, List<Reward>> entry : rewardTable.entrySet()) {
            String version = entry.getKey();
            List<Reward> versionRewards = entry.getValue();
            if (!this.isVersionEligible(currentVersion, version)) continue;
            for (Reward reward : versionRewards) {
                if (!reward.getPlayers().contains(player.func_70005_c_())) continue;
                this.giveReward(player, reward.getItemID());
            }
            currentVersion = version;
        }
        playerData.func_74778_a(playerUUID + "_version", this.getLatestVersion());
        player.func_145747_a((IChatComponent)new ChatComponentText("Welcome to ManaMetalMod:Exploration"));
    }

    private String getPlayerVersion(EntityPlayer player) {
        NBTTagCompound playerData = player.getEntityData();
        return playerData.func_74764_b(player.func_110124_au().toString() + "_version") ? playerData.func_74779_i(player.func_110124_au().toString() + "_version") : "0.0";
    }

    private String getLatestVersion() {
        Iterator<Map.Entry<String, List<Reward>>> iterator = rewardTable.entrySet().iterator();
        String latestVersion = null;
        while (iterator.hasNext()) {
            latestVersion = iterator.next().getKey();
        }
        return latestVersion;
    }

    private boolean isVersionEligible(String currentVersion, String entryVersion) {
        return currentVersion.compareTo(entryVersion) < 0;
    }

    public void giveReward(EntityPlayer player, String itemID) {
        String[] parts;
        if (itemID != null && (parts = itemID.split(":")).length >= 2) {
            ItemStack itemStack;
            String modId = parts[0];
            String itemName = parts[1];
            int meta = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
            Item rewardItem = GameRegistry.findItem((String)modId, (String)itemName);
            if (rewardItem != null && !player.field_71071_by.func_70441_a(itemStack = new ItemStack(rewardItem, 1, meta))) {
                player.func_145747_a((IChatComponent)new ChatComponentText("\u9473\u5c7d\u5bd8\u5bb8\u53c9\u5f27\u947e\u5cf0\u5f47\u6fb6\u8fab\u89e6"));
            }
        }
    }

    static {
        rewardTable.put("0.1", Arrays.asList(new Reward("m3ecore:Title:0", "ohxihh"), new Reward("m3ecore:Title:1", "yaoyaoDream"), new Reward("m3ecore:Title:2", "Circulation_"), new Reward("m3ecore:Title:3", "Ephemeral_12"), new Reward("m3ecore:Title:4", "Fallen_sky2"), new Reward("m3ecore:Title:5", "mingyue2333"), new Reward("m3ecore:Title:6", "WI_8614_ice")));
        rewardTable.put("0.2", Arrays.asList(new Reward("lootplusplus:developer_commemorative_pickaxe", "ohxihh", "yaoyaoDream", "Circulation_", "Ephemeral_12", "Fallen_sky2", "mingyue2333", "WI_8614_ice"), new Reward("manametalmod:Strawberry_crop:1", "dragon060810")));
        rewardTable.put("0.3", Arrays.asList(new Reward("m3ecore:Title:7", "LengTongY"), new Reward("m3ecore:Title:8", "wstt")));
        rewardTable.put("0.4", Arrays.asList(new Reward("m3ecore:Title:100", "Dounts_rua"), new Reward("m3ecore:Title:101", "wuyin"), new Reward("m3ecore:Title:102", "daixianzhe"), new Reward("m3ecore:Title:103", "wstt"), new Reward("m3ecore:Title:104", "LiuMing324"), new Reward("m3ecore:Title:105", "Sylvie"), new Reward("m3ecore:Title:10", "Sylvie", "dh_nei", "Syuuiku", "wstt"), new Reward("m3ecore:Title:12", "wuyule"), new Reward("m3ecore:Title:51", "Xiaolangplus"), new Reward("m3ecore:Title:106", "SilveryLepton")));
        rewardTable.put("0.9", Arrays.asList(new Reward("M3ExplorationCore:book_of_penance", "wuyin", "daixianzhe"), new Reward("M3ExplorationCore:angel_D8", "daixianzhe"), new Reward("M3ExplorationCore:eucharist", "Vliving"), new Reward("M3ExplorationCore:peering_light", "ximen", "Vliving"), new Reward("M3ExplorationCore:requiem_for_the_holy_spirit", "Ephemeral_12", "wuyin"), new Reward("M3ExplorationCore:holy_sword", "Ji2")));
        rewardTable.put("1.0", Arrays.asList(new Reward("m3ecore:Antiquities:0", "Fallen_sky2", "Sylvie", "Ephemeral_12", "Pofocuft", "TrSKill", "ximen"), new Reward("M3ExplorationCore:requiem_for_the_holy_spirit", "Ji2", "daixianzhe", "Fallen_sky2", "Pofocuft", "Fate_yukikaze", "Iron_F"), new Reward("M3ExplorationCore:treasure_bowl", "Ephemeral_12", "Sylvie", "wuyin", "mefi", "Urara_Cream", "Pofocuft", "ximen"), new Reward("M3ExplorationCore:eucharist", "9thYuZh", "daixianzhe", "wuyin", "Sylvie", "TrSkill", "YoRusang", "jyjz_4371"), new Reward("M3ExplorationCore:peering_light", "Fallen_sky2", "Ji2", "Sylvie", "Sylvie", "Soreda", "Fate_yukikaze", "Urara_Cream"), new Reward("M3ExplorationCore:holy_sword", "daixianzhe", "Sylvie", "9thYuZh", "Sylvie", "Soreda", "Pofocuft", "Iron_F"), new Reward("M3ExplorationCore:book_of_penance", "wuyin", "Ephemeral_12", "Sylvie", "Fallen_sky2", "Ji2", "jiubie233", "Fate_yukikaze", "Urara_Cream", "Soreda", "jyjz_4371"), new Reward("M3ExplorationCore:die_d8", "jiubie233", "Sylvie", "mefi", "Soreda", "jyjz_4371")));
        rewardTable.put("2.0", Arrays.asList(new Reward("minecraft:iron_sword", "", ""), new Reward("minecraft:enchanted_book", "")));
    }
}

