/*
 * Decompiled with CFR 0.152.
 */
package com.Ephemeral_12.m3ecore.Util;

import com.Ephemeral_12.m3ecore.item.M3EBaublesBasic;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.archeology.BlockArcheology;
import project.studio.manametalmod.archeology.IArcheologyTool;
import project.studio.manametalmod.archeology.IArcheologyType;
import project.studio.manametalmod.archeology.TileEntityArcheology;
import project.studio.manametalmod.core.Icommodity;
import project.studio.manametalmod.core.ManaItemType;
import snowdragon.trivialthoughts.TrivialThoughts;
import snowdragon.trivialthoughts.item.ItemLoader;

public class TrTCore {
    public static final int BASE_REWARD_ATTEMPTS = 15;
    public static final int ADVANCED_REWARD_CHANCE = 80;
    public static final int COMMON_REWARD_CHANCE = 16;
    public static final int MAX_ATTEMPTS = 10;

    public static int getCore(EntityPlayer player) {
        ItemStack core = MMM.getEntityNBT((EntityPlayer)player).item.items[36];
        if (core != null && core.func_77973_b() instanceof M3EBaublesBasic && ((M3EBaublesBasic)core.func_77973_b()).getType(core) == ManaItemType.Core) {
            if (core.func_77978_p() != null) {
                return core.func_77978_p().func_74762_e("TrTCore");
            }
            return -1;
        }
        return -1;
    }

    public static boolean validateInteraction(World world, BlockPos pos, EntityPlayer player) {
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        if (!(block instanceof BlockArcheology)) {
            return false;
        }
        ItemStack tool = player.func_70694_bm();
        if (tool == null || !(tool.func_77973_b() instanceof IArcheologyTool)) {
            return false;
        }
        IArcheologyTool archeologyTool = (IArcheologyTool)tool.func_77973_b();
        if (archeologyTool.getType(tool) != IArcheologyType.pickaxe) {
            return false;
        }
        return TrTCore.getCore(player) == 4;
    }

    public static TileEntityArcheology safelyGetTileEntity(World world, BlockPos pos) {
        TileEntity te = world.func_147438_o(pos.x, pos.y, pos.z);
        return te instanceof TileEntityArcheology ? (TileEntityArcheology)te : null;
    }

    public static void handleToolDamage(EntityPlayer player) {
        ItemStack tool = player.func_70694_bm();
        IArcheologyTool iat = (IArcheologyTool)tool.func_77973_b();
        if (iat != null) {
            iat.damageToolItem(tool);
            if (iat.getToolDamage(tool) > iat.maxToolUse(tool)) {
                player.func_70669_a(tool);
                MMM.destroyCurrentEquippedItem((EntityPlayer)player);
            }
        }
    }

    public static void processBlockDestruction(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            MMM.breakBlock((World)world, (int)pos.x, (int)pos.y, (int)pos.z, (boolean)false);
        }
    }

    public static void generateRewards(World world, BlockPos pos, TileEntityArcheology tile) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < 15; ++i) {
            if (!TrTCore.shouldGenerateReward(tile.advanced)) continue;
            TrTCore.generateSingleReward(world, pos, tile);
        }
    }

    public static boolean shouldGenerateReward(boolean advanced) {
        Random rand = TrivialThoughts.ran;
        return advanced ? rand.nextInt(100) < 80 : rand.nextBoolean();
    }

    public static void generateSingleReward(World world, BlockPos pos, TileEntityArcheology tile) {
        if (TrivialThoughts.ran.nextInt(100) < 16) {
            TrTCore.generateCommonReward(world, pos);
        } else {
            TrTCore.generateDungeonSpecificReward(world, pos, tile);
        }
    }

    public static void generateCommonReward(World world, BlockPos pos) {
        ItemStack reward = ((ItemStack)MMM.getRandomItemFromList((List)ManaMetalAPI.ArcheologyAwardsCommon)).func_77946_l();
        TrTCore.spawnRewardEntity(world, pos, reward);
    }

    public static void generateDungeonSpecificReward(World world, BlockPos pos, TileEntityArcheology tile) {
        if (!ManaMetalAPI.ArcheologyAwards.containsKey(tile.DungeonType)) {
            return;
        }
        List rewards = (List)ManaMetalAPI.ArcheologyAwards.get(tile.DungeonType);
        if (rewards == null) {
            return;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            Icommodity reward = (Icommodity)MMM.getRandomItemFromList((List)rewards);
            if (!TrTCore.isValidReward(reward)) continue;
            TrTCore.spawnRewardEntity(world, pos, reward.getItem().func_77946_l());
            break;
        }
    }

    public static boolean isValidReward(Icommodity reward) {
        return TrivialThoughts.ran.nextInt(100) < reward.getPrice() && reward.getItem().func_77973_b() != ItemLoader.trtItemCore;
    }

    public static void spawnRewardEntity(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, stack));
        }
    }
}

